DELETE FROM REPORTS;
INSERT INTO `REPORTS` VALUES (1,'PRODUCTS LIST','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>PRODUCTS LIST</title>\r\n<script><![CDATA[ SELECT PRODUCTS.ID, PRODUCTS.CATEGORY, PRODUCTS.NAME,PRODUCTS.PRICESELL,PRODUCTS.PRICESELL*(1+TAXES.RATE) AS PRICETAX,PRODUCTS.PRICEBUY,PRODUCTS.CODE,CATEGORIES.NAME AS CATEGORYNAME FROM PRODUCTS LEFT JOIN CATEGORIES ON CATEGORIES.ID=PRODUCTS.CATEGORY  \r\nJOIN TAXCATEGORIES ON PRODUCTS.TAXCAT=TAXCATEGORIES .ID JOIN TAXES ON TAXES.CATEGORY=TAXCATEGORIES.ID \r\nWHERE ? ORDER BY CATEGORIES.NAME,PRODUCTS.NAME ]]></script>\r\n<filters>\r\n<filter title=\"Name\" field=\"PRODUCTS.NAME\" name=\"NAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Barcode\" field=\"PRODUCTS.CODE\" name=\"CODE\" type=\"text\" operator=\"=\" value=\"\" />\r\n<filter title=\"Category\" field=\"PRODUCTS.CATEGORY\" name=\"CATEGORY\" type=\"list\" operator=\"=\" value=\"{SELECT ID, NAME FROM CATEGORIES}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Category\" field=\"CATEGORYNAME\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Barcode\" field=\"CODE\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Name\" field=\"NAME\" width=\"300px\" align=\"left\" type=\"text\" />\r\n<column title=\"Price buy\" field=\"PRICEBUY\" width=\"100px\" align=\"Right\" type=\"currency\" />\r\n<column title=\"Price sell\" field=\"PRICESELL\" width=\"100px\" align=\"Right\" type=\"currency\" />\r\n<column title=\"Price sell+tax\" field=\"PRICETAX\" width=\"100px\" align=\"Right\" type=\"currency\" />\r\n</columns>\r\n</report>'),(2,'PURCHASE INVOICE','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>PURCHASE INVOICE</title>\r\n<script><![CDATA[  SELECT * from (SELECT (COALESCE(FirstSet.TOTAL,0)+COALESCE(ThirdSet.TAXAMOUNT,0)+COALESCE(SecondSet.FREIGHTAMOUNT,0)+COALESCE(SecondSet.DISCOUNT,0)+COALESCE(SecondSet.ADJUSTMENT,0)) AS TOTALAMOUNT,\r\n	COALESCE(FourthSet.PAIDAMOUNT,0) as PAIDAMOUNT,\r\nROUND(((COALESCE(FirstSet.TOTAL,0)+COALESCE(ThirdSet.TAXAMOUNT,0)+COALESCE(SecondSet.FREIGHTAMOUNT,0)+COALESCE(SecondSet.DISCOUNT,0)+COALESCE(SecondSet.ADJUSTMENT,0))+COALESCE(FourthSet.PAIDAMOUNT,0)),5) AS BALANCE,\r\n\r\nIF(ROUND(((COALESCE(FirstSet.TOTAL,0)+COALESCE(ThirdSet.TAXAMOUNT,0)+COALESCE(SecondSet.FREIGHTAMOUNT,0)+COALESCE(SecondSet.DISCOUNT,0)+COALESCE(SecondSet.ADJUSTMENT,0))+COALESCE(FourthSet.PAIDAMOUNT,0)),2)<>0, \'PENDING\', \'PAID\') AS PAIDSTATUS,\r\n\r\n    FirstSet.PLID,\r\n    SecondSet.*,CASE SecondSet.status \r\n  WHEN 1 THEN \'Created\' \r\n  WHEN 2 THEN \'Submitted\'  \r\n  WHEN -1 THEN \'Returned\'\r\n  WHEN -2 THEN \'Return submitted\'\r\n  ELSE \'Created\' \r\nEND as statustext\r\nfrom \r\n(\r\n    SELECT P.*,S.NAME as name FROM PURCHASEINVOICE P LEFT JOIN SUPPLIERS S ON P.SUPPLIERID=S.ID\r\n) as SecondSet\r\nLEFT JOIN\r\n(\r\n    SELECT SUM((COALESCE(PL.QUANTITY,0) * COALESCE(PL.UNITPRICE,0))+COALESCE(PL.DISCOUNT,0)) AS TOTAL,PL.PIID AS PLID FROM PURCHASEINVOICELINES PL GROUP BY PL.PIID\r\n) as FirstSet\r\nON FirstSet.PLID=SecondSet.ID\r\nLEFT JOIN\r\n(\r\n    SELECT SUM((COALESCE(TAXAMOUNT,0))) AS TAXAMOUNT,PIID AS TPIID FROM PURCHASEINVOICETAXES GROUP BY PIID\r\n) as ThirdSet\r\nON SecondSet.ID=ThirdSet.TPIID\r\nLEFT JOIN\r\n(\r\n    SELECT SUM((COALESCE(T.AMOUNT,0))) AS PAIDAMOUNT,PP.PURCHASEINVOICE_ID FROM TRANSACTIONS T LEFT JOIN PURCHASEINVOICE_PAYMENTS PP ON PP.TRANSACTION_ID=T.ID WHERE (T.PAYMENTHEAD_ID=\'PURCHASE\' OR T.PAYMENTHEAD_ID=\'PURCHASERETURN\') AND T.STATUS=1 GROUP BY PP.PURCHASEINVOICE_ID \r\n) as FourthSet\r\nON SecondSet.ID=FourthSet.PURCHASEINVOICE_ID) mytable WHERE ? ORDER BY DELIVERYDATE,CREATEDDATE DESC ]]></script>\r\n<filters>\r\n<filter title=\"From date\" name=\"FDATE\" field=\"DELIVERYDATE\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" name=\"TDATE\" field=\"DELIVERYDATE\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() as DATE}\" />\r\n<filter title=\"Supplier Name\" name=\"NAME\" field=\"NAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Status\" name=\"STATUS\" field=\"STATUS\" type=\"list\" operator=\"=\" value=\"{SELECT 1 AS ID,\'CREATED\' AS NAME UNION SELECT 2 AS ID,\'SUBMITTED\' AS NAME UNION SELECT -1 AS ID,\'RETURNED\' AS NAME UNION SELECT -2 AS ID,\'RETURN SUBMITTED\' AS NAME}\" />\r\n<filter title=\"Payment\" name=\"PAIDSTATUS\" field=\"PAIDSTATUS\" type=\"list\" operator=\"=\" value=\"{SELECT \'PAID\' AS ID,\'PAID\' AS NAME UNION SELECT \'PENDING\' AS ID,\'PENDING\' AS NAME}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Invoice Date\" field=\"DELIVERYDATE\" width=\"100px\" type=\"date\" align=\"Left\" />\r\n<column title=\"Invoice No.\" field=\"REFERENCE\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Supplier\" field=\"name\" width=\"300px\" align=\"left\" type=\"text\" />\r\n<column title=\"Status\" field=\"statustext\" width=\"100px\" align=\"Left\" type=\"\" sum=\"\" />\r\n<column title=\"Total\" field=\"TOTALAMOUNT\" width=\"100px\" align=\"Right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"Paid\" field=\"PAIDAMOUNT\" width=\"100px\" align=\"Right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"Balance\" field=\"BALANCE\" width=\"100px\" align=\"Right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(19,'CLOSED CASH','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>CLOSED CASH REPORT</title>\r\n<script><![CDATA[ SELECT CLOSEDCASH.MONEY AS ID, CLOSEDCASH.HOST, CLOSEDCASH.HOSTSEQUENCE, CLOSEDCASH.DATESTART, CLOSEDCASH.DATEEND, SUM(PAYMENTS.TOTAL) AS TOTAL FROM CLOSEDCASH LEFT JOIN RECEIPTS ON RECEIPTS.MONEY = CLOSEDCASH.MONEY LEFT JOIN PAYMENTS ON PAYMENTS.RECEIPT = RECEIPTS.ID WHERE CLOSEDCASH.DATEEND IS NOT NULL AND ? GROUP BY CLOSEDCASH.MONEY ORDER BY CLOSEDCASH.HOSTSEQUENCE DESC ]]></script>\r\n<filters>\r\n<filter title=\"Station\" name=\'HOST\' field=\"HOST\" type=\"list\" operator=\"=\" value=\"{SELECT HOST as ID, HOST as NAME FROM CLOSEDCASH GROUP BY HOST }\" />\r\n        <filter title=\"From Date\" name=\'FROMDATE\' field=\"DATEEND\" type=\"datetime\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n        <filter title=\"To Date\" name=\'TODATE\' field=\"DATEEND\" type=\"datetime\" operator=\"<=\" value=\"{SELECT CURDATE() AS DATE}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"STATION\" field=\"HOST\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"SEQUENCE\" field=\"HOSTSEQUENCE\" width=\"50px\" align=\"left\" type=\"text\" />\r\n<column title=\"START DATE\" field=\"DATESTART\" width=\"100px\" align=\"left\" type=\"datetime\" sum=\"\" />\r\n<column title=\"END DATE\" field=\"DATEEND\" width=\"100px\" align=\"left\" type=\"datetime\" sum=\"\" />\r\n<column title=\"TOTAL\" field=\"TOTAL\" width=\"100px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(20,'PRODUCT SALES','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>PRODUCT SALES REPORT</title>\r\n<script><![CDATA[ SELECT CP.NAME AS CATEGORY, PRODUCTS.CODE, PRODUCTS.NAME, \r\nSUM(PRODUCTS.PRICEBUY * TICKETLINES.UNITS) AS COST,\r\nSUM(TICKETLINES.UNITS) AS UNITS, \r\nSUM(TICKETLINES.UNITS * TICKETLINES.PRICE) AS TOTAL,\r\nSUM(TICKETLINES.UNITS * TICKETLINES.PRICE) - (SUM(TICKETLINES.UNITS) * PRODUCTS.PRICEBUY)  AS PROFIT,\r\nROUND((SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) - (SUM(TICKETLINES.UNITS) * PRODUCTS.PRICEBUY)) / (SUM(TICKETLINES.UNITS) * PRODUCTS.PRICEBUY) *100,2) AS PCT\r\nFROM TICKETLINES \r\nJOIN RECEIPTS ON RECEIPTS.ID=TICKETLINES.TICKET\r\nJOIN TICKETS ON TICKETS.ID=TICKETLINES.TICKET AND (TICKETS.TICKETTYPE=0 OR TICKETS.TICKETTYPE=1) \r\nLEFT JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID \r\nLEFT JOIN CATEGORIES CP ON PRODUCTS.CATEGORY= CP.ID\r\nWHERE ? GROUP BY TICKETLINES.PRODUCT ORDER BY CP.NAME,PRODUCTS.NAME ]]></script>\r\n<filters>\r\n<filter title=\"Category\" name=\'CATEGORY\' field=\"CP.ID\" type=\"list\" operator=\"=\" value=\"{SELECT ID,NAME from CATEGORIES}\" />\r\n<filter title=\"Product Code\" name=\'CODE\' field=\"PRODUCTS.CODE\" type=\"text\" operator=\"=\" value=\"\" />\r\n<filter title=\"Product Name\" name=\'PRODUCT\' field=\"PRODUCTS.NAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"From date\" name=\"FDATE\" field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" name=\"TDATE\" field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() as DATE}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Category\" field=\"CATEGORY\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Code\" field=\"CODE\" width=\"50px\" align=\"left\" type=\"text\" />\r\n<column title=\"Product\" field=\"NAME\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Units\" field=\"UNITS\" width=\"50px\" align=\"left\" type=\"double\" sum=\"\" />\r\n<column title=\"Cost\" field=\"COST\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"Sale\" field=\"TOTAL\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"Profit\" field=\"PROFIT\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"%\" field=\"PCT\" width=\"50px\" align=\"right\" type=\"text\" sum=\"\" />\r\n</columns>\r\n</report>'),(21,'POPULAR PRODUCTS','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>POPULAR PRODUCTS</title>\r\n<script><![CDATA[ SELECT P.NAME, IFNULL(SUM(TL.UNITS), 0) AS QTY, IFNULL(SUM(TL.UNITS * TL.PRICE), 0) AS AMOUNT \r\nFROM PRODUCTS AS P \r\nJOIN CATEGORIES C2 ON P.CATEGORY=C2.ID\r\nJOIN CATEGORIES C ON (C.ID=P.CATEGORY OR P.CATEGORY IN (SELECT ID FROM CATEGORIES WHERE PARENTID=C.ID))\r\nLEFT JOIN TICKETLINES AS TL ON TL.PRODUCT=P.ID LEFT JOIN TICKETS AS T ON T.ID = TL.TICKET LEFT JOIN RECEIPTS AS R ON R.ID = T.ID WHERE P.ISCOM <> TRUE AND ? GROUP BY P.ID ORDER BY QTY DESC ]]></script>\r\n<filters>\r\n<filter title=\"Category\" name=\'CATEGORY\' field=\"C.ID\" type=\"list\" operator=\"=\" value=\"{SELECT ID,NAME from CATEGORIES}\" />\r\n</filters>\r\n<limit value=\"\" />\r\n<columns>\r\n<column title=\"Product Name\" field=\"NAME\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Quantity\" field=\"QTY\" width=\"50px\" align=\"center\" type=\"text\"  sum=\"true\" />\r\n<column title=\"Amount\" field=\"AMOUNT\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(22,'SALES TAX LOG','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>SALES TAX LOG</title>\r\n<script><![CDATA[ SELECT TICKETS.TICKETID AS TICKET_NO, RECEIPTS.DATENEW AS TICKET_DATE,  \r\n(SUM(TAXLINES.BASE)+SUM(TAXLINES.AMOUNT)) AS MONEY, \r\nSUM(TAXLINES.AMOUNT) AS TAX,  \r\nCASE TICKETS.TICKETTYPE WHEN 0 THEN \'SALE\' WHEN \'1\' THEN \'REFUND\' END AS HEAD \r\nFROM RECEIPTS \r\nJOIN TICKETS ON RECEIPTS.ID = TICKETS.ID AND (TICKETS.TICKETTYPE=0 OR TICKETS.TICKETTYPE=1) \r\nJOIN TAXLINES ON TAXLINES.RECEIPT=RECEIPTS.ID\r\nWHERE ?\r\nGROUP BY RECEIPTS.ID,TAXLINES.RECEIPT\r\nORDER BY RECEIPTS.DATENEW ]]></script>\r\n<filters>\r\n<filter title=\"From Date\" name=\'FDATE\' field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n        <filter title=\"To Date\" name=\'TDATE\' field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() AS DATE}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Reciept\" field=\"TICKET_NO\" width=\"50px\" align=\"left\" type=\"text\" />\r\n<column title=\"Date\" field=\"TICKET_DATE\" width=\"50px\" align=\"left\" type=\"datetime\" />\r\n<column title=\"Type\" field=\"HEAD\" width=\"50px\" align=\"left\" type=\"text\" />\r\n<column title=\"Total\" field=\"MONEY\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"Tax\" field=\"TAX\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(23,'PAYMENTS','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>PAYMENTS REPORT</title>\r\n<script><![CDATA[ SELECT CLOSEDCASH.HOST, ACCOUNTHEADS.NAME,PAYMENTS.PAYMENT, PAYMENTS.NOTES, SUM(PAYMENTS.TOTAL) AS MONEY\r\n FROM PAYMENTS\r\n JOIN RECEIPTS ON PAYMENTS.RECEIPT = RECEIPTS.ID\r\n JOIN ACCOUNTHEADS ON ACCOUNTHEADS.ID = RECEIPTS.ACCOUNTHEAD\r\n LEFT JOIN CLOSEDCASH ON RECEIPTS.MONEY = CLOSEDCASH.MONEY \r\nWHERE ? GROUP BY CLOSEDCASH.HOST,PAYMENTS.PAYMENT ORDER BY CLOSEDCASH.HOST,PAYMENTS.PAYMENT ]]></script>\r\n<filters>\r\n<filter title=\"Payment\" name=\'PAYMENT\' field=\"PAYMENTS.PAYMENT\" type=\"list\" operator=\"=\" value=\"{Select \'cash\' AS ID,\'Cash\' AS NAME UNION\r\nSelect \'magcard\' AS ID,\'Card\' AS NAME UNION\r\nSelect \'currency\' AS ID,\'Currency\' AS NAME UNION\r\nSelect \'currencychange\' AS ID,\'Currency Change\' AS NAME UNION\r\nSelect \'cashin\' AS ID,\'Cash In\' AS NAME UNION\r\nSelect \'cashout\' AS ID,\'Cash Out\' AS NAME UNION\r\nSelect \'cashrefund\' AS ID,\'Refund\' AS NAME UNION\r\nSelect \'cheque\' AS ID,\'Cheque\' AS NAME UNION\r\nSelect \'chequerefund\' AS ID,\'Cheque refund\' AS NAME UNION\r\nSelect \'free\' AS ID,\'Free\' AS NAME UNION\r\nSelect \'magcardrefund\' AS ID,\'Card refund\' AS NAME UNION\r\nSelect \'paperin\' AS ID,\'Voucher in\' AS NAME UNION\r\nSelect \'paperout\' AS ID,\'Voucher out\' AS NAME UNION\r\nSelect \'pointsin\' AS ID,\'Points In\' AS NAME UNION\r\nSelect \'pointsout\' AS ID,\'Points Out\' AS NAME UNION\r\nSelect \'cashcreditpaid\' AS ID,\'Credit paid - Cash\' AS NAME UNION\r\nSelect \'chequecreditpaid\' AS ID,\'Credit paid - Cheque\' AS NAME UNION\r\nSelect \'debt\' AS ID,\'Debt\' AS NAME UNION\r\nSelect \'debtpaid\' AS ID,\'Debt paid\' AS NAME UNION\r\nSelect \'advance\' AS ID,\'Advance\' AS NAME UNION\r\nSelect \'advancepaid\' AS ID,\'Advance paid\' AS NAME UNION\r\nSelect \'creditpaid\' AS ID,\'Credit paid\' AS NAME}\" />\r\n        <filter title=\"From Date\" name=\'FROMDATE\' field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n        <filter title=\"To Date\" name=\'TODATE\' field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() AS DATE}\" />\r\n</filters>\r\n<groups>\r\n    <group field=\"HOST\" align=\"left\" type=\"text\" sum=\"\" />\r\n</groups>\r\n<columns>\r\n<column title=\"Payment\" field=\"PAYMENT\" width=\"100px\" align=\"left\" type=\"text\" sum=\"\" />\r\n<column title=\"Total\" field=\"MONEY\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(24,'PURCHASE LOG','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>PURCHASE LOG</title>\r\n<script><![CDATA[ SELECT TAXAMT,(TOTAL+TAXAMT) AS TOTAL,PIID,REFERENCE,NAME,DELIVERYDATE from (SELECT SUM(BASEAMOUNT) as TOTAL ,SUM(TAXAMOUNT) as TAXAMT,PIID from PURCHASEINVOICETAXES GROUP BY PIID) mytable LEFT JOIN PURCHASEINVOICE P ON mytable.PIID=P.ID LEFT JOIN SUPPLIERS S ON P.SUPPLIERID=S.ID WHERE ? AND (P.STATUS=2 OR P.STATUS=-2) ORDER BY DELIVERYDATE ]]></script>\r\n<filters>\r\n        <filter title=\"From Date\" name=\'FROMDATE\' field=\"DELIVERYDATE\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n        <filter title=\"To Date\" name=\'TODATE\' field=\"DELIVERYDATE\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() AS DATE}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Invoice No\" field=\"REFERENCE\" width=\"60px\" align=\"left\" type=\"text\" />\r\n<column title=\"Supplier\" field=\"NAME\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Invoice Date\" field=\"DELIVERYDATE\" width=\"50px\" align=\"left\" type=\"date\" />\r\n<column title=\"Total\" field=\"TOTAL\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"Tax Amount\" field=\"TAXAMT\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(25,'CUSTOMER LIST','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>CUSTOMER LIST REPORT</title>\r\n<script><![CDATA[ SELECT CUSTOMERS.ID,CUSTOMERS.TAXID, CUSTOMERS.SEARCHKEY, CUSTOMERS.NAME, CUSTOMERS.CARD, CUSTOMERS.MAXDEBT, CUSTOMERS.CURDEBT , CUSTOMERS.ADVANCE ,CUSTOMERS.ADVANCEDATE , CUSTOMERS.CURDATE, T.NAME AS TAXCATEGORY, CUSTOMERS.ADDRESS, CUSTOMERS.PHONE, CUSTOMERS.EMAIL, CUSTOMERS.FAX, CUSTOMERS.NOTES, CUSTOMERS.TAXCATEGORY AS TAXCATID FROM CUSTOMERS LEFT JOIN TAXCUSTCATEGORIES AS T ON T.ID = CUSTOMERS.TAXCATEGORY WHERE ? ORDER BY T.NAME ]]></script>\r\n<filters>\r\n<filter title=\"Category\" field=\"CUSTOMERS.TAXCATEGORY\" name=\"CUSTCAT\" type=\"list\" operator=\"=\" value=\"{SELECT ID,NAME FROM TAXCUSTCATEGORIES}\" />\r\n<filter title=\"Customer Id\" field=\"CUSTOMERS.TAXID\" name=\"CUSTID\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Search Key\" field=\"CUSTOMERS.SEARCHKEY\" name=\"SEARCHKEY\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Name\" field=\"CUSTOMERS.NAME\" name=\"NAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n</filters>\r\n<groups>\r\n    <group field=\"TAXCATEGORY\" align=\"left\" type=\"text\" sum=\"\" />\r\n</groups>\r\n<columns>\r\n<column title=\"Customer Id\" field=\"TAXID\" width=\"50px\" align=\"left\" type=\"text\" />\r\n<column title=\"Name\" field=\"NAME\" width=\"70px\" align=\"left\" type=\"text\" />\r\n<column title=\"Address\" field=\"ADDRESS\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Current Debt\" field=\"CURDEBT\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"Debt Date\" field=\"CURDATE\" width=\"70px\" align=\"left\" type=\"date\" sum=\"\" />\r\n<column title=\"Advance Paid\" field=\"ADVANCE\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"Advance Date\" field=\"ADVANCEDATE\" width=\"70px\" align=\"right\" type=\"date\" sum=\"\" />\r\n</columns>\r\n</report>'),(26,'SUPPLIER LIST','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>SUPPLIER LIST REPORT</title>\r\n<script><![CDATA[ SELECT SUPPLIERS.ID, SUPPLIERS.TAXID,SUPPLIERS.SEARCHKEY, SUPPLIERS.NAME, SUPPLIERS.CARD, SUPPLIERS.MAXDEBT, SUPPLIERS.CURDEBT, T.NAME AS TAXCATEGORY, SUPPLIERS.ADDRESS, SUPPLIERS.PHONE, SUPPLIERS.EMAIL, SUPPLIERS.FAX, SUPPLIERS.NOTES, SUPPLIERS.TAXCATEGORY AS TAXCATID,SUPPLIERS.CURDATE FROM SUPPLIERS LEFT JOIN TAXCUSTCATEGORIES T ON SUPPLIERS.TAXCATEGORY=T.ID WHERE ? ]]></script>\r\n<filters>\r\n<filter title=\"Category\" field=\"SUPPLIERS.TAXCATEGORY\" name=\"TAXCATEGORY\" type=\"list\" operator=\"=\" value=\"{SELECT ID,NAME FROM TAXCUSTCATEGORIES}\" />\r\n<filter title=\"Search Key\" field=\"SUPPLIERS.SEARCHKEY\" name=\"SEARCHKEY\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Supplier ID\" field=\"SUPPLIERS.TAXID\" name=\"TAXID\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Name\" field=\"SUPPLIERS.NAME\" name=\"NAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Supplier Id\" field=\"TAXID\" width=\"50px\" align=\"left\" type=\"text\" />\r\n<column title=\"Search Key\" field=\"SEARCHKEY\" width=\"50px\" align=\"left\" type=\"text\" />\r\n<column title=\"Name\" field=\"NAME\" width=\"70px\" align=\"left\" type=\"text\" />\r\n<column title=\"Address\" field=\"ADDRESS\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Maximum Credit\" field=\"MAXDEBT\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"\" />\r\n<column title=\" Credit Date\" field=\"CURDATE\" width=\"70px\" align=\"right\" type=\"date\" sum=\"\" />\r\n<column title=\"Current Credit\" field=\"CURDEBT\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(27,'CUSTOMERS DEFAULTING','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>CUSTOMERS DEFAULTING</title>\r\n<script><![CDATA[ SELECT C.ID, C.TAXID, C.NAME, C.ADDRESS, C.NOTES, C.CARD, C.MAXDEBT, C.CURDATE, C.CURDEBT, C.SEARCHKEY,datediff(CURDATE(), CURDATE) AS DIFDAYS FROM CUSTOMERS C WHERE ROUND(C.CURDEBT,1)>0 AND ? ORDER BY C.CURDATE ]]></script>\r\n<filters>\r\n<filter title=\"Name\" field=\"NAME\" name=\"NAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Search key\" field=\"SEARCHKEY\" name=\"SEARCHKEY\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Card\" field=\"CARD\" name=\"CARD\" type=\"text\" operator=\"=\" value=\"\" />\r\n<filter title=\"Last Transaction before\" field=\"datediff(CURDATE(), CURDATE)\" name=\"DAYS\" type=\"text\" operator=\">=\" value=\"\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Search Key\" field=\"SEARCHKEY\" width=\"50px\" align=\"left\" type=\"text\" />\r\n<column title=\"Name\" field=\"NAME\" width=\"70px\" align=\"left\" type=\"text\" />\r\n<column title=\"Card\" field=\"CARD\" width=\"70px\" align=\"left\" type=\"text\" />\r\n<column title=\"Max. Debt\" field=\"MAXDEBT\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"\" />\r\n<column title=\"Debt Date\" field=\"CURDATE\" width=\"70px\" align=\"right\" type=\"date\" sum=\"\" />\r\n<column title=\"Current Debt\" field=\"CURDEBT\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(28,'CUSTOMER DIARY','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>CUSTOMER DIARY REPORT</title>\r\n<script><![CDATA[ SELECT RECEIPTS.DATENEW, TICKETS.TICKETID, PAYMENTS.PAYMENT, PAYMENTS.TOTAL, CUSTOMERS.TAXID, CONCAT(CUSTOMERS.SEARCHKEY, \" - \", CUSTOMERS.NAME, \" (\", format(IF(CUSTOMERS.CURDEBT IS NULL,\"\",CUSTOMERS.CURDEBT),2),\")\") AS NAME FROM RECEIPTS, TICKETS, CUSTOMERS, PAYMENTS WHERE RECEIPTS.ID = TICKETS.ID AND RECEIPTS.ID = PAYMENTS.RECEIPT AND TICKETS.CUSTOMER = CUSTOMERS.ID AND PAYMENTS.PAYMENT!=\'cash\' AND ? ORDER BY RECEIPTS.DATENEW ]]></script>\r\n<filters>\r\n<filter title=\"Search Key\" field=\"CUSTOMERS.SEARCHKEY\" name=\"SEARCHKEY\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Name\" field=\"CUSTOMERS.NAME\" name=\"NAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Payment\" field=\"PAYMENTS.PAYMENT\" name=\"PAYMENT\" type=\"list\" operator=\"=\" value=\"{(SELECT \'debt\' AS ID,\'DEBT\' AS NAME) UNION (SELECT \'debtpaid\' AS ID,\'DEBT PAID\' AS NAME) UNION (SELECT \'cash\' AS ID,\'CASH\' AS NAME) UNION (SELECT \'magcard\' AS ID,\'CARD\' AS NAME)}\" />\r\n<filter title=\"From Date\" name=\'FDATE\' field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n        <filter title=\"To Date\" name=\'TDATE\' field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() AS DATE}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Date\" field=\"DATENEW\" width=\"50px\" align=\"left\" type=\"date\" />\r\n<column title=\"Customer\" field=\"NAME\" width=\"150px\" align=\"left\" type=\"text\" />\r\n<column title=\"Ticket Id\" field=\"TICKETID\" width=\"70px\" align=\"left\" type=\"text\" />\r\n<column title=\"Payment\" field=\"PAYMENT\" width=\"70px\" align=\"left\" type=\"text\" />\r\n<column title=\"Total\" field=\"TOTAL\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(29,'SALES BY USER','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>SALES BY USER</title>\r\n<script><![CDATA[ SELECT PEOPLE.NAME, MIN(RECEIPTS.DATENEW) AS STARTDATE, MAX(RECEIPTS.DATENEW) AS ENDDATE, SUM(TICKETLINES.UNITS * TICKETLINES.PRICE) AS TOTAL FROM PEOPLE, RECEIPTS, TICKETS, TICKETLINES WHERE PEOPLE.ID = TICKETS.PERSON AND RECEIPTS.ID = TICKETS.ID AND TICKETS.ID = TICKETLINES.TICKET AND ? GROUP BY PEOPLE.NAME ORDER BY PEOPLE.NAME ]]></script>\r\n<filters>\r\n<filter title=\"PEOPLE\" field=\"PEOPLE.ID\" name=\"PEOPLE\" type=\"list\" operator=\"=\" value=\"{SELECT ID,NAME FROM PEOPLE}\" />\r\n<filter title=\"From date\" name=\"FDATE\" field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" name=\"TDATE\" field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() as DATE}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"User\" field=\"NAME\" width=\"50px\" align=\"left\" type=\"text\" />\r\n<column title=\"Start Date\" field=\"STARTDATE\" width=\"50px\" align=\"left\" type=\"datetime\" />\r\n<column title=\"End Date\" field=\"ENDDATE\" width=\"50px\" align=\"left\" type=\"datetime\" />\r\n<column title=\"Total\" field=\"TOTAL\" width=\"80px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(30,'EXPENSES','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>EXPENSES</title>\r\n<script><![CDATA[  SELECT TRANSACTION_DATE,SUM(-1*(TAXES.RATE*AMOUNT)) AS TAXAMOUNT, SUM(-1*AMOUNT) AS AMOUNT,A.ACCOUNT_NAME,T.COMMENTS FROM TRANSACTIONS T JOIN ACCOUNTS A ON A.ID=T.ACCOUNT_ID JOIN PAYMENTHEADS ON T.PAYMENTHEAD_ID=PAYMENTHEADS.ID LEFT JOIN TAXES ON TAXES.CATEGORY=PAYMENTHEADS.TAXCAT WHERE (T.PAYMENTHEAD_ID!=\'DEPOSIT\' && T.PAYMENTHEAD_ID!=\'PURCHASE\' && T.PAYMENTHEAD_ID!=\'PURCHASERETURN\') AND ? GROUP BY TRANSACTION_DATE,A.ACCOUNT_NAME,T.COMMENTS ]]></script>\r\n<filters>\r\n<filter title=\"PAYMENT HEAD\" field=\"T.PAYMENTHEAD_ID\" name=\"paymenthead\" type=\"list\" operator=\"=\" value=\"{SELECT ID,PAYMENTHEAD \r\n AS NAME FROM PAYMENTHEADS WHERE ID NOT IN (\'DEPOSIT\',\'PURCHASE\',\'PURCHASERETURN\')}\" />\r\n\r\n<filter title=\"DATE FROM\" field=\"T.TRANSACTION_DATE\" name=\"FDATE\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n\r\n<filter title=\"DATE TO\" field=\"T.TRANSACTION_DATE\" name=\"TDATE\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() AS DATE}\" />\r\n<filter title=\"Comments\" field=\"T.COMMENTS\" name=\"COMMENTS\" type=\"text\" operator=\"like\" value=\"\" />\r\n</filters>\r\n<columns>\r\n        <column title=\"TRANSACTION DATE\" field=\"TRANSACTION_DATE\" width=\"50\" align=\"left\" type=\"text\" sum=\"\" />\r\n<column title=\"FROM ACCOUNT\" field=\"ACCOUNT_NAME\" width=\"100\" align=\"left\" type=\"text\" sum=\"\" />\r\n<column title=\"COMMENTS\" field=\"COMMENTS\" width=\"100\" align=\"left\" type=\"text\" sum=\"\" />\r\n<column title=\"TAXAMOUNT\" field=\"TAXAMOUNT\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"AMOUNT\" field=\"AMOUNT\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(31,'CURRENT INVENTORY','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>CURRENT INVENTORY</title>\r\n<script><![CDATA[ SELECT STOCKCURRENT.LOCATION AS LOCATIONID, LOCATIONS.NAME AS LOCATIONNAME, PRODUCTS.CODE, PRODUCTS.NAME AS NAME, PRODUCTS.PRICEBUY, PRODUCTS.CATEGORY, CATEGORIES.NAME AS CATEGORYNAME, SUM(STOCKCURRENT.UNITS) AS UNITS, (PRODUCTS.PRICEBUY*SUM(STOCKCURRENT.UNITS)) AS COST  , COALESCE(STOCKLEVEL.STOCKSECURITY, 0) AS STOCKSECURITY, COALESCE(STOCKLEVEL.STOCKMAXIMUM, 0) AS STOCKMAXIMUM FROM STOCKCURRENT JOIN LOCATIONS ON STOCKCURRENT.LOCATION = LOCATIONS.ID JOIN PRODUCTS ON STOCKCURRENT.PRODUCT = PRODUCTS.ID JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID  LEFT OUTER JOIN STOCKLEVEL ON STOCKCURRENT.LOCATION = STOCKLEVEL.LOCATION AND STOCKCURRENT.PRODUCT = STOCKLEVEL.PRODUCT WHERE ? GROUP BY STOCKCURRENT.LOCATION, LOCATIONS.NAME, PRODUCTS.REFERENCE, PRODUCTS.NAME, PRODUCTS.CATEGORY, CATEGORIES.NAME, STOCKLEVEL.STOCKSECURITY, STOCKLEVEL.STOCKMAXIMUM ORDER BY CATEGORIES.NAME, PRODUCTS.NAME, STOCKCURRENT.LOCATION ]]></script>\r\n<filters>\r\n<filter title=\"category\" field=\"PRODUCTS.CATEGORY\" name=\"category\" type=\"list\" operator=\"=\" value=\"{SELECT ID, NAME FROM CATEGORIES}\" />\r\n<filter title=\"location\" field=\"STOCKCURRENT.LOCATION\" name=\"location\" type=\"list\" operator=\"=\" value=\"{SELECT ID, NAME FROM LOCATIONS}\" /> 	\r\n<filter title=\"Barcode\" field=\"PRODUCTS.CODE\" name=\"CODE\" type=\"text\" operator=\"=\" value=\"\" />\r\n<filter title=\"Product Name\" field=\"PRODUCTS.NAME\" name=\"PRODUCTNAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n</filters>\r\n<groups>\r\n    <group field=\"CATEGORYNAME\" align=\"left\" type=\"text\" sum=\"\" />\r\n    <group field=\"NAME\" align=\"left\" type=\"text\" sum=\"\" />\r\n</groups>\r\n<columns>\r\n        <column title=\"Location\" field=\"LOCATIONNAME\" width=\"100\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Price Buy\" field=\"PRICEBUY\" width=\"50\" align=\"right\" type=\"currency\" sum=\"\" />\r\n        <column title=\"Stock Minimum\" field=\"STOCKSECURITY\" width=\"50\" align=\"right\" type=\"currency\" sum=\"\" />\r\n        <column title=\"Stock Maximum\" field=\"STOCKMAXIMUM\" width=\"50\" align=\"right\" type=\"currency\" sum=\"\" />\r\n        <column title=\"Units\" field=\"UNITS\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n        <column title=\"Total Value\" field=\"COST\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(32,'PRODUCT SALES LOG','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>PRODUCT SALES LOG</title>\r\n<script><![CDATA[SELECT R.DATENEW, T.TICKETID , P.NAME, P.CODE, TL.UNITS, TL.UNITS*TL.PRICE AS TOTAL FROM TICKETLINES TL JOIN TICKETS T ON T.ID=TL.TICKET LEFT JOIN PRODUCTS P ON P.ID=TL.PRODUCT JOIN RECEIPTS R ON R.ID=T.ID WHERE ? ORDER BY R.DATENEW ]]></script>\r\n<filters>\r\n<filter title=\"Product Code\" name=\'CODE\' field=\"P.CODE\" type=\"text\" operator=\"=\" value=\"\" />\r\n<filter title=\"Product Name\" name=\'PRODUCT\' field=\"P.NAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"From date\" name=\"FDATE\" field=\"R.DATENEW\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" name=\"TDATE\" field=\"R.DATENEW\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() as DATE}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Date\" field=\"DATENEW\" width=\"50px\" align=\"left\" type=\"datetime\" />\r\n<column title=\"Reciept\" field=\"TICKETID\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Code\" field=\"CODE\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Product\" field=\"NAME\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Units\" field=\"UNITS\" width=\"100px\" align=\"left\" type=\"double\" sum=\"true\" />\r\n<column title=\"Total\" field=\"TOTAL\" width=\"100px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(34,'SALES TAX LOG SUMMARY','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>SALES TAX LOG SUMMARY</title>\r\n<script><![CDATA[ SELECT CAST(RECEIPTS.DATENEW AS DATE) AS TICKET_DATE,\r\nSUM(TAXLINES.BASE)+SUM(TAXLINES.AMOUNT) AS MONEY, \r\nSUM(TAXLINES.AMOUNT) AS TAX\r\nFROM RECEIPTS \r\nJOIN TICKETS ON RECEIPTS.ID = TICKETS.ID AND (TICKETS.TICKETTYPE=0 OR TICKETS.TICKETTYPE=1) \r\nJOIN TAXLINES ON TAXLINES.RECEIPT=RECEIPTS.ID\r\nWHERE ?\r\nGROUP BY CAST(RECEIPTS.DATENEW AS DATE) \r\nORDER BY CAST(RECEIPTS.DATENEW AS DATE) ]]></script>\r\n<filters>\r\n<filter title=\"From Date\" name=\'FDATE\' field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n        <filter title=\"To Date\" name=\'TDATE\' field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() AS DATE}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Date\" field=\"TICKET_DATE\" width=\"50px\" align=\"left\" type=\"date\" />\r\n<column title=\"Total\" field=\"MONEY\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"Tax\" field=\"TAX\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(35,'PURCHASE TAX LOG SUMMARY','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>PURCHASE TAX LOG SUMMARY</title>\r\n<script><![CDATA[ SELECT DELIVERYDATE , SUM(TAXAMT) AS TAXAMT,SUM((TOTAL+TAXAMT)) AS TOTAL from (SELECT SUM(BASEAMOUNT) as TOTAL ,SUM(TAXAMOUNT) as TAXAMT,PIID from PURCHASEINVOICETAXES GROUP BY PIID) mytable LEFT JOIN PURCHASEINVOICE P ON mytable.PIID=P.ID LEFT JOIN SUPPLIERS S ON P.SUPPLIERID=S.ID WHERE ? AND (P.STATUS=2 OR P.STATUS=-2) GROUP BY DELIVERYDATE ORDER BY DELIVERYDATE ]]></script>\r\n<filters>\r\n        <filter title=\"From Date\" name=\'FROMDATE\' field=\"DELIVERYDATE\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n        <filter title=\"To Date\" name=\'TODATE\' field=\"DELIVERYDATE\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() AS DATE}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Invoice Date\" field=\"DELIVERYDATE\" width=\"50px\" align=\"left\" type=\"date\" />\r\n<column title=\"Total\" field=\"TOTAL\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"Tax Amount\" field=\"TAXAMT\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(36,'STOCK DIARY','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>STOCK DIARY</title>\r\n<script><![CDATA[ SELECT\r\nLOCATIONS.ID AS LOCATIONID, LOCATIONS.NAME AS LOCATIONNAME,\r\nPRODUCTS.REFERENCE, PRODUCTS.NAME, PRODUCTS.CATEGORY, CATEGORIES.NAME AS CATEGORYNAME,\r\nSTOCKDIARY.DATENEW AS DATEIN,\r\n(STOCKDIARY.UNITS) AS UNITS,\r\nSTOCKDIARY.PRICE AS PRICE,\r\n(STOCKDIARY.UNITS * STOCKDIARY.PRICE) AS TOTAL,\r\nCASE STOCKDIARY.REASON \r\n                    WHEN \'1\' THEN \'(IN) Purchase\' \r\n                    WHEN \'2\' THEN \'(IN) Refund\'  \r\n                    WHEN \'4\' THEN \'(IN) Movement\'\r\n                    WHEN \'5\' THEN \'(IN) Production\'\r\n                    WHEN \'-1\' THEN \'(OUT) Sale\'\r\n                    WHEN \'-2\' THEN \'(OUT) Refund\'\r\n                    WHEN \'-3\' THEN \'(OUT) Break\'\r\n                    WHEN \'-4\' THEN \'(OUT) Movement\'\r\n                    WHEN \'-5\' THEN \'(OUT) Production\'\r\n                    WHEN \'1000\' THEN \'Crossing\'  \r\n                    WHEN \'999\' THEN \'Request\'\r\n                    ELSE \'\' \r\n                END as REASONTEXT\r\nFROM\r\nSTOCKDIARY \r\nLEFT JOIN LOCATIONS ON STOCKDIARY.LOCATION = LOCATIONS.ID\r\nLEFT JOIN PRODUCTS ON PRODUCTS.ID = STOCKDIARY.PRODUCT\r\nJOIN CATEGORIES ON CATEGORIES.ID=PRODUCTS.CATEGORY\r\nWHERE ?\r\nORDER BY LOCATIONS.ID, STOCKDIARY.DATENEW, CATEGORIES.NAME, PRODUCTS.NAME ]]></script>\r\n<filters>\r\n<filter title=\"Item Name\" field=\"PRODUCTS.NAME\" name=\"PRNAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"From date\" field=\"STOCKDIARY.DATENEW\" name=\"FDATE\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" field=\"STOCKDIARY.DATENEW\" name=\"TDATE\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() AS DATE}\" />\r\n<filter title=\"REASON\" field=\"STOCKDIARY.REASON\" name=\"REASON\" type=\"list\" operator=\"=\" value=\"{SELECT \'(in) Movement\' AS NAME,\'+4\' AS ID UNION\r\nSELECT \'(in) Purchase\' AS NAME,\'+1\' AS ID UNION\r\nSELECT \'(in) Refund\' AS NAME,\'+2\' AS ID UNION\r\nSELECT \'(in) Production\' AS NAME,\'+5\' AS ID UNION\r\nSELECT \'(out) Break\' AS NAME,\'-3\' AS ID UNION\r\nSELECT \'Crossing\' AS NAME,\'1000\' AS ID UNION\r\nSELECT \'(out) Movement\' AS NAME,\'-4\' AS ID UNION\r\nSELECT \'(out) Refund\' AS NAME,\'-2\' AS ID UNION\r\nSELECT \'(out) Sale\' AS NAME,\'-1\' AS ID UNION\r\nSELECT \'Request\' AS NAME,\'999\' AS ID}\" />\r\n<filter title=\"LOCATIONS\" field=\"STOCKDIARY.LOCATION\" name=\"LOCATION\" type=\"list\" operator=\"=\" value=\"{SELECT ID,NAME FROM LOCATIONS}\" />\r\n<filter title=\"Category\" field=\"CATEGORIES.ID\" name=\"CATEGORY\" type=\"list\" operator=\"=\" value=\"{SELECT ID, NAME FROM CATEGORIES}\" />\r\n</filters>\r\n<columns>\r\n        <column title=\"Date\" field=\"DATEIN\" width=\"50\" align=\"left\" type=\"date\" sum=\"\" />\r\n        <column title=\"Warehouse\" field=\"LOCATIONNAME\" width=\"100\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Reason\" field=\"REASONTEXT\" width=\"50\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Reference\" field=\"REFERENCE\" width=\"50\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Name\" field=\"NAME\" width=\"150\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Units\" field=\"UNITS\" width=\"50\" align=\"left\" type=\"text\" sum=\"true\" />\r\n        <column title=\"Price\" field=\"PRICE\" width=\"70\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n        <column title=\"Total\" field=\"TOTAL\" width=\"70\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(37,'EXPENSES SUMMARY','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>EXPENSES SUMMARY</title>\r\n<script><![CDATA[ SELECT SUM(-1*(TAXES.RATE*AMOUNT)) AS TAXAMOUNT,\r\n SUM(-1*AMOUNT) AS AMOUNT,PAYMENTHEADS.PAYMENTHEAD\r\n FROM TRANSACTIONS T\r\n JOIN PAYMENTHEADS ON T.PAYMENTHEAD_ID=PAYMENTHEADS.ID\r\n LEFT JOIN TAXES ON TAXES.CATEGORY=PAYMENTHEADS.TAXCAT\r\n WHERE (T.PAYMENTHEAD_ID!=\'DEPOSIT\' && T.PAYMENTHEAD_ID!=\'PURCHASE\' && T.PAYMENTHEAD_ID!=\'PURCHASERETURN\') AND ?\r\n GROUP BY PAYMENTHEADS.PAYMENTHEAD ]]></script>\r\n<filters>\r\n<filter title=\"DATE FROM\" field=\"T.TRANSACTION_DATE\" name=\"FDATE\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"DATE TO\" field=\"T.TRANSACTION_DATE\" name=\"TDATE\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() AS DATE}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Expence Account\" field=\"PAYMENTHEAD\" width=\"100\" align=\"left\" type=\"text\" sum=\"\" />\r\n<column title=\"TAXAMOUNT\" field=\"TAXAMOUNT\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"AMOUNT\" field=\"AMOUNT\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(39,'CATEGORY SALES','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>CATEGORY SALES</title>\r\n<script><![CDATA[ SELECT CP.NAME AS CATEGORY,\r\nSUM(PRODUCTS.PRICEBUY * TICKETLINES.UNITS) AS COST, \r\nSUM(TICKETLINES.UNITS) AS UNITS, \r\nSUM(TICKETLINES.UNITS * TICKETLINES.PRICE) AS TOTAL,\r\nSUM((TICKETLINES.UNITS * TICKETLINES.PRICE) - (TICKETLINES.UNITS * PRODUCTS.PRICEBUY)) AS PROFIT,\r\nROUND( \r\n(\r\nSUM((TICKETLINES.UNITS * TICKETLINES.PRICE) - (TICKETLINES.UNITS * PRODUCTS.PRICEBUY)) /\r\nSUM(TICKETLINES.UNITS * TICKETLINES.PRICE)\r\n)*100,2) AS PCT\r\nFROM TICKETLINES \r\nJOIN RECEIPTS ON RECEIPTS.ID=TICKETLINES.TICKET\r\nJOIN TICKETS ON TICKETS.ID=TICKETLINES.TICKET AND (TICKETS.TICKETTYPE=0 OR TICKETS.TICKETTYPE=1) \r\nLEFT JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID \r\nLEFT JOIN CATEGORIES CP ON PRODUCTS.CATEGORY= CP.ID\r\nWHERE ? GROUP BY CP.ID ORDER BY CP.NAME ]]></script>\r\n<filters>\r\n<filter title=\"Category\" name=\'CATEGORY\' field=\"CP.ID\" type=\"list\" operator=\"=\" value=\"{SELECT ID,NAME from CATEGORIES}\" />\r\n<filter title=\"From date\" name=\"FDATE\" field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" name=\"TDATE\" field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() as DATE}\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Category\" field=\"CATEGORY\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Units\" field=\"UNITS\" width=\"50px\" align=\"center\" type=\"double\" sum=\"true\" />\r\n<column title=\"Cost\" field=\"COST\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"Sale\" field=\"TOTAL\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"Profit\" field=\"PROFIT\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n<column title=\"%\" field=\"PCT\" width=\"50px\" align=\"right\" type=\"text\" sum=\"\" />\r\n</columns>\r\n</report>'),(40,'ACCOUNT SUMMARY','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>ACCOUNT SUMMARY</title>\r\n<script><![CDATA[ SELECT ACCOUNT_NAME, AVAILABLE_BALANCE, SUM(EXPENCE) AS EXPENCEAMNT,SUM(INCOME) AS INCOMEAMNT,(SUM(EXPENCE)+SUM(INCOME)) AS BALANCE FROM ((SELECT A.ID AS ACCOUNTID,T1.TRANSACTION_DATE,A.ACCOUNT_NAME, A.AVAILABLE_BALANCE, T1.AMOUNT AS EXPENCE,0 AS INCOME FROM TRANSACTIONS T1 JOIN ACCOUNTS A ON A.ID=T1.ACCOUNT_ID WHERE T1.TRANSACTION_TYPE_ID=1 AND T1.STATUS=1) UNION (SELECT A.ID AS ACCOUNTID,T2.TRANSACTION_DATE,A.ACCOUNT_NAME, A.AVAILABLE_BALANCE, 0 AS EXPENCE,T2.AMOUNT AS INCOME FROM TRANSACTIONS T2 JOIN ACCOUNTS A ON A.ID=T2.ACCOUNT_ID WHERE T2.TRANSACTION_TYPE_ID=0 AND T2.STATUS=1)) MYTABLE WHERE ? GROUP BY ACCOUNT_NAME ]]></script>\r\n<filters>\r\n<filter title=\"From date\" name=\"FDATE\" field=\"TRANSACTION_DATE\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" name=\"TDATE\" field=\"TRANSACTION_DATE\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() as DATE}\" />\r\n</filters>\r\n<columns>\r\n        <column title=\"Account Name\" field=\"ACCOUNT_NAME\" width=\"120\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Expense\" field=\"EXPENCEAMNT\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n        <column title=\"Income\" field=\"INCOMEAMNT\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n        <column title=\"Difference\" field=\"BALANCE\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n <column title=\"Available\" field=\"AVAILABLE_BALANCE\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(42,'PRODUCT PURCHASE','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>PRODUCT PURCHASE</title>\r\n<script><![CDATA[ SELECT PRODUCTNAME,CODE,SUM(PURCHASEQUANTITY) AS PURCHASEQUANTITY,SUM(TOTALAMOUNT) AS TOTALAMOUNT FROM (SELECT PR.NAME AS PRODUCTNAME,PR.CODE,PL.QUANTITY AS PURCHASEQUANTITY,(PL.QUANTITY*PL.UNITPRICE) AS PRICE,((PL.QUANTITY*PL.UNITPRICE)*(T.RATE+1)) AS TOTALAMOUNT FROM PURCHASEINVOICELINES PL JOIN PURCHASEINVOICE P ON P.ID=PL.PIID AND (P.STATUS=2 OR P.STATUS=-2) JOIN PRODUCTS PR ON PR.ID=PL.PRODUCT JOIN TAXES T ON T.ID=PL.TAXID WHERE ? ) MYTABLE GROUP BY PRODUCTNAME,CODE]]></script>\r\n<filters>\r\n<filter title=\"Product Name\" field=\"PR.NAME\" name=\"PNAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Product Code\" field=\"PR.CODE\" name=\"PCODE\" type=\"text\" operator=\"=\" value=\"\" />\r\n<filter title=\"From date\" name=\"FDATE\" field=\"P.DELIVERYDATE\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" name=\"TDATE\" field=\"P.DELIVERYDATE\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() as DATE}\" />\r\n</filters>\r\n<columns>\r\n        <column title=\"Product Name\" field=\"PRODUCTNAME\" width=\"100\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Barcode\" field=\"CODE\" width=\"40\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Quantity\" field=\"PURCHASEQUANTITY\" width=\"50\" align=\"left\" type=\"text\" sum=\"true\" />\r\n        <column title=\"Total Amount\" field=\"TOTALAMOUNT\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(43,'PRODUCT PURCHASE DETAILS','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>PRODUCT PURCHASE DETAILS</title>\r\n<script><![CDATA[ SELECT P.REFERENCE AS INVNUM, P.DELIVERYDATE, PR.NAME AS PRODUCTNAME, PR.CODE AS BARCODE, SUM(PL.QUANTITY) AS PURCHASEQUANTITY, PL.UNITPRICE AS PRICE,SUM(((PL.QUANTITY*PL.UNITPRICE)*(T.RATE+1))) AS TOTALAMOUNT FROM PURCHASEINVOICELINES PL JOIN PURCHASEINVOICE P ON P.ID=PL.PIID AND (P.STATUS=2 OR P.STATUS=-2) JOIN PRODUCTS PR ON PR.ID=PL.PRODUCT JOIN TAXES T ON T.ID=PL.TAXID WHERE ? GROUP BY PL.PIID, PL.PRODUCT ]]></script>\r\n<filters>\r\n<filter title=\"Product Name\" field=\"PR.NAME\" name=\"PNAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Product Code\" field=\"PR.CODE\" name=\"PCODE\" type=\"text\" operator=\"=\" value=\"\" />\r\n<filter title=\"From date\" name=\"FDATE\" field=\"P.DELIVERYDATE\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" name=\"TDATE\" field=\"P.DELIVERYDATE\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() as DATE}\" />\r\n</filters>\r\n<columns>\r\n        <column title=\"Date\" field=\"DELIVERYDATE\" width=\"50\" align=\"left\" type=\"date\" sum=\"\" />\r\n        <column title=\"Invoice Number\" field=\"INVNUM\" width=\"50\" align=\"left\" type=\"text\" sum=\"\" />\r\n	<column title=\"Product Name\" field=\"PRODUCTNAME\" width=\"100\" align=\"left\" type=\"text\" sum=\"\" />\r\n	<column title=\"Barcode\" field=\"BARCODE\" width=\"40\" align=\"left\" type=\"text\" sum=\"\" />\r\n	<column title=\"Quantity\" field=\"PURCHASEQUANTITY\" width=\"50\" align=\"left\" type=\"text\" sum=\"true\" />\r\n	<column title=\"Price\" field=\"PRICE\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n	<column title=\"Total Amount\" field=\"TOTALAMOUNT\" width=\"50\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(47,'SUPPLIER DIARY','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>SUPPLIER DIARY</title>\r\n<script><![CDATA[ SELECT * FROM (SELECT S.NAME as SUPPLIERNAME,COALESCE(A.BASEAMOUNT,0)+COALESCE(A.TAXAMOUNT,0)
+COALESCE(PI.FREIGHTAMOUNT,0)+COALESCE(PI.DISCOUNT,0)
+COALESCE(PI.ADJUSTMENT,0) AS TOTALAMOUNT,CONCAT("Invoice #", PI.REFERENCE) as REFERENCE,
PI.REFERENCE AS INVOICENUM, PI.DELIVERYDATE AS TRDATE, PIID, PI.SUPPLIERID
FROM SUPPLIERS S JOIN PURCHASEINVOICE PI ON PI.SUPPLIERID=S.ID LEFT JOIN (
SELECT SUM(TAXAMOUNT) AS TAXAMOUNT,SUM(BASEAMOUNT) AS BASEAMOUNT,PIID AS PIID FROM PURCHASEINVOICETAXES GROUP BY PIID) A
 ON A.PIID=PI.ID WHERE (PI.STATUS=2 || PI.STATUS=-2) GROUP BY PIID \r\n UNION ALL \r\n (SELECT S.NAME as SUPPLIERNAME1,T.AMOUNT AS TOTALAMOUNT,CONCAT(\"Payment #\", PI.REFERENCE,\' - Account: \',A.ACCOUNT_NAME) as REFERENCE,PI.REFERENCE AS INVOICENUM,\r\nT.TRANSACTION_DATE AS TRDATE,PI.ID AS PIID FROM SUPPLIERS S\r\n JOIN PURCHASEINVOICE PI ON PI.SUPPLIERID=S.ID\r\n JOIN PURCHASEINVOICE_PAYMENTS PP ON PP.PURCHASEINVOICE_ID=PI.ID\r\n JOIN TRANSACTIONS T ON T.ID=PP.TRANSACTION_ID\r\nJOIN ACCOUNTS A ON A.ID=T.ACCOUNT_ID\r\n WHERE (PI.STATUS=2 || PI.STATUS=-2))) A WHERE ? ORDER BY REFERENCE,TRDATE DESC ]]></script>\r\n<filters>\r\n<filter title=\"Invoice Number\" field=\"INVOICENUM\" name=\"INVOICENUM\" type=\"text\" operator=\"=\" value=\"\" />\r\n<filter title=\"SUPPLIER NAME\" field=\"SUPPLIERNAME\" name=\"SUPPLIERNAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"From date\" name=\"FDATE\" field=\"TRDATE\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" name=\"TDATE\" field=\"TRDATE\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() as DATE}\" />\r\n</filters>\r\n<columns>\r\n        <column title=\"Date\" field=\"TRDATE\" width=\"\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Supplier\" field=\"SUPPLIERNAME\" width=\"\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Type\" field=\"REFERENCE\" width=\"\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Amount\" field=\"TOTALAMOUNT\" width=\"\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(48,'SALES LOG','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>SALES LOG</title>\r\n<script><![CDATA[ SELECT\r\nTICKETS.TICKETID AS TICKET_NO,\r\nRECEIPTS.DATENEW AS TICKET_DATE,\r\nPAYMENTS.TOTAL AS MONEY,\r\nCUSTOMERS.NAME AS CUSTOMER,\r\nPAYMENTS.PAYMENT AS PAYMENT,\r\nACCOUNTHEADS.NAME AS HEAD\r\nFROM RECEIPTS\r\nLEFT JOIN TICKETS ON RECEIPTS.ID = TICKETS.ID\r\nLEFT JOIN PAYMENTS ON RECEIPTS.ID = PAYMENTS.RECEIPT\r\nLEFT JOIN ACCOUNTHEADS ON RECEIPTS.ACCOUNTHEAD = ACCOUNTHEADS.ID\r\nLEFT JOIN CUSTOMERS ON TICKETS.CUSTOMER = CUSTOMERS.ID WHERE ?\r\nORDER BY TICKETS.TICKETID ]]></script>\r\n<filters>\r\n<filter title=\"From date\" name=\"FDATE\" field=\"RECEIPTS.DATENEW\" type=\"datetime\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" name=\"TDATE\" field=\"RECEIPTS.DATENEW\" type=\"datetime\" operator=\"<=\" value=\"{SELECT CURDATE() as DATE}\" />\r\n<filter title=\"Payment\" name=\'PAYMENT\' field=\"PAYMENTS.PAYMENT\" type=\"list\" operator=\"=\" value=\"{Select \'cash\' AS ID,\'Cash\' AS NAME UNION\r\nSelect \'magcard\' AS ID,\'Card\' AS NAME UNION\r\nSelect \'currency\' AS ID,\'Currency\' AS NAME UNION\r\nSelect \'currencychange\' AS ID,\'Currency Change\' AS NAME UNION\r\nSelect \'cashin\' AS ID,\'Cash In\' AS NAME UNION\r\nSelect \'cashout\' AS ID,\'Cash Out\' AS NAME UNION\r\nSelect \'cashrefund\' AS ID,\'Refund\' AS NAME UNION\r\nSelect \'cheque\' AS ID,\'Cheque\' AS NAME UNION\r\nSelect \'chequerefund\' AS ID,\'Cheque refund\' AS NAME UNION\r\nSelect \'free\' AS ID,\'Free\' AS NAME UNION\r\nSelect \'magcardrefund\' AS ID,\'Card refund\' AS NAME UNION\r\nSelect \'paperin\' AS ID,\'Voucher in\' AS NAME UNION\r\nSelect \'paperout\' AS ID,\'Voucher out\' AS NAME UNION\r\nSelect \'pointsin\' AS ID,\'Points In\' AS NAME UNION\r\nSelect \'pointsout\' AS ID,\'Points Out\' AS NAME UNION\r\nSelect \'cashcreditpaid\' AS ID,\'Credit paid - Cash\' AS NAME UNION\r\nSelect \'chequecreditpaid\' AS ID,\'Credit paid - Cheque\' AS NAME UNION\r\nSelect \'debt\' AS ID,\'Debt\' AS NAME UNION\r\nSelect \'debtpaid\' AS ID,\'Debt paid\' AS NAME UNION\r\nSelect \'advance\' AS ID,\'Advance\' AS NAME UNION\r\nSelect \'advancepaid\' AS ID,\'Advance paid\' AS NAME UNION\r\nSelect \'creditpaid\' AS ID,\'Credit paid\' AS NAME}\" />\r\n</filters>\r\n<columns>\r\n        <column title=\"Ticket No.\" field=\"TICKET_NO\" width=\"\" align=\"\" type=\"text\" sum=\"\" />\r\n        <column title=\"Ticket Date\" field=\"TICKET_DATE\" width=\"\" align=\"\" type=\"datetime\" sum=\"\" />\r\n        <column title=\"Customer\" field=\"CUSTOMER\" width=\"\" align=\"\" type=\"text\" sum=\"\" />\r\n        <column title=\"Payment\" field=\"PAYMENT\" width=\"\" align=\"\" type=\"text\" sum=\"\" />\r\n        <column title=\"Head\" field=\"HEAD\" width=\"\" align=\"\" type=\"text\" sum=\"\" />\r\n        <column title=\"Amount\" field=\"MONEY\" width=\"\" align=\"\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(49,'SALES BY TAX AND CATEGORY','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>SALES BY TAX AND CATEGORY</title>\r\n<script><![CDATA[ SELECT TAXES.NAME AS TAXNAME, CATEGORIES.NAME, SUM(TICKETLINES.UNITS) AS QTY, SUM(TICKETLINES.PRICE * TICKETLINES.UNITS) AS CATPRICE, SUM((TICKETLINES.PRICE * TAXES.RATE ) * TICKETLINES.UNITS) AS CATTAX, \r\nSUM((TICKETLINES.PRICE + TICKETLINES.PRICE * TAXES.RATE ) * TICKETLINES.UNITS) AS CATTOTAL FROM RECEIPTS JOIN TICKETS ON RECEIPTS.ID = TICKETS.ID AND (TICKETS.TICKETTYPE=0 OR TICKETS.TICKETTYPE=1)  JOIN TICKETLINES ON TICKETLINES.TICKET = RECEIPTS.ID JOIN TAXES ON TICKETLINES.TAXID = TAXES.ID  LEFT OUTER JOIN PRODUCTS ON TICKETLINES.PRODUCT = PRODUCTS.ID LEFT OUTER JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID  WHERE ? GROUP BY TAXES.NAME, CATEGORIES.NAME ORDER BY TAXES.NAME, CATEGORIES.NAME ]]></script>\r\n<filters>\r\n<filter title=\"From date\" name=\"FDATE\" field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" name=\"TDATE\" field=\"RECEIPTS.DATENEW\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() as DATE}\" />\r\n</filters>\r\n<groups>\r\n    <group field=\"TAXNAME\" align=\"left\" type=\"text\" sum=\"\" />\r\n</groups>\r\n<columns>\r\n        <column title=\"Category\" field=\"NAME\" width=\"\" align=\"left\" type=\"text\" sum=\"\" />\r\n		<column title=\"Quantity\" field=\"QTY\" width=\"\" align=\"center\" type=\"text\" sum=\"true\" />\r\n		<column title=\"Sales\" field=\"CATPRICE\" width=\"\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n		<column title=\"Tax\" field=\"CATTAX\" width=\"\" align=\"right\"  type=\"currency\" sum=\"true\" />\r\n		<column title=\"Total\" field=\"CATTOTAL\" width=\"\" align=\"right\"  type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(50,'PURCHASE TAX LOG','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n	<title>PURCHASE TAX LOG</title>\r\n	<script><![CDATA[ SELECT P.DELIVERYDATE AS PI_DATE, P.REFERENCE AS PI_NO, S.NAME AS SUPPLIER, S.TAXID AS TRN, (SUM(PT.BASEAMOUNT)+SUM(PT.TAXAMOUNT)) AS MONEY, SUM(PT.TAXAMOUNT) AS TAX \r\n	FROM PURCHASEINVOICE P\r\n	JOIN PURCHASEINVOICETAXES PT ON PT.PIID = P.ID \r\n	JOIN SUPPLIERS S ON P.SUPPLIERID=S.ID\r\n	WHERE ? \r\n	GROUP BY P.ID \r\n	ORDER BY P.DELIVERYDATE ]]></script>\r\n	<filters>\r\n		<filter title=\"From Date\" name=\'FDATE\' field=\"P.DELIVERYDATE\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n		<filter title=\"To Date\" name=\'TDATE\' field=\"P.DELIVERYDATE\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() AS DATE}\" />\r\n	</filters>\r\n	<columns>\r\n			<column title=\"Date\" field=\"PI_DATE\" width=\"\" align=\"left\" type=\"date\" sum=\"\" />\r\n			<column title=\"Invoice\" field=\"PI_NO\" width=\"\" align=\"\" type=\"\" sum=\"\" />\r\n			<column title=\"Supplier\" field=\"SUPPLIER\" width=\"\" align=\"\" type=\"\" sum=\"\" />\r\n			<column title=\"TaxId\" field=\"TRN\" width=\"\" align=\"\" type=\"\" sum=\"\" />\r\n			<column title=\"Total\" field=\"MONEY\" width=\"\" align=\"\" type=\"\" sum=\"true\" />\r\n			<column title=\"Tax\" field=\"TAX\" width=\"\" align=\"\" type=\"\" sum=\"true\" />\r\n	</columns>\r\n</report>'),(51,'PURCHASE BY TAX AND CATEGORY','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>PURCHASE BY TAX AND CATEGORY</title>\r\n<script>\r\n<![CDATA[ SELECT \r\nTAXES.NAME AS TAXNAME,\r\nCATEGORIES.NAME,\r\nSUM(PURCHASEINVOICELINES.QUANTITY) AS QTY, \r\nSUM(PURCHASEINVOICELINES.UNITPRICE * PURCHASEINVOICELINES.QUANTITY) AS CATPRICE, \r\nSUM(( PURCHASEINVOICELINES.UNITPRICE * TAXES.RATE ) * PURCHASEINVOICELINES.QUANTITY) AS CATTAX, \r\nSUM(( PURCHASEINVOICELINES.UNITPRICE + PURCHASEINVOICELINES.UNITPRICE * TAXES.RATE ) * PURCHASEINVOICELINES.QUANTITY) AS CATTOTAL \r\n FROM PURCHASEINVOICE\r\n JOIN PURCHASEINVOICELINES ON PURCHASEINVOICE.ID=PURCHASEINVOICELINES.PIID\r\n JOIN TAXES ON PURCHASEINVOICELINES.TAXID = TAXES.ID\r\n LEFT OUTER JOIN PRODUCTS ON PURCHASEINVOICELINES.PRODUCT = PRODUCTS.ID \r\n LEFT OUTER JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID\r\n LEFT JOIN SUPPLIERS ON SUPPLIERS.ID=PURCHASEINVOICE.SUPPLIERID WHERE ? \r\n GROUP  BY TAXES.NAME,CATEGORIES.NAME ]]>\r\n</script>\r\n<filters>\r\n<filter title=\"From date\" name=\"FDATE\" field=\"PURCHASEINVOICE.DELIVERYDATE\" type=\"date\" operator=\">=\" value=\"{SELECT DATE_SUB(CURDATE(),INTERVAL 30 DAY) AS DATE}\" />\r\n<filter title=\"To date\" name=\"TDATE\" field=\"PURCHASEINVOICE.DELIVERYDATE\" type=\"date\" operator=\"<=\" value=\"{SELECT CURDATE() as DATE}\" />\r\n</filters>\r\n<groups>\r\n        <group field=\"TAXNAME\" align=\"left\" type=\"text\" sum=\"\" />\r\n</groups>\r\n<columns>\r\n        <column title=\"Category\" field=\"NAME\" width=\"\" align=\"left\" type=\"text\" sum=\"\" />\r\n		<column title=\"Quantity\" field=\"QTY\" width=\"\" align=\"center\" type=\"text\" sum=\"true\" />\r\n		<column title=\"Sales\" field=\"CATPRICE\" width=\"\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n		<column title=\"Tax\" field=\"CATTAX\" width=\"\" align=\"right\"  type=\"currency\" sum=\"true\" />\r\n		<column title=\"Total\" field=\"CATTOTAL\" width=\"\" align=\"right\"  type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(52,'INVENTORY BROKEN','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>INVENTORY BROKEN</title>\r\n<script><![CDATA[ SELECT STOCKCURRENT.LOCATION AS LOCATIONID, LOCATIONS.NAME AS LOCATIONNAME, PRODUCTS.REFERENCE, PRODUCTS.NAME AS NAME, PRODUCTS.PRICEBUY, PRODUCTS.CATEGORY, CATEGORIES.NAME AS CATEGORYNAME, SUM(STOCKCURRENT.UNITS) AS UNITS, (SUM(STOCKCURRENT.UNITS)*PRODUCTS.PRICEBUY) AS COST, COALESCE(STOCKLEVEL.STOCKSECURITY, 0) AS STOCKSECURITY, COALESCE(STOCKLEVEL.STOCKMAXIMUM, 0) AS STOCKMAXIMUM FROM STOCKCURRENT JOIN LOCATIONS ON STOCKCURRENT.LOCATION = LOCATIONS.ID JOIN PRODUCTS ON STOCKCURRENT.PRODUCT = PRODUCTS.ID JOIN CATEGORIES ON PRODUCTS.CATEGORY = CATEGORIES.ID LEFT OUTER JOIN STOCKLEVEL ON STOCKCURRENT.LOCATION = STOCKLEVEL.LOCATION AND STOCKCURRENT.PRODUCT = STOCKLEVEL.PRODUCT WHERE ? GROUP BY STOCKCURRENT.LOCATION, LOCATIONS.NAME, PRODUCTS.REFERENCE, PRODUCTS.NAME, PRODUCTS.CATEGORY, CATEGORIES.NAME, STOCKLEVEL.STOCKSECURITY, STOCKLEVEL.STOCKMAXIMUM HAVING STOCKLEVEL.STOCKSECURITY IS NOT NULL AND STOCKLEVEL.STOCKSECURITY >= SUM(STOCKCURRENT.UNITS) ORDER BY CATEGORIES.NAME, PRODUCTS.NAME, STOCKCURRENT.LOCATION ]]></script>\r\n<filters>\r\n<filter title=\"category\" field=\"PRODUCTS.CATEGORY\" name=\"category\" type=\"list\" operator=\"=\" value=\"{SELECT ID, NAME FROM CATEGORIES}\" />\r\n<filter title=\"location\" field=\"STOCKCURRENT.LOCATION\" name=\"location\" type=\"list\" operator=\"=\" value=\"{SELECT ID, NAME FROM LOCATIONS}\" /> 	\r\n<filter title=\"Barcode\" field=\"PRODUCTS.CODE\" name=\"CODE\" type=\"text\" operator=\"=\" value=\"\" />\r\n<filter title=\"Product Name\" field=\"PRODUCTS.NAME\" name=\"PRODUCTNAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n</filters>\r\n<groups>\r\n    <group field=\"CATEGORYNAME\" align=\"left\" type=\"text\" sum=\"\" />\r\n    <group field=\"NAME\" align=\"left\" type=\"text\" sum=\"\" />\r\n</groups>\r\n<columns>\r\n        <column title=\"Location\" field=\"LOCATIONNAME\" width=\"\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Buy Price\" field=\"PRICEBUY\" width=\"\" align=\"right\" type=\"currency\" sum=\"\" />\r\n        <column title=\"Units\" field=\"UNITS\" width=\"\" align=\"center\" type=\"text\" sum=\"\" />\r\n        <column title=\"Stock Minimum\" field=\"STOCKSECURITY\" width=\"\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Stock Maximum\" field=\"STOCKMAXIMUM\" width=\"\" align=\"left\" type=\"text\" sum=\"\" />\r\n        <column title=\"Total Cost\" field=\"COST\" width=\"\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(53,'SUPPLIERS DEFAULTING','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>SUPPLIERS DEFAULTING</title>\r\n<script><![CDATA[ SELECT ID, TAXID,SEARCHKEY, NAME, ADDRESS, NOTES,  MAXDEBT, CURDATE, CURDEBT FROM SUPPLIERS WHERE VISIBLE = TRUE AND CURDEBT IS NOT NULL AND CURDEBT > 0 AND ? ]]></script>\r\n<filters>\r\n<filter title=\"Name\" field=\"NAME\" name=\"NAME\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Search key\" field=\"SEARCHKEY\" name=\"SEARCHKEY\" type=\"text\" operator=\"like\" value=\"\" />\r\n<filter title=\"Days Transaction before\" field=\"datediff(CURDATE(), CURDATE)\" name=\"DAYS\" type=\"text\" operator=\">=\" value=\"\" />\r\n</filters>\r\n<columns>\r\n<column title=\"Search Key\" field=\"SEARCHKEY\" width=\"50px\" align=\"left\" type=\"text\" />\r\n<column title=\"Name\" field=\"NAME\" width=\"70px\" align=\"left\" type=\"text\" />\r\n<column title=\"Max. Debt\" field=\"MAXDEBT\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"\" />\r\n<column title=\"Debt Date\" field=\"CURDATE\" width=\"70px\" align=\"right\" type=\"date\" sum=\"\" />\r\n<column title=\"Current Debt\" field=\"CURDEBT\" width=\"70px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>'),(54,'NOT POPULAR PRODUCTS','<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<report>\r\n<title>NOT POPULAR PRODUCTS</title>\r\n<script><![CDATA[ SELECT P.NAME, IFNULL(SUM(TL.UNITS), 0) AS QTY, IFNULL(SUM(TL.UNITS * TL.PRICE), 0) AS AMOUNT \r\nFROM PRODUCTS AS P \r\nJOIN CATEGORIES C2 ON P.CATEGORY=C2.ID\r\nJOIN CATEGORIES C ON (C.ID=P.CATEGORY OR P.CATEGORY IN (SELECT ID FROM CATEGORIES WHERE PARENTID=C.ID))\r\nLEFT JOIN TICKETLINES AS TL ON TL.PRODUCT=P.ID LEFT JOIN TICKETS AS T ON T.ID = TL.TICKET LEFT JOIN RECEIPTS AS R ON R.ID = T.ID WHERE P.ISCOM <> TRUE AND ? GROUP BY P.ID ORDER BY QTY ASC ]]></script>\r\n<filters>\r\n<filter title=\"Category\" name=\'CATEGORY\' field=\"C.ID\" type=\"list\" operator=\"=\" value=\"{SELECT ID,NAME from CATEGORIES}\" />\r\n</filters>\r\n<limit value=\"\" />\r\n<columns>\r\n<column title=\"Product Name\" field=\"NAME\" width=\"100px\" align=\"left\" type=\"text\" />\r\n<column title=\"Quantity\" field=\"QTY\" width=\"50px\" align=\"center\" type=\"text\"  sum=\"true\" />\r\n<column title=\"Amount\" field=\"AMOUNT\" width=\"50px\" align=\"right\" type=\"currency\" sum=\"true\" />\r\n</columns>\r\n</report>');

DELETE FROM RESOURCES WHERE NAME='Webin.Menu';
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('501','Webin.Menu',0,'<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<elements>\r\n<level1 key=\"Dashboard\"></level1>\r\n<level1 key=\"Sales\"></level1>\r\n<level2 key=\"Active Tickets\">sales/activetickets</level2>\r\n<level2 key=\"Receipts\">sales/sales</level2>\r\n<level2 key=\"Closed Cash\">sales/closecash</level2>\r\n<level2 key=\"Reservations\">sales/reservation</level2>\r\n<level2 key=\"Payments\">payment/payments</level2>\r\n<level1 key=\"Purchase\"></level1>\r\n<level2 key=\"Purchase Invoice\">inventory/purchaseinvoice</level2>\r\n<level2 key=\"Stock Maintanance\">inventory/stock/stockdiary</level2>\r\n<level2 key=\"Products\">inventory/products</level2>\r\n<level3 key=\"Products\">inventory/products</level3>\r\n<level3 key=\"Auxiliary Products\">inventory/products/auxiliaryproducts</level3>\r\n<level3 key=\"Product Categories\">inventory/categories/products</level3>\r\n<level2 key=\"Tariff\">inventory/tariff</level2>\r\n<level2 key=\"Reorder Levels\">inventory/reorderlevel</level2>\r\n<level1 key=\"Finance\"></level1>\r\n<level2 key=\"Accounts\">finance/accounts</level2>\r\n<level2 key=\"Payments\">finance/payments</level2>\r\n<level2 key=\"Transactions\">finance/transactions</level2>\r\n<level2 key=\"Deposits\">finance/deposits</level2>\r\n<level2 key=\"Transfer\">finance/Transfer</level2>\r\n<level2 key=\"Payment Heads\">finance/paymentshead</level2>\r\n<level2 key=\"Statement\">finance/statement</level2>\r\n<level2 key="P/L Statement">finance/plstatement</level2>\r\n<level1 key=\"Partners\"></level1>\r\n<level2 key=\"Customers\">partner/customers</level2>\r\n<level2 key=\"Suppliers\">partner/supplier</level2>\r\n<level2 key=\"Partner Categories\">partner/customers/categories</level2>\r\n<level1 key=\"Reports\">reportlist</level1>\r\n<level1 key=\"Settings\"></level1>\r\n<level2 key=\"Company Information\">settings/companyinfo</level2>\r\n<level2 key=\"Warehouses\">settings/warehouses</level2>\r\n<level2 key=\"Units of Measure\">settings/uom</level2>\r\n<level2 key=\"Tax Categories\">settings/taxes/taxcats</level2>\r\n<level2 key=\"Taxes\">settings/taxes</level2>\r\n<level2 key=\"Roles\">settings/users/roles</level2>\r\n<level2 key=\"Users\">settings/users</level2>\r\n<level2 key=\"Resources\">settings/resources</level2>\r\n<level2 key=\"Bulk Load\">settings/bulkload</level2>\r\n</elements>');


DELETE FROM RESOURCES WHERE NAME='Webin.Reports';
INSERT INTO RESOURCES(ID, NAME, RESTYPE, CONTENT) VALUES('505','Webin.Reports',0,'<?xml version="1.0" encoding="UTF-8"?>
<elements>
<level1 key="Sales">Sales</level1>
<level2 key="Closed Cash">report/view/19</level2>
<level2 key="Product Sales">report/view/20</level2>
<level2 key="Popular Products">report/view/21</level2>
<level2 key="UnPopular Products">report/view/54</level2>
<level2 key="Payments">report/view/23</level2>
<level2 key="Sales by User">report/view/29</level2>
<level2 key="Product Sales Log">report/view/32</level2>
<level2 key="Sales Tax Summary">report/view/34</level2>
<level2 key="Sales Tax Log">report/view/22</level2>
<level2 key="Category Sales">report/view/39</level2>
<level2 key="Sales By Tax and Category">report/view/49</level2>
<level2 key="Sales Log">report/view/48</level2>

<level1 key="Sales">Purchase</level1>
<level2 key="Products List">report/view/1</level2>
<level2 key="Purchase Invoice">report/view/2</level2>
<level2 key="Purchase Tax Log">report/view/50</level2>
<level2 key="Purchase By Tax And Category">report/view/51</level2>
<level2 key="Inventory Broken">report/view/52</level2>
<level2 key="Current Inventory">report/view/31</level2>
<level2 key="Purchase Tax Log Summary">report/view/35</level2>
<level2 key="Stock Diary">report/view/36</level2>
<level2 key="Purchase Log">report/view/24</level2>
<level2 key="Product Purchase">report/view/42</level2>
<level2 key="Product Purchase Details">report/view/43</level2>

<level1 key="Sales">Finance</level1>
<level2 key="Expenses">report/view/30</level2>
<level2 key="Expenses Summary">report/view/37</level2>
<level2 key="Account Summary">report/view/40</level2>

<level1 key="Sales">Customers</level1>
<level2 key="Customers List">report/view/25</level2>
<level2 key="Customers Diary">report/view/28</level2>
<level2 key="Customers Defaulting">report/view/27</level2>

<level1 key="Sales">Suppliers</level1>
<level2 key="Suppliers List">report/view/26</level2>
<level2 key="Suppliers Diary">report/view/47</level2>
<level2 key="Suppliers Defaulting">report/view/53</level2>
</elements>');

UPDATE ROLES SET PERMISSIONS='<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!--\r\n        Posics Saleculator - Billing System.\r\n        Copyright (C) 2009 Posics\r\n        This file is part of Posics Saleculator.\r\n -->\r\n<webcontrollers>\r\nDataboxes;\r\nActivetickets;\r\nCategories;\r\nReorderlevel;\r\nCompanyinfo;\r\nCustomers;\r\nGoodsreceipts;\r\nMaterials;\r\nSearchmaterials;\r\nProductgroups;\r\nProducts;\r\nSearchproducts;\r\nRefunds;\r\nResources;\r\nSales;\r\nSalereport;\r\nPopularproducts;\r\nProductsbywarehouse;\r\nPurchaseinvoice;\r\nSaleslog;\r\nSettings;\r\nStock;\r\nSupplier;\r\nTariff;\r\nsalestotalregister;\r\nusers;\r\nWarehouses;\r\nWelcome;\r\nSales;\r\nTaxes;\r\nInventory;\r\nPartners;\r\nUom;\r\nAttribute;\r\nReservation;\r\nPayments;\r\nClosecash;\r\nCurrentinventory;\r\nDashboard;\r\nMenu;\r\nProdlabel;\r\nTicket;\r\nBulkload;\r\nFinance;\r\n    Accounts;\r\n    Payments;\r\n    Transactions;\r\n    Deposits;\r\n    Transfer;\r\n    Statement;\r\nPlstatement;\r\nProfitandlossstatement;    Paymentshead;\r\nReport;\r\nReports;\r\nReportlist;\r\nDatabasebackup;\r\n</webcontrollers>' WHERE NAME='Webadmin';

ALTER TABLE CATEGORIES ADD COLUMN CATEGORYTYPE TINYINT DEFAULT 0 NOT NULL;
ALTER TABLE CONFIGURATION ADD COLUMN TIMEZONE VARCHAR(255) DEFAULT 'Asia/Dubai';
ALTER TABLE CONFIGURATION ADD COLUMN LOCATION VARCHAR(255) NOT NULL DEFAULT '0';
ALTER TABLE CONFIGURATION ADD FOREIGN KEY (LOCATION) REFERENCES LOCATIONS(ID);
ALTER TABLE PRODUCTS ADD COLUMN ITEMTYPE TINYINT DEFAULT 0 NOT NULL;
ALTER TABLE PAYMENTHEADS ADD COLUMN TAXCAT VARCHAR(255) NULL AFTER PAYMENTHEAD;
ALTER TABLE PAYMENTHEADS ADD CONSTRAINT PAYHEAD_TAXCAT FOREIGN KEY (TAXCAT) REFERENCES TAXCATEGORIES(ID);