        <!-- Page Content -->
        <div class="page-content">
            <!-- Page Header -->
            <div class="page-header position-relative">
                 <div class="header-title">
                    <h1>
                      <?php echo $this->lang->line("CLOSEDCASH"); ?>
                    </h1>
                </div>
                <!--Header Buttons-->
                <div class="header-buttons">
                    <a class="sidebar-toggler" href="#">
                        <i class="fa fa-arrows-h"></i>
                    </a>
                    <a class="refresh" id="refresh-toggler" href="">
                        <i class="glyphicon glyphicon-refresh"></i>
                    </a>
                    <a class="fullscreen" id="fullscreen-toggler" href="#">
                        <i class="glyphicon glyphicon-fullscreen"></i>
                    </a>
                </div>
                <!--Header Buttons End-->
            </div>
            <!-- /Page Header -->
            <!-- Page Body -->
            <div class="page-body">
                <div class="row">
                    <div class="col-xs-12 col-md-12">
                        <div class="widget">
                            <div class="widget-body">
                                <div class="input-group" style="width: 175px;float: left;margin-left: 15px;">
                                    <input class="form-control date-picker" name="filter_begin" id="filter_begin"
                                       type="text" placeholder="<?php echo $this->lang->line("FROM"); ?>"
                                       data-date-format="yyyy-mm-dd" readonly value="<?php echo date("d-m-Y",strtotime("-1 month")); ?>" />
                                    <span class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </span>
                                </div>
                                <div class="input-group" style="width: 175px;padding-left: 15px;">
                                    <input class="form-control date-picker" name="filter_end" id="filter_end" type="text"
                                        placeholder="<?php echo $this->lang->line("TO"); ?>"
                                        data-date-format="yyyy-mm-dd" readonly value="<?php echo date("d-m-Y"); ?>" />
                                        <span class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </span>
                                </div>
                                <div class="table-toolbar">
                                  <div class="table-responsive">
                                <table class="table table-striped table-hover table-bordered editable" id="closecashdatatable">
                                    <thead>
                                        <tr role="row">
                                            <th>
                                                <?php echo $this->lang->line("STATION"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("SEQUENCE"); ?>
                                            </th>
                                             <th>
                                                <?php echo $this->lang->line("START")." ".$this->lang->line("DATE"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("END")." ".$this->lang->line("DATE"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("TOTAL"); ?>
                                            </th>
                                            <th>
                                                action
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
                             </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Page Body -->
        </div>
        <!-- /Page Content -->
    </div>
    <!-- /Page Container -->
    <!-- Main Container -->
</div>
    <script type="text/javascript">
        $( document ).ready(function() {
            drawtabledata();
            $('#filter_begin').datepicker().on('changeDate', function (ev) { 
                drawtabledata();
            });
            $('#filter_end').datepicker().on('changeDate', function (ev) { 
                drawtabledata();
            });
        });
        function drawtabledata() {
            $('#closecashdatatable').DataTable().destroy();
            var filter_begin = $('#filter_begin').val();
            var filter_end = $('#filter_end').val();
            var table = $('#closecashdatatable').DataTable( {
                "bProcessing": true,
                "bServerSide": true,
                "sAjaxSource": "<?php echo base_url('sales/closecash/getclosecash') ?>?filter_begin="+filter_begin+"&filter_end="+filter_end,
                "lengthMenu": [[20, 50, 100], [20, 50, 100]],
                "language": {
                    "lengthMenu": "<?php echo $this->lang->line("DISPLAY"); ?> _MENU_ <?php echo $this->lang->line("RECORDSPERPAGE"); ?>",
                    "zeroRecords": "<?php echo $this->lang->line("NOTHINGFOUND"); ?>",
                    "info": "<?php echo $this->lang->line("SHOWINGPAGE"); ?> _PAGE_ <?php echo $this->lang->line("OF"); ?> _PAGES_",
                    "infoEmpty": "<?php echo $this->lang->line("NORECORDSAVAILABLE"); ?>",
                    "infoFiltered": "(<?php echo $this->lang->line("FILTEREDFROM"); ?> _MAX_ <?php echo $this->lang->line("TOTALRECORDS"); ?>)",
                    "search": "<?php echo $this->lang->line("SEARCH"); ?> : ",
                    "paginate": {
                        "previous": "<?php echo $this->lang->line("PREVIOUS"); ?>",
                        "next":"<?php echo $this->lang->line("NEXT"); ?>"
                    }
                },
                "columnDefs" : [
                    {"targets": [ 5 ],"sortable" : false  ,"render": function ( data, type, row ) {
                        return '<div class="buttons-preview">\n\
            <a class="btn btn-yellow btn-xs shiny" href="'+base_url+'sales/closecash/getclosecashdetails/'+data+'/"><i class="fa fa-eye"></i></a>\n\
<a class="btn btn-danger btn-xs shiny" href="'+base_url+'sales/closecash/printcc/'+data+'/" target="_blank"><i class="fa fa-file-pdf-o"></i></a></div>';
                    }}
                ],
            });
        }
        
    </script>