<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Saleculator Price Check</title>
    <link rel="shortcut icon" href="<?php echo base_url();?>assets/img/favicon.png" type="image/x-icon">
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #96b859;
            text-align: center;
            padding: 20px;
        }

        .price-checker-container {
            background-color: #ffffff;
            border-radius: 15px;
            padding: 30px;
            max-width: 400px;
            margin: 0 auto;
            box-shadow: 0px 4px 8px rgba(0, 0, 0, 0.1);
        }

        h1 {
            color: #61b341;
            font-size: 24px;
            margin-bottom: 10px;
        }

        p {
            color: #555;
            font-size: 16px;
        }

        .item-details {
            background-color: #f7f7f7;
            padding: 20px;
            border-radius: 10px;
            margin-top: 20px;
        }

        .item-name {
            font-size: 20px;
            font-weight: bold;
            color: #333;
        }

        .item-price {
            font-size: 48px;
            font-weight: bold;
            color: #333;
            margin: 10px 0;
        }

        .item-info {
            font-size: 12px;
            color: #888;
        }

        .scan-instruction {
            margin-top: 20px;
            font-size: 14px;
            color: #555;
        }

        .scan-icon {
            margin-top: 10px;
            width: 50px;
        }

        .footer-text {
            font-size: 12px;
            margin-top: 20px;
            color: #666;
        }

        /* Adjusted input style to make it focusable */
        #barcodeInput {
            position: absolute;
            left: 0;
            top: 0;
            opacity: 0;
            width: 1px;
            height: 1px;
            z-index: -1;
        }
    </style>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const barcodeInput = document.getElementById("barcodeInput");

            // Focus on the input field as soon as the page loads
            barcodeInput.focus();

            // Keep focus on the input field to ensure it captures the barcode scan
            barcodeInput.addEventListener("blur", function() {
                setTimeout(function() {
                    barcodeInput.focus();
                }, 0);
            });

            // Event listener to handle barcode scanning and fetching product details
            barcodeInput.addEventListener("keypress", function(event) {
                if (event.key === "Enter") {
                    event.preventDefault();
                    // Fetch the product details when barcode is entered
                    fetchProductDetails(barcodeInput.value.trim());
                    // Clear the input field for the next scan
                    barcodeInput.value = '';
                }
            });

            function fetchProductDetails(barcode) {
                // Example API call to fetch product details
                fetch(`pricecheck/searchcode?barcode=${encodeURIComponent(barcode)}`)
                    .then(response => response.json())
                    .then(data => {
                        // Update the UI with the fetched product details
                        document.querySelector(".item-name").textContent = data.name || 'Item not found';
                        document.querySelector(".item-price").textContent = data.price ? `${data.price}` : 'N/A';
                        document.querySelector(".item-info").innerHTML = `Barcode: <strong>${data.barcode || barcode}</strong>`;
                    })
                    .catch(error => {
                        console.error('Error fetching product details:', error);
                        document.querySelector(".item-name").textContent = 'Error fetching item';
                        document.querySelector(".item-price").textContent = 'N/A';
                        document.querySelector(".item-info").innerHTML = `Barcode: <strong>${barcode}</strong>`;
                    });
            }
        });
    </script>
</head>
<body>

    <div class="price-checker-container">
        <h1>Price Check</h1>
        <p>Please scan the barcode</p>

        <div class="item-details">
            <div class="item-name">Awaiting Scan...</div>
            <div class="item-price">0.00</div>
            <div class="item-info">Barcode: <strong>N/A</strong></div>
        </div>

        <img src="<?php echo base_url();?>assets/img/scan.png" alt="Scan Icon" class="scan-icon">

        <div class="footer-text">Powered by Saleculator</div>
    </div>

    <!-- Adjusted input field -->
    <input type="text" id="barcodeInput" autocomplete="off">

</body>
</html>
