<script type="text/javascript">
    $(function(){
        $( "#showhidesearch" ).button({
            icons: {
                primary: "ui-icon-search"
            },
            text: true
        });
        $('#datepicker').datepicker({ dateFormat: 'yy-mm-dd' });
        $('#datepicker2').datepicker({ dateFormat: 'yy-mm-dd' });
        $("#search").click(function(){
            loadGrid();
        });
        $("#show").click(function(){
            loadGrid();
        });
    });

    function loadGrid(){
        var datefrom = document.getElementById('datepicker');
        var dateto = document.getElementById('datepicker2');
        $("#lines").GridUnload();
        jQuery("#lines").jqGrid({
            url:'<?= site_url() ?>inventory/wastage/getwastagereport',
            datatype: "json",
            mtype : "post",
            colNames:['NAME', 'QTY', 'UNITPRICE', 'TOTAL'],
            postData: {datefrom: datefrom.value,dateto: dateto.value},
            datatype: "json",
            mtype : "post",
            colModel:[
                {name:'NAME',index:'NAME', width:110},
                {name:'UNITS',index:'UNITS', width:110},
                {name:'PRICE',index:'PRICE',  align:"right",width:110,formatter:'currency', formatoptions: {thousandsSeparator:','},editoptions:{readonly:true,size:10}},
                {name:'TOTAL',index:'TOTAL',  align:"right",width:110,formatter:'currency', formatoptions: {thousandsSeparator:','},editoptions:{readonly:true,size:10}},
            ],
            rowNum:15,
            rowList:[15,30,100000000],
            rownumbers: true,
            rownumWidth: 40,
            height: 350,
            width:800,
            pager: '#pgtoolbar1',
            sortname: 'NAME',
            viewrecords: true,
            userDataOnFooter: true,
            sortorder: "asc",
            footerrow: true,
            multiselect: true,
            loadComplete: function() {
                $("option[value=100000000]").text('All');
                var reportSum = jQuery('#lines').jqGrid('getCol', 'TOTAL', false, 'sum');
                jQuery('#lines').jqGrid('footerData', 'set',
                {
                    'NAME': 'Total:',
                    'TOTAL': reportSum
                });

            },
            beforeSelectRow: function(rowid, e)
            {
                jQuery("#lines").jqGrid('resetSelection');
                return(true);
            }
        });
        $("#lines").jqGrid('navGrid', '#pgtoolbar1',{view:false, del:false, search:false, refresh:false, add:false, edit:false, excel:true})
        .navButtonAdd('#pgtoolbar1',{
            caption:"Export to Excel",
            buttonicon:"ui-icon-save",
            onClickButton: function(){
                exportExcel();
            },
            position:"last"
        });
        function exportExcel()
        {
            var mya=new Array();
            mya=$("#lines").getDataIDs();  // Get All IDs
            var data=$("#lines").getRowData(mya[0]);     // Get First row to get the labels
            var colNames=new Array();
            var ii=0;
            for (var i in data){colNames[ii++]=i;}    // capture col names
            var html="";
            for(i=0;i<mya.length;i++)
            {
                data=$("#lines").getRowData(mya[i]); // get each row
                for(j=0;j<colNames.length;j++)
                {
                    html=html+data[colNames[j]]+","; // output each column as tab delimited
                }
                html=html+"\n";  // output each row with end of line

            }
            html=html+"\n";  // end of line at the end

            document.forms[0].exportdata.value=html;
            document.forms[0].method='POST';
            document.forms[0].action='<?php echo site_url('inventory/wastage/exportcsv'); ?>';  // send it to server which will open this contents in excel file
            document.forms[0].target='_blank';
            document.forms[0].submit();
        }
    }
    $(document).ready(function() {
        $("button").button();
        loadGrid(null);
    });
</script>
<!--GET PRODUCTS FROM PRODUCT'S TABLE-->
<style>
    .ui-autocomplete-loading { background: white url('<?= site_url() ?>public/images/ui-anim_basic_16x16.gif') right center no-repeat; }
</style>


<script>
    // increase the default animation speed to exaggerate the effect
    $.fx.speeds._default = 1000;
    $(function() {
        $( "#dialog" ).dialog({
            autoOpen: false,
            show: "blind",
            hide: "explode",buttons: {
                Ok: function() {
                    $( this ).dialog( "close" );
                }
            }

        });

    });
</script>
<div class="demo">
    <div id="dialog" title="Message">
        <p>Please select a row !</p>
    </div>

</div><!-- End demo -->

<div class="main content clearfix">
    <div class="page-heading">
        <h2>Wastage Report</h2>
    </div>
    <!-- end page-heading -->

    <table align="right" border="0" width="100%" cellpadding="0" cellspacing="0" id="content-table">
        <tr>
            <th rowspan="3" class="sized"><img src="<?= site_url() ?>images/shared/side_shadowleft.jpg" width="20" height="300" alt="" /></th>
            <th class="topleft"></th>
            <td id="tbl-border-top">&nbsp;</td>
            <th class="topright"></th>
            <th rowspan="3" class="sized"><img src="<?= site_url() ?>images/shared/side_shadowright.jpg" width="20" height="300" alt="" /></th>
        </tr>
        <tr>
            <td id="tbl-border-left"></td>
            <td>
                <!-- start content-table-inner ...................................................................... START -->
                <div id="content-table-inner">

                    <!-- start table-content -->
                    <div id="table-content">
                        <?php
                        if ($this->session->flashdata('msgt') == 'E') {
                            echo '
<div id="message-red">
<table border="0" width="100%" cellpadding="0" cellspacing="0">
<tr>
<td class="red-left">' . $this->session->flashdata('msg') . '</td>
<td class="red-right"><a class="close-red"><img src="' . site_url() . 'images/table/icon_close_red.gif" alt="" /></a></td>
</tr>
</table>
</div><br>
';
                        }
                        if ($this->session->flashdata('msgt') == 'S') {
                            echo '
<div id="message-green">
<table border="0" width="100%" cellpadding="0" cellspacing="0">
<tr>
<td class="green-left">' . $this->session->flashdata('msg') . '</a></td>
<td class="green-right"><a class="close-green"><img src="' . site_url() . 'images/table/icon_close_green.gif" alt="" /></a></td>
</tr>
</table>
</div><br>
';
                        }
                        ?>
                        <!-- start product-table ..................................................................................... -->


                        <table>
                            <th valign="middle"><span style="color:red;"></span>Date From:</th>
                            <td>
                                <input name="datefrom" type="text" id="datepicker"  value="<?php echo date('Y-m-d'); ?>" class="inp-form-small"/>
                            </td>
                            <th valign="middle"><span style="color:red;"></span>Date To:</th>
                            <td>
                                <input name="dateto" type="text" id="datepicker2"  class="inp-form-small"/>
                            </td>
                            <td>
                                <span class="button-strip">
                                    <button id="show" name="add">Show</button></span>
                            </td>
                        </table>

                        <form method="post" action="<?php echo site_url('inventory/wastage/exportcsv'); ?>">
                            <input type="hidden" name="exportdata" id="exportdata" value="" />
                        </form>
                        <table id="lines"></table>
                        <div id="pgtoolbar1"></div>
                        <!-- end content-table -->
                    </div>

                    <div class="clear"></div>

                </div>
                <!-- end content-table-inner ............................................END -->
            </td>
            <td id="tbl-border-right"></td>
        </tr>
        <tr>
            <th class="sized bottomleft"></th>
            <td id="tbl-border-bottom">&nbsp;</td>
            <th class="sized bottomright"></th>
        </tr>
    </table>

    <div class="clear">&nbsp;</div>
</div>
