
<div class="page-content">
    <!-- Page Breadcrumb -->
    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#">Account Statement</a>
            </li>
            <li class="active">Account Statement</li>
        </ul>
    </div>
    <!-- /Page Breadcrumb -->

    <!-- Page Header -->
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                Account Statement
            </h1>
        </div>
        <!--Header Buttons-->
        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>
        <!--Header Buttons End-->
    </div>
    <!-- /Page Header -->
    <!-- Page Body -->
    



    
    <!-- End Page Body -->
                

    <div class="page-body">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="row">
                    <div class="col-xs-12 col-md-12">
                        <div class="widget">
                            <div class="widget-header ">
                                <span class="widget-caption">Account Statement</span>
                                <div class="widget-buttons">
                                    <a href="#" data-toggle="maximize">
                                        <i class="fa fa-expand"></i>
                                    </a>
                                    <a href="#" data-toggle="collapse">
                                        <i class="fa fa-minus"></i>
                                    </a>
                                    <a href="#" data-toggle="dispose">
                                        <i class="fa fa-times"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="widget-body">
                                <form id="form_accounts" method="post" action="<?php echo site_url('delete_accounts')?>">
                                <table border="0" cellspacing="15" cellpadding="5" id="filter_inputs" >
                                    <tbody>
                                        <tr>
                                            
                                            <td>
                                                <div class="input-group">
                                                    <select id="trial_account" name="account" style="width:100%" required>
                                                        <option value="-1">Select Account</option>
                                                        <?php
                                                            foreach ($accounts as $key => $value) {
                                                                echo "<option value=\"".$value->id."\" />".$value->account_name;    
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <select id="year" name="year" style="width:100%" required>
                                                        <?php
                                                            foreach ($years as $key => $value) {
                                                                echo "<option value=\"".$value->tdate."\" />".$value->tdate;    
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <select id="month" name="month" style="width:100%" required>
                                                        <?php
                                                            foreach ($months as $key => $value) {
                                                                echo "<option value=\"".++$key."\" />".$value;    
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <div class="open_balance">
                                    <div class="open_bal_head">
                                        Opening Balance: 
                                    </div>
                                    <div id="open_bal" class="open_bal_val">
                                        
                                    </div>
                                </div>
                                <table class="table table-striped table-hover table-bordered" id="trial">
                                    <thead>
                                        <tr role="row">
                                            <th>
                                                Transaction   
                                            </th> 
                                            <th>
                                                Debit
                                            </th>
                                            <th>
                                                Credit
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
                                <div class="closing_balance">
                                    <div class="closing_bal_head">
                                        Closing Balance: 
                                    </div>
                                    <div id="closing_bal" class="closing_bal_val">
                                        
                                    </div>
                                </div>

                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

   <!-- End Page Content    -->
<script>
    
    $(document).ready(function () {
        var table = $('#trial').DataTable({
            "processing": true,
            "serverSide": true,
            "aLengthMenu": [
                    [5, 15, 20, 100],
                    [5, 15, 20, 100]
                ],
            "sPaginationType": "bootstrap",
            "sDom": "Tflt<'row DTTTFooter'<'col-sm-6'i><'col-sm-6'p>>",
            "tableTools": {
                "aButtons": [
                        "copy"
                    ]
            },
            "ajax":{
                "url": "<?php echo base_url('view_trial') ?>",
                "dataType": "json",
                "type": "POST",
                "data": function(d){
                    d.year = $('#year').val();
                    d.month = $('#month').val();
                    d.account = $('#trial_account').val();
                    d.search_btn = $('#search_btn').val();
                },
                "dataSrc": function (json) {
                    console.log(json.extra_data);
                    $('#open_bal').text("$  "+json.extra_data.open_bal);
                    $('#closing_bal').text("$  "+json.extra_data.closing_bal);
                    // $("#mydata").val(json.recordsTotal);
                    return json.data;
                }
            },
            "oLanguage": {
                "sLengthMenu": "\_MENU_",
                "sSearch": "" 
            },

            "columns": [
                    { "data": "transaction",
                      "bSortable": false},
                    { "data": "debit" ,
                      "bSortable": false},
                    { "data": "credit" ,
                      "bSortable": false}
                ],
            "searching": false	 

            });
            
        //search
            $("<a style='margin-left:5px'  class='search_btn btn btn-info fa fa-search'></a><a style='margin-left:5px'  class='remove_btn btn btn-info fa fa-remove'></a><input type='hidden' name='search_btn' id='search_btn'>").appendTo(".dataTables_filter");
        
            $(".search_btn").click(function(){
                $("#search_btn").val("search");
                table.ajax.reload();
                $("#search_btn").val("");
            });

            $(".remove_btn").click(function(){
                location.reload();

            });

            $("input[type=search]").on("keypress", function(e){

                if(e.keyCode === 13){

                    e.preventDefault(); // Ensure it is only this code that rusn

                    $(".search_btn").click();
                }else{
                    return;
                }

            });

        $('#trial').wrap($('<div style="overflow-x:scroll; width:100%"/>'));


        $('#trial_account').change(function(){
            console.log("account");
            table.ajax.reload();
        });
        $('#year').change( function(){
            console.log("year");
            table.ajax.reload();
        });
        $('#month').change( function(){
            console.log("month");
            table.ajax.reload();
        });

        
 
    });
</script>