<style type=text/css>
    #withdrawl_length{
        display: none;
    }
    .remove_btn{
        display: none;
    }
    .search_btn{
        display: none;
    }
</style>

<div class="page-content">
    <!-- Page Breadcrumb -->
    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#"><?php echo $this->lang->line("FINANCE"); ?></a>
            </li>
            <li class="active"><?php echo $this->lang->line("TRANSACTION"); ?></li>
        </ul>
    </div>
    <!-- /Page Breadcrumb -->
    <!-- Page Header -->
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                <?php echo $this->lang->line("TRANSACTION"); ?>
            </h1>
        </div>
        <!--Header Buttons-->
        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>
        <!--Header Buttons End-->
    </div>
    <!-- /Page Header -->
    <!-- Page Body -->
    <!-- End Page Body -->
    <div class="page-body">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="row">
                    <div class="col-xs-12 col-md-12">
                        <div class="widget">
                            <div class="widget-body">
                                <div id="tablecontent" class="table-scrollable" style="padding-top:15px;padding-right:10px;border: none;">
                                    <div class="col-xs-12 col-md-2" style="padding-bottom:15px;">
                                        <div class="input-group">
                                            <input class="form-control date-picker" name="filter_begin" id="filter_begin"
                                                   type="text" placeholder="<?php echo $this->lang->line("FROM"); ?>"
                                                   data-date-format="yyyy-mm-dd" readonly value="<?php echo date("d-m-Y",strtotime("-1 month")); ?>" />
                                            <span class="input-group-addon">
                                                <i class="fa fa-calendar"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-md-2" style="padding-bottom:15px;">
                                        <div class="input-group">
                                            <input class="form-control date-picker" name="filter_end" id="filter_end" type="text"
                                                placeholder="<?php echo $this->lang->line("TO"); ?>"
                                                data-date-format="yyyy-mm-dd" readonly value="<?php echo date("d-m-Y"); ?>" />
                                            <span class="input-group-addon">
                                                <i class="fa fa-calendar"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div id="myTable_processing" class="dataTables_processing" style="display: none;">Processing...</div>
                                    <table class="table table-striped table-hover table-bordered" id="withdrawl" style="width: 100%;">
                                        <thead>
                                            <tr role="row">
                                                <th>
                                                    <?php echo $this->lang->line("NO"); ?>
                                                </th>
                                                <th>
                                                    <div style="width:80px;"><?php echo $this->lang->line("DATE"); ?></div>
                                                </th>
                                                <th>
                                                    <?php echo $this->lang->line("ACCOUNTS"); ?>
                                                </th>
                                                <th>
                                                    <?php echo $this->lang->line("TRANSACTIONTYPE"); ?>
                                                </th>
                                                <th>
                                                    <?php echo $this->lang->line("PAYMENTHEAD"); ?>
                                                </th>
                                                <th>
                                                    <?php echo $this->lang->line("AMOUNT"); ?>
                                                </th>
                                                <th class="text-align-right">
                                                    <?php echo $this->lang->line("USER"); ?>
                                                </th>
                                                <th>
                                                    <?php echo $this->lang->line("STATUS"); ?>
                                                </th>
                                                <th style="width:130px;">
                                                    <?php echo $this->lang->line("ACTION"); ?>
                                                </th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                                <button data-toggle="modal" data-target=".bs-example-modal-lg" id="btnmodalbox" style="display: none;">ll</button>
                                <div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;" id="modaltransaction">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
                                                <h4 class="modal-title" id="myLargeModalLabel">
                                                    <?php echo $this->lang->line("VIWETRANSACTIONDETAILS"); ?></h4>
                                            </div>
                                            <div class="modal-body">
                                                <div>
                                                    <div id="horizontal-form">
                                                        <div class="form-horizontal">
                                                            <div class="form-group">
                                                                <div class="col-sm-3">
                                                                    <label class="control-label"><strong><?php echo $this->lang->line("ACCOUNTS"); ?></strong></label>
                                                                </div>
                                                                <div class="col-sm-9 no-padding-left">
                                                                    <label class="control-label" id="account-label"></label>
                                                                </div>
                                                            </div>
                                                            <div class="form-group paymentheaddiv">
                                                                <div class="col-sm-3">
                                                                    <label class="control-label"><strong><?php echo $this->lang->line("PAYMENTHEAD"); ?></strong></label>
                                                                </div>
                                                                <div class="col-sm-9 no-padding-left">
                                                                    <label class="control-label" id="paymenthead-label"></label>
                                                                </div>
                                                            </div>
                                                            <div class="form-group purchaseinvoicedetdiv">
                                                                <div class="col-sm-3">
                                                                    <label class="control-label"><strong><?php echo $this->lang->line("PURCHASEINVOICE"); ?></strong></label>
                                                                </div>
                                                                <div class="col-sm-9 no-padding-left">
                                                                    <label class="control-label" id="purchaseinvoice-label"></label>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <div class="col-sm-3">
                                                                    <label class="control-label"><strong><?php echo $this->lang->line("TRANSACTIONTYPE"); ?></strong></label>
                                                                </div>
                                                                <div class="col-sm-9 no-padding-left">
                                                                    <label class="control-label" id="trtype-label"></label>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <div class="col-sm-3">
                                                                    <label class="control-label"><strong><?php echo $this->lang->line("TRANSACTIONDATE"); ?></strong></label>
                                                                </div>
                                                                <div class="col-sm-9 no-padding-left">
                                                                    <label class="control-label" id="trdate-label"></label>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <div class="col-sm-3">
                                                                    <label class="control-label"><strong><?php echo $this->lang->line("AMOUNT"); ?></strong></label>
                                                                </div>
                                                                <div class="col-sm-9 no-padding-left">
                                                                    <label class="control-label" id="amount-label"></label>
                                                                    <input type="hidden" name="hdamount" id="hdamount" />
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <div class="col-sm-3">
                                                                    <label class="control-label"><strong><?php echo $this->lang->line("CREATEDBY"); ?></strong></label>
                                                                </div>
                                                                <div class="col-sm-9 no-padding-left">
                                                                    <label class="control-label" id="createdby-label"></label>
                                                                </div>
                                                            </div>
                                                            <div class="form-group">
                                                                <div class="col-sm-3">
                                                                    <label class="control-label"><strong><?php echo $this->lang->line("STATUS"); ?></strong></label>
                                                                </div>
                                                                <div class="col-sm-9 no-padding-left">
                                                                    <label class="control-label" id="status-label"></label>
                                                                </div>
                                                            </div>



                                                            <div class="form-group">
                                                                <div class="col-sm-3">
                                                                    <label class="control-label"><strong><?php echo $this->lang->line("COMMENTS"); ?></strong></label>
                                                                </div>
                                                                <div class="col-sm-9 no-padding-left">
                                                                    <span class="input-icon icon-right">
                                                                        <span>

                                                                        </span>
                                                                        <textarea class="form-control" name="txtcomments" id="txtcomments" rows="10" style="display:none;"></textarea>
                                                                        <div class="form-control divcomments" style="display:none;height: 150px;"></div>
<!--                                                                        <i class="fa fa-comments-o darkorange"></i>-->
                                                                    </span>
                                                                </div>
                                                            </div>



                                                            <div class="form-group" id="buttongroupdiv">
<input type="hidden" name="transactionID" id="transactionID" value="" />
<input type="hidden" name="hdtrstatus" id="hdtrstatus" value="" />
                                                                <div class="col-sm-10">
                                                                    <button type="button" class="btn btn-success shiny" id="btnsuccess"><?php echo $this->lang->line("APPROVE"); ?></button>
                                                                    <button type="button" class="btn btn-yellow shiny" id="btnhold">
                                                                        <?php echo $this->lang->line("SAVEANDHOLD"); ?></button>
                                                                    <button type="button" class="btn btn-danger shiny" id="btnreject">
                                                                    <?php echo $this->lang->line("REJECT"); ?>
                                                                    </button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div><!-- /.modal-content -->
                                    </div><!-- /.modal-dialog -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Page Content    -->
<script type="text/javascript">
    $(document).ready(function () {
        var table = $('#withdrawl').DataTable({
            "processing": true,
            "serverSide": true,
            "aLengthMenu": [
                    [20, 50, 100],
                    [20, 50, 100]
                ],
            "sPaginationType": "bootstrap",
            "sDom": "Tflt<'row DTTTFooter'<'col-sm-6'i><'col-sm-6'p>>",
            "tableTools": {
                "aButtons": [
                        "copy"
                    ]
            },
            "ajax":{
                "url": "<?php echo base_url('finance/transactions/view_transaction') ?>",
                "dataType": "json",
                "type": "POST",
                "data": function(d){
                    d.filter_begin = $('#filter_begin').val();
                    d.filter_end = $('#filter_end').val();
                    d.search_btn = $('#search_btn').val();
                }
            },
            "oLanguage": {
            "sEmptyTable":     "<?php echo $this->lang->line("NOTHINGFOUND"); ?>",
            "sInfo":           "<?php echo $this->lang->line("SHOWINGPAGE"); ?> _START_ <?php echo $this->lang->line("TO"); ?> _END_ <?php echo $this->lang->line("OF"); ?> _TOTAL_ <?php echo $this->lang->line("ENTRIES"); ?>",
            "sInfoEmpty":      "<?php echo $this->lang->line("SHOWINGPAGE"); ?> 0 <?php echo $this->lang->line("TO"); ?> 0 <?php echo $this->lang->line("OF"); ?> 0 <?php echo $this->lang->line("ENTRIES"); ?>",
            "sInfoPostFix":    "",
            "sInfoThousands":  ",",
            "sLengthMenu":     "<?php echo $this->lang->line("SHOW"); ?> _MENU_ <?php echo $this->lang->line("ENTRIES"); ?>",
            "sLoadingRecords": "<?php echo $this->lang->line("LOADING"); ?>",
            "sProcessing":     "<?php echo $this->lang->line("PROCESSING"); ?>",
            "sSearch":         "",
            "sZeroRecords":    "<?php echo $this->lang->line("NORECORDSAVAILABLE"); ?>",
            "oPaginate": {
                "sFirst":    "<?php echo $this->lang->line("FIRST"); ?>",
                "sLast":     "<?php echo $this->lang->line("LAST"); ?>",
                "sNext":     "<?php echo $this->lang->line("NEXT"); ?>",
                "sPrevious": "<?php echo $this->lang->line("PREVIOUS"); ?>"
            }
        },
            "columnDefs": [
            {
                "targets": 5,
                "className": "text-right"
            }],
            "columns": [
                    { "data": "sl", "bSortable": false},
                    { "data": "TRANSACTION_DATE" , "bSortable": false},
                    { "data": "account", "bSortable": false},
                    { "data": "Transactiontype" , "bSortable": false},
                    { "data": "PAYMENTHEAD" , "bSortable": false},
                    { "data": "AMOUNT" , "bSortable": false},
                    { "data": "created_by", "bSortable": false},
                    { "data": "status", "bSortable": false},
                    { "data": "ID", "bSortable": false}
                ]	 
        });
        
        $('.date-picker').datepicker().change(dateChanged).on('changeDate', dateChanged);
        function dateChanged(ev){
            $(this).datepicker('hide');
            if ($('#filter_begin').val() != '' || $('#filter_end').val() != '') {
                console.log($('#filter_begin').val());
                console.log($('#filter_end').val());
                table.ajax.reload();
            } else {
                table.ajax.reload();
            }
        }
    
    
        //search
        $("<a style='margin-left:5px'  class='search_btn btn btn-info shiny fa fa-search'></a><a style='margin-left:5px' class='remove_btn btn btn-info shiny fa fa-remove'></a><input type='hidden' name='search_btn' id='search_btn'>").appendTo(".dataTables_filter");
        $(".search_btn").click(function () {
            $("#search_btn").val("search");
            table.ajax.reload();
            $("#search_btn").val("");
        });
        $("input[type=search]").on("keypress", function (e) {
            if (e.keyCode === 13) {
                e.preventDefault(); // Ensure it is only this code that rusn
                $(".search_btn").click();
            } else {
                return;
            }
        });
    });
    // Transactions detials view popup open
    function transactionsDetailsView(TransId) {
        $.ajax({
            method: "POST",
            url: "<?php echo base_url('finance/transactions/getTransactionDetails'); ?>",
            data: {transactionID: TransId},
            dataType: "json"
        }).done(function (msg) {
            $.each(msg, function (index, element) {
                $('.paymentheaddiv').hide();
                $('.purchaseinvoicedetdiv').hide();
                $('#txtcomments').hide();
                $('.divcomments').hide();
                $('#buttongroupdiv').hide();
                $('#account-label').html(element.account);
                $('#trtype-label').html(element.Transactiontype);
                $('#trdate-label').html(element.created);
                $('#amount-label').html(element.AMOUNTHASH);
                $('#hdamount').val(element.AMOUNT);
                $('#createdby-label').html(element.created_by);
                $('#hdtrstatus').val(element.STATUS);
                //  Transaction Status
                //  0 created
                //  1	Approved
                //  2	Rejected
                //  3	On Hold
                //  4	Updated
                //  5	settle crated
                //  6	settle updated
                //  7	settlement on hold
                //  8	settlement rejected
                if (element.TRANSACTION_TYPE_ID == 0) {
                    $('.paymentheaddiv').hide();
                    $('.purchaseinvoicedetdiv').hide();
                } else {
                    if (element.PAYMENTHEAD_ID == 'PURCHASE' || element.PAYMENTHEAD_ID == 'PURCHASERETURN') {
                        $('.paymentheaddiv').hide();
                        $('.purchaseinvoicedetdiv').show();
                        $('#purchaseinvoice-label').html('<a href="<?php echo base_url('inventory/purchaseinvoice/create'); ?>/' + element.PURCHASEINVOICE_ID + '"><?php echo $this->lang->line("CLICKTOVIEW"); ?></a>');
                    } else {
                        $('.paymentheaddiv').show();
                        $('#paymenthead-label').html(element.PAYMENTHEAD);
                        $('.purchaseinvoicedetdiv').hide();
                    }
                }
                if (element.STATUS == 0 || element.STATUS == 5) {
                    var statustext = '<span class="label label-primary shiny"><?php echo $this->lang->line("CREATED"); ?></span>';
                    $('#txtcomments').show();
                    $('#buttongroupdiv').show();
                } else if (element.STATUS == 1) {
                    var statustext = '<div class="buttons-preview"><span class="label label-success shiny"><?php echo $this->lang->line("APPROVED"); ?></a></div>';
                    $('.divcomments').show();
                    $('#buttongroupdiv').hide();
                } else if (element.STATUS == 2 || element.STATUS==8) {
                    var statustext = '<div class="buttons-preview"><span class="label label-danger shiny"><?php echo $this->lang->line("REJECTED"); ?></a></div>';
                    $('#txtcomments').show();
                    $('#buttongroupdiv').show();
                } else if (element.STATUS == 3 || element.STATUS==7) {
                    var statustext = '<div class="buttons-preview"><span class="label label-warning shiny"><?php echo $this->lang->line("ONHOLD"); ?></a></div>';
                    $('#txtcomments').show();
                    $('#buttongroupdiv').show();
                } else if (element.STATUS == 4 || element.STATUS==6) {
                    var statustext = '<div class="buttons-preview"><span class="label label-info shiny"><?php echo $this->lang->line("UPDATED"); ?></a></div>';
                    $('#txtcomments').show();
                    $('#buttongroupdiv').show(); 
                } else {
                    var statustext = '<span class="label label-primary shiny"><?php echo $this->lang->line("CREATED"); ?></span>';
                    $('#txtcomments').show();
                    $('#buttongroupdiv').show();
                }
                $('#status-label').html(statustext);
                $('#txtcomments').val(element.COMMENTS);
                $('.divcomments').html(element.COMMENTS);
                $('#transactionID').val(element.ID);
            });
            $("#btnmodalbox").click();
        });
    }

    $(document).ready(function () {
        // Approved Button Click
        $("#btnsuccess").click(function () {
            $(this).prop('disabled', true);
            var txtcomments;
            var transactionID;
            var amount;
            txtcomments = $("#txtcomments").val();
            amount = $("#hdamount").val();
            transactionID = $("#transactionID").val();
            $.ajax({
                method: "POST",
                url: "<?php echo base_url('finance/transactions/updateTransactionDetails'); ?>",
                data: {
                    transactionID: transactionID,
                    txtcomments: txtcomments,
                    amount: amount,
                    STATUS: 1
                },
                dataType: "json"
            }).done(function (msg) {
                if (msg.msgstatus == 'success') {
                    Notify('<?php echo $this->lang->line("TRANSACTIONAPPROVED"); ?>', 'top-right', '700', 'success', 'fa-check', true);
                    $('#btnsuccess').prop("disabled", false);
                    $('#status_'+msg.trid).html('<span class="label label-success shiny"><?php echo $this->lang->line("APPROVED"); ?></span>');
                    $('#modaltransaction').modal('toggle');
                } else {
                    Notify('<?php echo $this->lang->line("ERROSOMETHINGWENTWRONG"); ?>', 'top-right', '2000', 'danger', 'fa-check', true);
                }
            });
        });
        // Hold & Save Button Click
        $("#btnhold").click(function () {
            var txtcomments;
            var transactionID;
            var amount;
            txtcomments = $("#txtcomments").val();
            amount = $("#hdamount").val();
            transactionID = $("#transactionID").val();
//            Transaction Status
//            0 created
//            1	Approved
//            2	Rejected
//            3	On Hold
//            4	Updated
//            5	settle crated
//            6	settle updated
//            7	settlement on hold
//            8	settlement rejected
            var trstatus    =   $('#hdtrstatus').val();
            var updatestatus;
            if(trstatus==0 || trstatus==2 || trstatus==3 || trstatus==4)
                updatestatus    =   3;
            else if(trstatus==5 || trstatus==6 || trstatus==7 || trstatus==8)
                updatestatus    =   7;
            $.ajax({
                method: "POST",
                url: "<?php echo base_url('finance/transactions/updateTransactionDetails'); ?>",
                data: {
                    transactionID: transactionID,
                    txtcomments: txtcomments,
                    amount: amount,
                    STATUS: updatestatus
                },
                dataType: "json"
            }).done(function (msg) {
                if (msg.msgstatus == 'success') {
                    Notify('<?php echo $this->lang->line("TRANSACTIONISONHOLD"); ?>', 'top-right', '700', 'warning', 'fa-check', true);
                    $('#btnsuccess').prop("disabled", false);
                    $('#status_'+msg.trid).html('<span class="label label-warning shiny"><?php echo $this->lang->line("ONHOLD"); ?></span>');
                    $('#modaltransaction').modal('toggle');
//                    setTimeout(function () {
//                        window.location.href = "<?php echo base_url('finance/transactions'); ?>";
//                    }, 700);
                } else {
                    Notify('<?php echo $this->lang->line("ERROSOMETHINGWENTWRONG"); ?>', 'top-right', '2000', 'danger', 'fa-warning', true);
                }
            });
        });
        // Reject Button Click
        $("#btnreject").click(function () {
            var txtcomments;
            var transactionID;
            var amount;
            txtcomments = $("#txtcomments").val();
            amount = $("#hdamount").val();
            transactionID = $("#transactionID").val();
//            Transaction Status
//            0 created
//            1	Approved
//            2	Rejected
//            3	On Hold
//            4	Updated
//            5	settle crated
//            6	settle updated
//            7	settlement on hold
//            8	settlement rejected
            var trstatus    =   $('#hdtrstatus').val();
            var updatestatus;
            if(trstatus==0 || trstatus==2 || trstatus==3 || trstatus==4)
                updatestatus    =   2;
            else if(trstatus==5 || trstatus==6 || trstatus==7 || trstatus==8)
                updatestatus    =   8;
            $.ajax({
                method: "POST",
                url: "<?php echo base_url('finance/transactions/updateTransactionDetails'); ?>",
                data: {
                    transactionID: transactionID,
                    txtcomments: txtcomments,
                    amount: amount,
                    STATUS: updatestatus
                },
                dataType: "json"
            }).done(function (msg) {
                if (msg.msgstatus == 'success') {
                    Notify('<?php echo $this->lang->line("TRANSACTIONREJECTED"); ?>', 'top-right', '700', 'danger', 'fa-bolt', true);
                    $('#btnsuccess').prop("disabled", false);
                    $('#status_'+msg.trid).html('<span class="label label-danger shiny"><?php echo $this->lang->line("REJECTED"); ?></span>');
                    $('#modaltransaction').modal('toggle');
//                    setTimeout(function () {
//                        window.location.href = "<?php echo base_url('finance/transactions'); ?>";
//                    }, 700);
                } else {
                    Notify('<?php echo $this->lang->line("ERROSOMETHINGWENTWRONG"); ?>', 'top-right', '2000', 'danger', 'fa-check', true);
                }
            });
        });
    });
    
    $(document).ajaxStop(function () {
        $('.dataTables_processing').hide();
    });

    $(document).ajaxStart(function () {
        $('.dataTables_processing').show();
    }); 
</script>
