
<div class="page-content">
    <!-- Page Breadcrumb -->
    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#">Setting</a>
            </li>
            <li class="active">Transfer Details</li>
        </ul>
    </div>
    <!-- /Page Breadcrumb -->

    <!-- Page Header -->
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                Transfer Details
            </h1>
        </div>
        <!--Header Buttons-->
        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>
        <!--Header Buttons End-->
    </div>
    <!-- /Page Header -->
    <!-- Page Body -->
    <!-- End Page Body -->
    <div class="page-body">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="row">
                    <div class="col-xs-12 col-md-12">
                        <div class="widget">
                            <div class="widget-body">
                                <div class="table-toolbar">
                                    <a id="add_tran" href="<?php echo site_url('finance/transfer/add_tran')?>" class="btn btn-success"><span class="fa fa-plus"></span></a>
                                </div>
                                <form id="form_trans" method="post" action="<?php echo site_url('delete_trans')?>">
                                    
                                <table class="table table-striped table-hover table-bordered" id="tran">
                                    <thead>
                                        <tr role="row">
                                            <th>
                                                No
                                            </th>
                                            <th>
                                                From Account
                                            </th>
                                            <th>
                                                To Account
                                            </th>
                                            <th>
                                                Transferred Amount
                                            </th>
                                            <th>
                                                Transferred By
                                            </th>
                                            <th>
                                                Transferred On
                                            </th>
                                        </tr>
                                    </thead>                                  
                                </table>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Page Content -->

<script>

    $(document).ready(function(){
        var table=$('#tran').DataTable({
            "processing": true,
            "serverSide": true,
//            "aLengthMenu": [
//                    [5, 15, 20, 100, -1],
//                    [5, 15, 20, 100, "All"]
//            ],
            "sPaginationType": "bootstrap",
            "sDom": "Tflt<'row DTTTFooter'<'col-sm-6'i><'col-sm-6'p>>",
            "tableTools": {
                "aButtons": [
                        "copy"
                ]
            },
            "ajax":{
                "url": "<?php echo base_url('finance/transfer/view_trans') ;?>",
                "dataType": "json",
                "type": "POST",
                "data": function(d){
                    d.filter_status = $('#filter_status').val();
                    d.search_btn = $('#search_btn').val();
                }
            },
            "oLanguage": {
                "sLengthMenu": "\_MENU_",
                "sSearch": "" 
            },

            "columns": [
                    { "data": "id",
                        "render":function(data, type, row, meta){
                            return meta.row+meta.settings._iDisplayStart+1;
                        }
                    },
//                    { "data": "checkbox",
//                      "bSortable": false,
//                      "render": function ( data, type, row){
//                          return '<label><input type="checkbox" name="id[]" value="'+row.id+'"><span class="text"></span></label>';
//                      }
//                    },
                    { "data": "title",
                      "render": function ( data, type, row){
                          return '<a href="'+"<?php echo site_url('trans')?>"+"/"+row.id+'">'+data+'</a>';
                      }
                    },
                    {
                        "data": "budget"
                    },
                    {
                        "data": "cost"
                    }
                ]	 

            });


            // Check All Functionality
            $('#tran thead th input[type=checkbox]').change(function() {
                var set = $("#tran tbody tr input[type=checkbox]");
                var checked = $(this).is(":checked");
                $(set).each(function() {
                    if (checked) {
                        $(this).prop("checked", true);
                        $(this).parents('tr').addClass("active");
                    } else {
                        $(this).prop("checked", false);
                        $(this).parents('tr').removeClass("active");
                    }
                });

            });
            $('#tran tbody tr input[type=checkbox]').change(function() {
                $(this).parents('tr').toggleClass("active");
            });

            //search
            $("<a style='margin-left:5px'  class='search_btn btn btn-info fa fa-search'></a><a style='margin-left:5px'  class='remove_btn btn btn-info fa fa-remove'></a><input type='hidden' name='search_btn' id='search_btn'>").appendTo(".dataTables_filter");
        
            $(".search_btn").click(function(){
                $("#search_btn").val("search");
                table.ajax.reload();
                $("#search_btn").val("");
            });

            $(".remove_btn").click(function(){
                location.reload();

            });

            $("input[type=search]").on("keypress", function(e){

                if(e.keyCode === 13){

                    e.preventDefault(); // Ensure it is only this code that rusn

                    $(".search_btn").click();
                }else{
                    return;
                }

            });

            $('#tran').wrap($('<div style="overflow-x:scroll; width:100%"/>'));

            $(".search_btn").click(function(){
                $("#search_btn").val("search");
                table.ajax.reload();
                $("#search_btn").val("");
            });

        });



    function deleteAccount(){
        var checked_input = false;

        var set = $("#tran tbody tr input[type=checkbox]");
        $(set).each(function() {
            if (this.checked) {
                checked_input = true;
            } 
        });
        if (!checked_input){
            return;
        }
        
        if (confirm("Delete the selected trans?")){
            document.getElementById('form_trans').submit();
        }
    }


    
</script>   