<?php if($this->session->lang == "ar" && $this->session->langfolder == "arabic"){ ?>
<style>
    #statement_length {
        float: left !important;
    }
    .dataTables_filter {
        float: right !important;
    }
</style>
<?php } ?>
<div class="page-content">
    <!-- Page Breadcrumb -->
    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#"><?php echo $this->lang->line("ACCOUNTSTATEMENT"); ?></a>
            </li>
            <li class="active"><?php echo $this->lang->line("ACCOUNTSTATEMENT"); ?></li>
        </ul>
    </div>
    <!-- /Page Breadcrumb -->

    <!-- Page Header -->
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                <?php echo $this->lang->line("ACCOUNTSTATEMENT"); ?>
            </h1>
        </div>
        <!--Header Buttons-->
        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>
        <!--Header Buttons End-->
    </div>
    <!-- /Page Header -->
    <!-- Page Body -->
    <!-- End Page Body -->
    <div class="page-body">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="row">
                    <div class="col-xs-12 col-md-12">
                        <div class="widget">
                            <div class="widget-body">
                                <div class="table-toolbar">
                                    <a id="back_accounts" href="<?php echo site_url('finance/accounts')?>" class="btn btn-blue shiny">
                                        <span class="fa fa-arrow-left"></span>
                                        <?php echo $this->lang->line("BACKTOACCOUNTS"); ?>
                                    </a>
                                    <a id="downloadstatement" class="btn btn-danger shiny">
                                        <span class="fa fa-file-pdf-o"></span>
                                        <?php echo $this->lang->line("PDF"); ?>
                                    </a>
                                    <a id="downloadstatementexcel" class="btn btn-success shiny">
                                        <span class="fa fa-file-excel-o"></span>
                                        <?php echo $this->lang->line("EXCEL"); ?>
                                    </a>
                                </div>
                                <form id="form_accounts" method="post" action="<?php echo site_url('delete_accounts')?>">
                                <table border="0" cellspacing="15" cellpadding="5" id="filter_inputs">
                                    <tbody>
                                        <tr>
                                            <td><div class="input-group">
                                                    <input class="form-control date-picker" name="filter_begin" id="filter_begin" 
                                                           type="text" placeholder="<?php echo $this->lang->line("FROM"); ?>"
                                                           data-date-format="dd-mm-yyyy" readonly value="<?php echo date("d-m-Y",strtotime("-1 month")); ?>" />
                                                <span class="input-group-addon">
                                                    <i class="fa fa-calendar"></i>
                                                </span>
                                            </div></td>
                                            <td>
                                                <div class="input-group">
                                                    <input class="form-control date-picker" name="filter_end" id="filter_end" type="text"
                                                           placeholder="<?php echo $this->lang->line("TO"); ?>"
                                                           data-date-format="dd-mm-yyyy" readonly value="<?php echo date("d-m-Y"); ?>" />
                                                    <span class="input-group-addon">
                                                        <i class="fa fa-calendar"></i>
                                                    </span>
                                                </div>
                                                </td>
                                            <td>
                                                <div class="input-group">
                                                    <select id="transaction_account" name="account" style="width:100%" required>
                                                        <option value=''><?php echo $this->lang->line("SELECTACCOUNT"); ?></option>
                                                        <?php
                                                            foreach ($accounts as $key => $value) {
                                                                echo "<option value=\"".$value->ID."\" />".$value->ACCOUNT_NAME;    
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <select id="transaction_type" name="type" style="width:100%" required>
                                                        <option value><?php echo $this->lang->line("TRANSACTIONFOR"); ?></option>
                                                        <option value="Income"><?php echo $this->lang->line("INCOME"); ?></option>
                                                        <option value="Expense"><?php echo $this->lang->line("EXPENCE"); ?></option>
                                                    </select>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <div id="myTable_processing" class="dataTables_processing" style="display: none;">Processing...</div>
                                <table class="table table-striped table-hover table-bordered " id="statement">
                                    <thead>
                                        <tr role="row">
                                            <th>
                                                <?php echo $this->lang->line("DATE"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("ACCOUNTS"); ?>
                                            </th> 
                                            <th>
                                                <?php echo $this->lang->line("INCOME"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("EXPENCE"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("BALANCE"); ?>
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
                                </form>
                            </div>
                            <button data-toggle="modal" data-target=".bs-example-modal-lg" id="btnmodalbox" style="display: none;">ll</button>
                            <div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">Ã—</button>
                                            <h4 class="modal-title" id="myLargeModalLabel">
                                                <?php echo $this->lang->line("VIWETRANSACTIONDETAILS"); ?></h4>
                                        </div>
                                        <div class="modal-body">
                                            <div>
                                                <div id="horizontal-form">
                                                    <div class="form-horizontal">
                                                        <div class="form-group">
                                                            <div class="col-sm-3">
                                                                <label class="control-label"><strong><?php echo $this->lang->line("VIWETRANSACTIONDETAILS"); ?></strong></label>
                                                            </div>
                                                            <div class="col-sm-9 no-padding-left">
                                                                <label class="control-label" id="account-label">
                                                                    <?php echo $this->lang->line("ACCOUNTS"); ?></label>
                                                            </div>
                                                        </div>
                                                        <div class="form-group paymentheaddiv">
                                                            <div class="col-sm-3">
                                                                <label class="control-label"><strong><?php echo $this->lang->line("PAYMENTHEAD"); ?></strong></label>
                                                            </div>
                                                            <div class="col-sm-9 no-padding-left">
                                                                <label class="control-label" id="paymenthead-label"></label>
                                                            </div>
                                                        </div>
                                                        <div class="form-group purchaseinvoicedetdiv">
                                                            <div class="col-sm-3">
                                                                <label class="control-label"><strong><?php echo $this->lang->line("PURCHASEINVOICE"); ?></strong></label>
                                                            </div>
                                                            <div class="col-sm-9 no-padding-left">
                                                                <label class="control-label" id="purchaseinvoice-label"></label>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <div class="col-sm-3">
                                                                <label class="control-label"><strong><?php echo $this->lang->line("TRANSACTIONTYPE"); ?></strong></label>
                                                            </div>
                                                            <div class="col-sm-9 no-padding-left">
                                                                <label class="control-label" id="trtype-label"></label>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <div class="col-sm-3">
                                                                <label class="control-label"><strong><?php echo $this->lang->line("TRANSACTIONDATE"); ?></strong></label>
                                                            </div>
                                                            <div class="col-sm-9 no-padding-left">
                                                                <label class="control-label" id="trdate-label"></label>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <div class="col-sm-3">
                                                                <label class="control-label"><strong><?php echo $this->lang->line("AMOUNT"); ?></strong></label>
                                                            </div>
                                                            <div class="col-sm-9 no-padding-left">
                                                                <label class="control-label" id="amount-label"></label>
                                                                <input type="hidden" name="hdamount" id="hdamount" />
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <div class="col-sm-3">
                                                                <label class="control-label"><strong><?php echo $this->lang->line("CREATEDBY"); ?></strong></label>
                                                            </div>
                                                            <div class="col-sm-9 no-padding-left">
                                                                <label class="control-label" id="createdby-label"></label>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <div class="col-sm-3">
                                                                <label class="control-label"><strong><?php echo $this->lang->line("STATUS"); ?></strong></label>
                                                            </div>
                                                            <div class="col-sm-9 no-padding-left">
                                                                <label class="control-label" id="status-label"></label>
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <div class="col-sm-3">
                                                                <label class="control-label"><strong><?php echo $this->lang->line("COMMENTS"); ?></strong></label>
                                                            </div>
                                                            <div class="col-sm-9 no-padding-left">
                                                                <span class="input-icon icon-right">
                                                                    <span>

                                                                    </span>
                                                                    <textarea class="form-control" name="txtcomments" id="txtcomments" rows="10" style="display:none;"></textarea>
                                                                    <div class="form-control divcomments" style="display:none;height: 150px;"></div>
<!--                                                                        <i class="fa fa-comments-o darkorange"></i>-->
                                                                </span>
                                                            </div>
                                                        </div>
                                                        <div class="form-group" id="buttongroupdiv">
                                                            <input type="hidden" name="transactionID" id="transactionID" value="" />
                                                            <div class="col-sm-10">
                                                                <button type="button" class="btn btn-success" id="btnsuccess"><?php echo $this->lang->line("APPROVE"); ?></button>
                                                                <button type="button" class="btn btn-yellow" id="btnhold"><?php echo $this->lang->line("SAVEANDHOLD"); ?></button>
                                                                <button type="button" class="btn btn-danger" id="btnreject"><?php echo $this->lang->line("REJECT"); ?></button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- /.modal-content -->
                                </div><!-- /.modal-dialog -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Page Content    -->
<script type="text/javascript">
    $(document).ready(function () {
        var table = $('#statement').DataTable({
            "processing": true,
            "serverSide": true,
            "aLengthMenu": [
                    [20, 50, 100],
                    [20, 50, 100]
                ],
            "sPaginationType": "bootstrap",
            "sDom": "Tflt<'row DTTTFooter'<'col-sm-6'i><'col-sm-6'p>>",
            "tableTools": {
                "aButtons": [
                        "copy"
                    ]
            },
            "ajax":{
                "url": "<?php echo base_url('finance/statement/view_statement') ?>",
                "dataType": "json",
                "type": "POST",
                "data": function(d){
                    d.filter_begin = $('#filter_begin').val();
                    d.filter_end = $('#filter_end').val();
                    d.account = $('#transaction_account').val();
                    d.type = $('#transaction_type').val();
                    d.search_btn = $('#search_btn').val();
                }
            },
            "oLanguage": {
                "sEmptyTable":     "<?php echo $this->lang->line("NOTHINGFOUND"); ?>",
                "sInfo":           "<?php echo $this->lang->line("SHOWINGPAGE"); ?> _START_ <?php echo $this->lang->line("TO"); ?> _END_ <?php echo $this->lang->line("OF"); ?> _TOTAL_ <?php echo $this->lang->line("ENTRIES"); ?>",
                "sInfoEmpty":      "<?php echo $this->lang->line("SHOWINGPAGE"); ?> 0 <?php echo $this->lang->line("TO"); ?> 0 <?php echo $this->lang->line("OF"); ?> 0 <?php echo $this->lang->line("ENTRIES"); ?>",
                "sInfoPostFix":    "",
                "sInfoThousands":  ",",
                "sLengthMenu":     "<?php echo $this->lang->line("SHOW"); ?> _MENU_ <?php echo $this->lang->line("ENTRIES"); ?>",
                "sLoadingRecords": "<?php echo $this->lang->line("LOADING"); ?>",
                "sProcessing":     "<?php echo $this->lang->line("PROCESSING"); ?>",
                "sSearch":         "",
                "sZeroRecords":    "<?php echo $this->lang->line("NORECORDSAVAILABLE"); ?>",
                "oPaginate": {
                    "sFirst":    "<?php echo $this->lang->line("FIRST"); ?>",
                    "sLast":     "<?php echo $this->lang->line("LAST"); ?>",
                    "sNext":     "<?php echo $this->lang->line("NEXT"); ?>",
                    "sPrevious": "<?php echo $this->lang->line("PREVIOUS"); ?>"
                }
            },
            "columns": [
                    { "data": "date", "bSortable": false},
                    { "data": "transaction", "bSortable": false},
//                    { "data": "mode" ,
//                      "bSortable": false},
//                    { "data": "tranid" ,
//                      "bSortable": false},
                    { "data": "credit" , "bSortable": false},
                    { "data": "debit" , "bSortable": false},
                    { "data": "balance", "bSortable": false}
                ]	 
            });
            $('.date-picker').datepicker().change(dateChanged).on('changeDate', dateChanged);
        //search
            $("<a style='margin-left:5px'  class='search_btn btn btn-info fa fa-search'></a><a style='margin-left:5px'  class='remove_btn btn btn-info fa fa-remove'></a><input type='hidden' name='search_btn' id='search_btn'>").appendTo(".dataTables_filter");
            $(".search_btn").click(function(){
                $("#search_btn").val("search");
                table.ajax.reload();
                $("#search_btn").val("");
            });
            $(".remove_btn").click(function(){
                location.reload();

            });
            $("input[type=search]").on("keypress", function(e){
                if(e.keyCode === 13){
                    e.preventDefault(); // Ensure it is only this code that rusn
                    $(".search_btn").click();
                }else{
                    return;
                }
            });
        $('#statement').wrap($('<div style="overflow-x:scroll; width:100%"/>'));
        function dateChanged(ev){
            $(this).datepicker('hide');
            if ($('#filter_begin').val() != '' || $('#filter_end').val() != '') {
                console.log($('#filter_begin').val());
                console.log($('#filter_end').val());
                table.ajax.reload();
            } else {
                table.ajax.reload();
            }
        }

        $('#transaction_account').change(function(){
            console.log("account");
            table.ajax.reload();
        });
        $('#transaction_type').change( function(){
            console.log("account");
            table.ajax.reload();
        });
        
        $("#downloadstatement").click(function(){
            var searchtxt  =   $("#statement_filter :input").val();
            searchtxt=searchtxt.replace('/','');
            if(searchtxt=='')
                searchtxt   =   '-';
            var fromdt  =   $("#filter_begin").val();
            if(fromdt=='')
                fromdt   =   '-';
            var todate  =   $("#filter_end").val();
            if(todate=='')
                todate   =   '-';
            var account  =   $("#transaction_account").val();
            if(account=='')
                account   =   '-';
            var transtype  =   $("#transaction_type").val();
            if(transtype=='')
                transtype   =   '-';
            window.location.href = base_url+'finance/statement/exportPDFData/'+searchtxt+'/'+fromdt+'/'+todate+'/'+account+'/'+transtype+'/PDF';
        });
        $("#downloadstatementexcel").click(function(){
            var searchtxt  =   $("#statement_filter :input").val();
            searchtxt=searchtxt.replace('/','');
            if(searchtxt=='')
                searchtxt   =   '-';
            var fromdt  =   $("#filter_begin").val();
            if(fromdt=='')
                fromdt   =   '-';
            var todate  =   $("#filter_end").val();
            if(todate=='')
                todate   =   '-';
            var account  =   $("#transaction_account").val();
            if(account=='')
                account   =   '-';
            var transtype  =   $("#transaction_type").val();
            if(transtype=='')
                transtype   =   '-';
            window.location.href = base_url+'finance/statement/exportPDFData/'+searchtxt+'/'+fromdt+'/'+todate+'/'+account+'/'+transtype+'/EXCEL';
        });
    });
    // Transactions detials view popup open
    function transactionsDetailsView(TransId) {
        $.ajax({
            method: "POST",
            url: "<?php echo base_url('finance/transactions/getTransactionDetails'); ?>",
            data: {transactionID: TransId},
            dataType: "json"
        }).done(function (msg) {
            $.each(msg, function (index, element) {
                $('.paymentheaddiv').hide();
                $('.purchaseinvoicedetdiv').hide();
                $('#txtcomments').hide();
                $('.divcomments').hide();
                $('#buttongroupdiv').hide();
                $('#account-label').html(element.account);
                $('#trtype-label').html(element.Transactiontype);
                $('#trdate-label').html(element.created);
                $('#amount-label').html(element.AMOUNTHASH);
                $('#hdamount').val(element.AMOUNT);
                $('#createdby-label').html(element.created_by);
                if (element.TRANSACTION_TYPE_ID == 0) {
                    $('.paymentheaddiv').hide();
                    $('.purchaseinvoicedetdiv').hide();
                } else {
                    if (element.PAYMENTHEAD == 'PURCHASE') {
                        $('.paymentheaddiv').hide();
                        $('.purchaseinvoicedetdiv').show();
                        $('#purchaseinvoice-label').html('<a href="<?php echo base_url('inventory/purchaseinvoice/create'); ?>/' + element.PURCHASEINVOICE_ID + '">Click to view</a>');
                    } else {
                        $('.paymentheaddiv').show();
                        $('#paymenthead-label').html(element.PAYMENTHEAD);
                        $('.purchaseinvoicedetdiv').hide();
                    }
                }
                if (element.STATUS == 0) {
                    var statustext = '<span class="label label-primary shiny"><?php echo $this->lang->line("CREATED"); ?></span>';
                    $('#txtcomments').show();
                    $('#buttongroupdiv').show();
                } else if (element.STATUS == 1) {
                    var statustext = '<div class="buttons-preview"><span class="label label-success shiny"><?php echo $this->lang->line("APPROVED"); ?></a></div>';
                    $('.divcomments').show();
                    $('#buttongroupdiv').hide();
                } else if (element.STATUS == 2) {
                    var statustext = '<div class="buttons-preview"><span class="label label-danger shiny"><?php echo $this->lang->line("REJECTED"); ?></a></div>';
                    $('#txtcomments').show();
                    $('#buttongroupdiv').show();
                } else if (element.STATUS == 3) {
                    var statustext = '<div class="buttons-preview"><span class="label label-warning shiny"><?php echo $this->lang->line("ONHOLD"); ?></a></div>';
                    $('#txtcomments').show();
                    $('#buttongroupdiv').show();
                } else if (element.STATUS == 4) {
                    var statustext = '<div class="buttons-preview"><span class="label label-info shiny"><?php echo $this->lang->line("UPDATED"); ?></a></div>';
                    $('#txtcomments').show();
                    $('#buttongroupdiv').show(); 
                } else {
                    var statustext = '<span class="label label-primary shiny"><?php echo $this->lang->line("CREATED"); ?></span>';
                    $('#txtcomments').show();
                    $('#buttongroupdiv').show();
                }
                $('#status-label').html(statustext);
                $('#txtcomments').val(element.COMMENTS);
                $('.divcomments').html(element.COMMENTS);
                $('#transactionID').val(element.ID);
            });
            $("#btnmodalbox").click();
        });
    }
    $(document).ajaxStop(function () {
        $('.dataTables_processing').hide();
    });
    $(document).ajaxStart(function () {
        $('.dataTables_processing').show();
    });
</script>