<style type=text/css>
    #withdrawl_length{
        display: none;
    }
    .remove_btn{
        display: none;
    }
</style>
<div class="page-content">
    <!-- Page Breadcrumb -->
    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#"><?php echo $this->lang->line("FINANCE"); ?></a>
            </li>
            <li class="active"><?php echo $this->lang->line("PAYMENTS"); ?></li>
        </ul>
    </div>
    <!-- /Page Breadcrumb -->

    <!-- Page Header -->
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                <?php echo $this->lang->line("PAYMENTS"); ?>
            </h1>
        </div>
        <!--Header Buttons-->
        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>
        <!--Header Buttons End-->
    </div>
    <!-- /Page Header -->
    <!-- Page Body -->
    <!-- End Page Body -->
    <div class="page-body">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px;">
                <div class="row">
                    <div class="col-xs-12 col-md-12" style="padding: 0px;">
                        <div class="widget">
                            <?php
                            if ($this->session->flashdata('success_msg')) {
                            ?>
                            <div class="alert alert-success">
                            <a href="#" class="close" data-dismiss="alert">&times;</a>
                            <?php echo $this->session->flashdata('success_msg');$this->session->unset_userdata('success_msg'); ?>
                            </div>
                            <?php
                            }
                            ?>
                            <div class="widget-body">
                                <div class="table-toolbar col-xs-12 col-md-1" style="padding-top: 0px;">
                                    <a id="add_withdrawl" href="<?php echo site_url('finance/payments/add_payment')?>"
                                       class="btn btn-success shiny"><span class="fa fa-plus"></span></a>
                                </div>
                                <div class="col-xs-12 col-md-2" style="padding-bottom:15px;">
                                        <div class="input-group">
                                            <input class="form-control date-picker" name="filter_begin" id="filter_begin"
                                                   type="text" placeholder="<?php echo $this->lang->line("FROM"); ?>"
                                                   data-date-format="yyyy-mm-dd" readonly value="<?php echo date("d-m-Y",strtotime("-1 month")); ?>" />
                                            <span class="input-group-addon">
                                                <i class="fa fa-calendar"></i>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-md-2" style="padding-bottom:15px;">
                                        <div class="input-group">
                                            <input class="form-control date-picker" name="filter_end" id="filter_end" type="text"
                                                placeholder="<?php echo $this->lang->line("TO"); ?>"
                                                data-date-format="yyyy-mm-dd" readonly value="<?php echo date("d-m-Y"); ?>" />
                                            <span class="input-group-addon">
                                                <i class="fa fa-calendar"></i>
                                            </span>
                                        </div>
                                    </div>
                                <div id="tablecontent" class="table-scrollable" style="border: none;"> 
                                    <table class="table table-striped table-hover table-bordered" id="withdrawl" style="width: 100%;">
                                    <thead>
                                        <tr role="row">
                                            <th>
                                                <?php echo $this->lang->line("NO"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("DATE"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("ACCOUNTSFROM"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("PAYMENTSTO"); ?>
                                            </th>
                                            <th class="text-align-right">
                                                <?php echo $this->lang->line("AMOUNT"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("PAYMENTBY"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("STATUS"); ?>
                                            </th>
                                            <th style="width:130px;">
                                                <?php echo $this->lang->line("ACTION"); ?>
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<button type="button" id="deletebutton" data-toggle="modal" data-target="#confirmmodal" style="display: none;">dd</button>
<div id="confirmmodal" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line("PAYMENTS"); ?></h4>
            </div>
            <div class="modal-body">
                <p><?php echo $this->lang->line("AREYOUSURETODELETE"); ?></p>
            </div>
            <div class="modal-footer">
                <input type="hidden" id="okid" value="">
                <button type="button" class="btn btn-success" onclick="return deleteFunction()"><?php echo $this->lang->line("YES"); ?></button>
                <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo $this->lang->line("NO"); ?></button>
            </div>
        </div>
    </div>
</div>

<!-- End Page Content    -->
<script>
    $(document).ready(function () {
        loaddata();
        $('#filter_begin').datepicker().on('changeDate', function (ev) { 
            loaddata();
        });
        $('#filter_end').datepicker().on('changeDate', function (ev) { 
            loaddata();
        });
    });
    function loaddata() {
        var filter_begin = $("#filter_begin").val();
        var filter_end = $("#filter_end").val();
        $('#withdrawl').DataTable().destroy();
        var table = $('#withdrawl').DataTable( {
            "bProcessing": true,
            "bServerSide": true,
            "sAjaxSource": "<?php echo base_url('finance/payments/view_payments') ?>?filter_begin="+filter_begin+"&filter_end="+filter_end,
            "lengthMenu": [[20, 50, 100], [20, 50, 100]],
            "oLanguage": {
                "sEmptyTable":     "<?php echo $this->lang->line("NOTHINGFOUND"); ?>",
                "sInfo":           "<?php echo $this->lang->line("SHOWINGPAGE"); ?> _START_ <?php echo $this->lang->line("TO"); ?> _END_ <?php echo $this->lang->line("OF"); ?> _TOTAL_ <?php echo $this->lang->line("ENTRIES"); ?>",
                "sInfoEmpty":      "<?php echo $this->lang->line("SHOWINGPAGE"); ?> 0 <?php echo $this->lang->line("TO"); ?> 0 <?php echo $this->lang->line("OF"); ?> 0 <?php echo $this->lang->line("ENTRIES"); ?>",
                "sInfoPostFix":    "",
                "sInfoThousands":  ",",
                "sLengthMenu":     "<?php echo $this->lang->line("SHOW"); ?> _MENU_ <?php echo $this->lang->line("ENTRIES"); ?>",
                "sLoadingRecords": "<?php echo $this->lang->line("LOADING"); ?>",
                "sProcessing":     "<?php echo $this->lang->line("PROCESSING"); ?>",
                "sSearch":         "",
                "sZeroRecords":    "<?php echo $this->lang->line("NORECORDSAVAILABLE"); ?>",
                "oPaginate": {
                    "sFirst":    "<?php echo $this->lang->line("FIRST"); ?>",
                    "sLast":     "<?php echo $this->lang->line("LAST"); ?>",
                    "sNext":     "<?php echo $this->lang->line("NEXT"); ?>",
                    "sPrevious": "<?php echo $this->lang->line("PREVIOUS"); ?>"
                }
            },
                "columnDefs": [
            {
                "targets": 4,
                "className": "text-right"
            },
                {"targets": [ 6 ],"sortable" : true  ,"render": function ( data, type, row ) {
                //  Transaction Status
                //  0 created
                //  1	Approved
                //  2	Rejected
                //  3	On Hold
                //  4	Updated
                //  5	settle crated
                //  6	settle updated
                //  7	settlement on hold
                //  8	settlement rejected
                if(data==0 || data==5){
                    return '<div class="buttons-preview"><span class="label label-primary shiny"><?php echo $this->lang->line("CREATED"); ?></span></div>';
                }else if(data==1){
                    return '<div class="buttons-preview"><span class="label label-success shiny"><?php echo $this->lang->line("APPROVED"); ?></a></div>';
                }else if(data==2 || data==8){
                    return '<div class="buttons-preview"><span class="label label-danger shiny"><?php echo $this->lang->line("REJECTED"); ?></a></div>';
                }else if(data==3 || data==7){
                    return '<div class="buttons-preview"><span class="label label-warning shiny"><?php echo $this->lang->line("ONHOLD"); ?></a></div>';
                }else if(data==4 || data==6){
                    return '<div class="buttons-preview"><span class="label label-info"><?php echo $this->lang->line("UPDATED"); ?></a></div>';
                } else {
                    return '<div class="buttons-preview"><span class="label label-primary shiny"><?php echo $this->lang->line("CREATED"); ?></span></div>';
                }
                }},
                {"targets": [ 7 ],"sortable" : true  ,"render": function ( data, type, row ) {
                    if(row[6]==0 || row[6]==3 || row[6]==4 || row[6]==5 || row[6]==6 || row[6]==7){
                        return '<a class="btn btn-small btn-info btn-xs shiny fa fa-edit" href="<?php echo base_url('finance/payments/editrecord') ?>/' + data + '"><span></span></a>&nbsp;<a class="btn btn-small btn-danger btn-xs shiny fa fa-trash-o" href="javascript:void(0)" onclick="deletefn(\'' + data + '\')"><span></span></a>';
                    } else if(row[6]==9) {
                        return '<a class="btn btn-small btn-danger btn-xs shiny fa fa-trash-o" href="javascript:void(0)" onclick="deletefn(\'' + data + '\')"><span></span></a>';
                    }else{
                        return '&nbsp;';
                    }
                }},
            ],
        });
    }
    
    function deletefn(delId){
        $("#okid").val(delId);
        $("#deletebutton").click();
    }
    function deleteFunction(){
        var rowid;
        rowid   =   $("#okid").val();
        document.location.href = "<?php echo base_url('finance/payments/delete_transaction/'); ?>" + rowid;
    }
</script>
