<style type="text/css">
    #deposit_length{
        display: none;
    }
    .remove_btn{
        display: none;
    }
    .search_btn{
        display: none;
    }
    
</style>
<div class="page-content">
    <!-- Page Breadcrumb -->
    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#"><?php echo $this->lang->line("FINANCE"); ?></a>
            </li>
            <li class="active"><?php echo $this->lang->line("DEPOSITS"); ?></li>
        </ul>
    </div>
    <!-- /Page Breadcrumb -->
    <!-- Page Header -->
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                <?php echo $this->lang->line("DEPOSITS"); ?>
            </h1>
        </div>
        <!--Header Buttons-->
        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>
        <!--Header Buttons End-->
    </div>
    <!-- /Page Header -->
    <!-- Page Body -->
    <!-- End Page Body -->
    <div class="page-body">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="row">
                    <div class="col-xs-12 col-md-12">
                        <div class="widget">
                            <?php
                            if ($this->session->flashdata('success_msg')) {
                            ?>
                            <div class="alert alert-success">
                            <a href="#" class="close" data-dismiss="alert">&times;</a>
                            <?php echo $this->session->flashdata('success_msg'); $this->session->unset_userdata('success_msg');?>
                            </div>
                            <?php
                            }
                            ?>
                            <div class="widget-body">
                                <div class="table-toolbar col-lg-6 col-md-6 col-sm-6 col-xs-6">
                                    <a id="add_deposit" href="<?php echo site_url('finance/Deposits/add_deposit')?>" class="btn btn-success shiny"><span class="fa fa-plus"></span></a>
                                    &nbsp;&nbsp;&nbsp;
                                    <select id="selectstatus" name="selectstatus">
                                        <option value="">Select Status</option>
                                        <option value="0"><?php echo $this->lang->line("CREATED"); ?></option>
                                        <option value="1"><?php echo $this->lang->line("APPROVED"); ?></option>
                                        <option value="2"><?php echo $this->lang->line("REJECTED"); ?></option>
                                        <option value="3"><?php echo $this->lang->line("ONHOLD"); ?></option>
                                        <option value="4"><?php echo $this->lang->line("UPDATED"); ?></option>
                                    </select>
                                </div>
                                <table class="table table-striped table-hover table-bordered" id="deposit">
                                    <thead>
                                        <tr role="row">
                                            <th>
                                                <?php echo $this->lang->line("NO"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("DATE"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("ACCOUNTS"); ?>
                                            </th>
                                            <th class="text-align-right">
                                                <?php echo $this->lang->line("AMOUNT"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("DEPOSITEDBY"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("STATUS"); ?>
                                            </th>
                                            <th>
                                                <?php echo $this->lang->line("ACTION"); ?>
                                            </th>
                                        </tr>
                                    </thead>
                                </table>
<!--                                </form>-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<button type="button" id="deletebutton" data-toggle="modal" data-target="#confirmmodal" style="display: none;">dd</button>
<div id="confirmmodal" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line("DEPOSITS"); ?></h4>
            </div>
            <div class="modal-body">
                <p><?php echo $this->lang->line("AREYOUSURETODELETE"); ?></p>
            </div>
            <div class="modal-footer">
                <input type="hidden" id="okid" value="">
                <button type="button" class="btn btn-success" onclick="return deleteFunction()"><?php echo $this->lang->line("YES"); ?></button>
                <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo $this->lang->line("NO"); ?></button>
            </div>
        </div>
    </div>
</div>
<!-- End Page Content-->
<script>
    $(document).ready(function () {
        var table = $('#deposit').DataTable( {
        "bProcessing": true,
        "bServerSide": true,
        "sAjaxSource": "<?php echo base_url('finance/Deposits/view_deposit') ?>",
        "fnServerParams": function ( aoData ) {
            aoData.push( { 
                "name": "STATUS", "value": $('#selectstatus').val(),
            } );
        },
        "lengthMenu": [[20, 50, 100], [20, 50, 100]],
        "oLanguage": {
            "sEmptyTable":     "<?php echo $this->lang->line("NOTHINGFOUND"); ?>",
            "sInfo":           "<?php echo $this->lang->line("SHOWINGPAGE"); ?> _START_ <?php echo $this->lang->line("TO"); ?> _END_ <?php echo $this->lang->line("OF"); ?> _TOTAL_ <?php echo $this->lang->line("ENTRIES"); ?>",
            "sInfoEmpty":      "<?php echo $this->lang->line("SHOWINGPAGE"); ?> 0 <?php echo $this->lang->line("TO"); ?> 0 <?php echo $this->lang->line("OF"); ?> 0 <?php echo $this->lang->line("ENTRIES"); ?>",
            "sInfoPostFix":    "",
            "sInfoThousands":  ",",
            "sLengthMenu":     "<?php echo $this->lang->line("SHOW"); ?> _MENU_ <?php echo $this->lang->line("ENTRIES"); ?>",
            "sLoadingRecords": "<?php echo $this->lang->line("LOADING"); ?>",
            "sProcessing":     "<?php echo $this->lang->line("PROCESSING"); ?>",
            "sSearch":         "",
            "sZeroRecords":    "<?php echo $this->lang->line("NORECORDSAVAILABLE"); ?>",
            "oPaginate": {
                "sFirst":    "<?php echo $this->lang->line("FIRST"); ?>",
                "sLast":     "<?php echo $this->lang->line("LAST"); ?>",
                "sNext":     "<?php echo $this->lang->line("NEXT"); ?>",
                "sPrevious": "<?php echo $this->lang->line("PREVIOUS"); ?>"
            }
        },
        "columnDefs" : [
            {"targets": [5],"sortable" : true  ,"render": function ( data, type, row ) {
                if(data==0) {
                    return '<div class="buttons-preview"><span class="label label-primary shiny"><?php echo $this->lang->line("CREATED"); ?></span></div>';
                } else if(data==1) {
                    return '<div class="buttons-preview"><span class="label label-success shiny"><?php echo $this->lang->line("APPROVED"); ?></a></div>';
                } else if(data==2) {
                    return '<div class="buttons-preview"><span class="label label-danger shiny"><?php echo $this->lang->line("REJECTED"); ?></a></div>';
                } else if(data==3) {
                    return '<div class="buttons-preview"><span class="label label-warning shiny"><?php echo $this->lang->line("ONHOLD"); ?></a></div>';
                } else if(data==4) {
                    return '<div class="buttons-preview"><span class="label label-info"><?php echo $this->lang->line("UPDATED"); ?></a></div>';
                } else {
                    return '<div class="buttons-preview"><span class="label label-primary shiny"><?php echo $this->lang->line("CREATED"); ?></span></div>';
                }
            }},
            {"targets": [ 6 ],"sortable" : true  ,"render": function ( data, type, row ) {
                if(row[5]==0 || row[5]==3 || row[5]==4){
                    return '<a class="btn btn-small btn-info btn-xs shiny fa fa-edit" href="<?php echo base_url('finance/Deposits/editrecord') ?>/' + data + '"><span></span></a>&nbsp;<a class="btn btn-small btn-xs btn-danger shiny fa fa-trash-o" href="javascript:void(0)" onclick="deletefn(\'' + data + '\')"><span></span></a>';
                }else{
                    return '&nbsp;';
                }
            }},
            {
                "targets": 3,
                "className": "text-right"
            },
        ],
    });

    $('#selectstatus').on('change', function() {
        table.draw();
    });

        //search
            $("<a style='margin-left:5px'  class='search_btn btn btn-info fa fa-search'></a><a style='margin-left:5px' class='remove_btn btn btn-info fa fa-remove'></a><input type='hidden' name='search_btn' id='search_btn'>").appendTo(".dataTables_filter");
            $(".search_btn").click(function(){
                $("#search_btn").val("search");
                table.ajax.reload();
                $("#search_btn").val("");
            });
            
            $(".remove_btn").click(function(){
                location.reload();
            });
            
            $("input[type=search]").on("keypress", function(e){
                if(e.keyCode === 13){
                    e.preventDefault(); // Ensure it is only this code that rusn
                    $(".search_btn").click();
                }else{
                    return;
                }
            });
            
            $('#deposit').wrap($('<div style="overflow-x:scroll; width:100%"/>'));
            // Check All Functionality
            $('#deposit thead th input[type=checkbox]').change(function() {
                var set = $("#deposit tbody tr input[type=checkbox]");
                var checked = $(this).is(":checked");
                $(set).each(function() {
                    if (checked) {
                        $(this).prop("checked", true);
                        $(this).parents('tr').addClass("active");
                    } else {
                        $(this).prop("checked", false);
                        $(this).parents('tr').removeClass("active");
                    }
                });
            });
        $('#deposit tbody tr input[type=checkbox]').change(function() {
            $(this).parents('tr').toggleClass("active");
        });
    });
    function deletefn(delId){
        $("#okid").val(delId);
        $("#deletebutton").click();
    }
    function deleteFunction(){
        var rowid;
        rowid   =   $("#okid").val();
        document.location.href = "<?php echo base_url('finance/deposits/delete_transaction/'); ?>" + rowid;
    }
</script>
