<div class="page-content">
    <!-- Page Breadcrumb -->
    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#"><?php echo $this->lang->line("FINANCE"); ?></a>
            </li>
            <li class="active"><?php echo $this->lang->line("ACCOUNTS"); ?></li>
        </ul>
    </div>
    <!-- /Page Breadcrumb -->
    <!-- Page Header -->
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                <?php echo $this->lang->line("ACCOUNTS"); ?>
            </h1>
        </div>
        <!--Header Buttons-->
        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>
        <!--Header Buttons End-->
    </div>
    <!-- /Page Header -->
    <!-- Page Body -->
    <!-- End Page Body -->
    <div class="page-body">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="row">
                    <div class="col-xs-12 col-md-12">
                        <div class="widget">
                            <?php
                                if ($this->session->flashdata('success_msg')) {
                                ?>
                                    <div class="alert alert-success">
                                        <a href="#" class="close" data-dismiss="alert">&times;</a>
                                        <?php echo $this->session->flashdata('success_msg');$this->session->unset_userdata('success_msg'); ?>
                                    </div>
                                <?php
                                }
                                ?>
                            <div class="widget-body">
                                <div class="table-toolbar col-xs-6 col-md-6">
                                    <a id="add_account" href="<?php echo site_url('finance/accounts/add_account') ?>"
                                       class="btn btn-success shiny"><span class="fa fa-plus"></span></a>
                                </div>
                                <div class="table-toolbar col-xs-6 col-md-6">
                                    <input class="form-control" id="myInput" type="text" placeholder="Search..">
                                </div>
                                <div id="tablecontent" class="table-scrollable">
                                    <table class="table table-bordered">
    <thead>
      <tr>
        <th>
            <?php echo $this->lang->line("NO"); ?>
        </th>
        <th>
            <?php echo $this->lang->line("ACCOUNTNAME"); ?>
        </th>
        <th>
            <?php echo $this->lang->line("ACCOUNTNUMBER"); ?>
        </th>
        <th class="text-align-right">
            <?php echo $this->lang->line("AVAILABLEBALANCE"); ?>
        </th>
        <th>
        </th>
      </tr>
    </thead>
    <tbody id="myTable">
        <?php
        $totalamount=0;
        if($accounts){
            $slno=1;
            foreach($accounts as $account){
        ?>
        <tr>
            <td><?php echo $slno; ?></td>
            <td><?php echo $account->ACCOUNT_NAME; ?></td>
            <td><?php echo $account->ACCOUNT_NUMBER; ?></td>
            <td class="text-align-right"><?php echo $this->formatslist->formatCurrencyWithHash($account->AVAILABLE_BALANCE); ?></td>
                <td>
                    <?php if($account->ID!='PURCHASE' && $account->ID!='SALE'){ ?>
                        <a class="btn btn-small btn-info btn-xs shiny fa fa-pencil-square-o" href="<?php echo site_url('finance/accounts/editAccount')."/".$account->ID."/"; ?>"></a>&nbsp;
                    <?php } ?>
                    <a class="btn btn-small btn-magenta btn-xs shiny fa fa-line-chart" href="<?php echo site_url('finance/statement') ?>"><span></span></a> &nbsp;
                    <?php if($account->ID!='PURCHASE' && $account->ID!='SALE'){ ?>
                        <a class="btn btn-small btn-danger btn-xs shiny fa fa-trash-o" onclick="deletefn('<?php echo $account->ID; ?>')" href="javascript:void(0)"><span></span></a>
                    <?php } ?>
                </td>
            
        </tr>
        <?php
            $totalamount    =   $totalamount+$account->AVAILABLE_BALANCE;
            $slno++;
            }
        }
        ?>
    </tbody>
    <tfoot>
        <tr>
            <td colspan="3" style="font-weight: bold;font-size: 17px;text-align: right;">
                <?php echo $this->lang->line("TOTAL"); ?>
            </td>
            <td style="font-weight: bold;font-size: 17px;text-align: right;">
                <?php echo $this->formatslist->formatCurrencyWithHash($totalamount); ?>
            </td>
            <td>
                
            </td>
        </tr>
    </tfoot>
  </table>
                                </div>
  
                            </div>
                        </div>
                    </div>
                </div>

<script>
$(document).ready(function(){
  $("#myInput").on("keyup", function() {
    var value = $(this).val().toLowerCase();
    $("#myTable tr").filter(function() {
      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
  });
});
</script>
            </div>
        </div>
    </div>
</div>
<!-- End Page Content -->
<button type="button" id="deletebutton" data-toggle="modal" data-target="#confirmmodal" style="display: none;">dd</button>
<div id="confirmmodal" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><?php echo $this->lang->line("ACCOUNTS"); ?></h4>
            </div>
            <div class="modal-body">
                <p><?php echo $this->lang->line("AREYOUSURETODELETE"); ?></p>
            </div>
            <div class="modal-footer">
                <input type="hidden" id="okid" value="">
                <button type="button" class="btn btn-success" onclick="deleteFunction()"><?php echo $this->lang->line("OK"); ?></button>
        <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo $this->lang->line("CLOSE"); ?></button>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
//    function deleteAccount() {
//        var checked_input = false;
//        var set = $("#accounts tbody tr input[type=checkbox]");
//        $(set).each(function () {
//            if (this.checked) {
//                checked_input = true;
//            }
//        });
//        if (!checked_input) {
//            return;
//        }
//
//        if (confirm("Delete the selected account?")) {
//            document.getElementById('form_accounts').submit();
//        }
//    }
   

    function deletefn(delId){
        $("#okid").val(delId);
        $("#deletebutton").click();
    }
    function deleteFunction(){
        var rowid;
        rowid   =   $("#okid").val();
        document.location.href = "<?php echo base_url('finance/accounts/delete_accounts/'); ?>" + rowid;
    }
</script>
