<div class="page-content">
    <!-- Page Breadcrumb -->
    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#"><?php echo $this->lang->line("FINANCE"); ?></a>
            </li>
            <li class="active"><?php echo $this->lang->line("DEPOSITS"); ?></li>
        </ul>
    </div>
    <!-- /Page Breadcrumb -->
    <!-- Page Header -->
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                <?php echo $this->lang->line("DEPOSITS"); ?>
            </h1>
        </div>
        <!--Header Buttons-->
        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>
        <!--Header Buttons End-->
    </div>
    <!-- /Page Header -->
    <!-- Page Body -->
    <!-- End Page Body -->
    <div class="page-body">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="row">
                    <div class="col-xs-12 col-md-12">
                        <div class="widget">
                            <div >
                                <div class = "row center">
                                    <div class="col-lg-12 col-sm-12 col-xs-12">
                                        <div class="widget center">
                                            <div class="widget-header bordered-bottom bordered-lightred">
                                                <span class="widget-caption"><?php echo $this->lang->line("DEPOSITFROM"); ?></span>
                                            </div>
                                            <div class="widget-body">
                                                <div id="horizontal-form">
<form id="togglingForm" class="form-horizontal" role="form" method="POST" action="<?php echo site_url('finance/Deposits/add_deposit')?>">
    <input type="hidden" name="depId" value="<?php echo (isset($depositdetails)) ? $depositdetails->ID:''; ?>" />
    <div class="form-group">
        <label for="inputEmail3" class="col-sm-2 control-label no-padding-right"><?php echo $this->lang->line("DATE"); ?></label>
        <div class="col-sm-3">
            <div class="input-group">
                <input class="form-control date-picker" id="id-date-picker-1 TRANSACTION_DATE" name="TRANSACTION_DATE" type="text" data-date-format="dd-mm-yyyy" readonly value="<?php echo (isset($depositdetails)) ? $this->formatslist->dateFormat($depositdetails->TRANSACTION_DATE): date('d-m-Y'); ?>" />
                <span class="input-group-addon">
                    <i class="fa fa-calendar"></i>
                </span>
            </div>
        </div>
    </div>
    <div class="form-group">
        <label for="inputEmail3" class="col-sm-2 control-label no-padding-right"><?php echo $this->lang->line("ACCOUNTTO"); ?></label>
        <div class="col-sm-10">
            <select id="account" name="account" style="width:100%" required onchange="getBalance(this.value)">
                <option value><?php echo $this->lang->line("SELECTACCOUNT"); ?></option>
                <?php
                foreach ($accounts as $key => $value) {
                    if(isset($depositdetails) && $depositdetails->ACCOUNT_ID==$value->ID) $selectvar='selected'; else $selectvar='';
                    echo "<option value=\"".$value->ID."\" ".$selectvar." />".$value->ACCOUNT_NAME;    
                }
                ?>
            </select>
            <p id="available_balance" style="color:red; display:none"><?php echo $this->lang->line("AVAILABLEBALANCEIS"); ?> : <strong id="avbalamount"></strong></p>
        </div>
    </div>
    <div class="form-group">
        <label for="inputPassword3" class="col-sm-2 control-label no-padding-right"><?php echo $this->lang->line("AMOUNT"); ?></label>
        <div class="col-sm-10">
            <input id="amount" type="number" class="form-control" name="amount" placeholder="<?php echo $this->lang->line("AMOUNT"); ?>" required step="any" value="<?php echo (isset($depositdetails)) ? $this->formatslist->formatCurrency($depositdetails->AMOUNT):''; ?>" />
        </div>
    </div>
    <div class="form-group">
        <label for="inputPassword3" class="col-sm-2 control-label no-padding-right"><?php echo $this->lang->line("COMMENTS"); ?></label>
        <div class="col-sm-10">
            <textarea id="comments" name="comments" class="form-control" placeholder="<?php echo $this->lang->line("COMMENTS"); ?>"><?php echo (isset($depositdetails)) ? $depositdetails->COMMENTS:''; ?></textarea>
        </div>
    </div>
                                                        <div class="form-group">
                                                            <div class="col-sm-offset-2 col-sm-10">
<!--                                                                <a class="btn btn-success" onclick="deposit()">
                                                                    <span class="fa fa-send"></span>    
                                                                    Deposit
                                                                </a>-->
<button type="submit" class="btn btn-success shiny">
    <span class="fa fa-check"></span> <?php echo $this->lang->line("SAVE"); ?>
</button>
<a id="close" href="<?php echo site_url('finance/deposits')?>" class="btn btn-danger shiny">
    <span class="fa fa-close"></span> <?php echo $this->lang->line("CLOSE"); ?>
</a>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div> 
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Page Content -->
<script type="text/javascript">
    // Get Balance of the Account
    function getBalance(accid){
        if(accid){
            $.ajax({
                method: "POST",
                url: "<?php echo base_url('finance/Deposits/get_account'); ?>",
                data: {
                    account: accid
                },
            }).done(function (msg) {
                $("#available_balance").show();
                $("#avbalamount").html(msg);
            });
        }else{
            $("#available_balance").hide();
            $("#avbalamount").html('');
        }
    }
</script>

<script src="<?php echo base_url(); ?>assets/js/validation/bootstrapValidator.js"></script>
<script type="text/javascript">
    $('#togglingForm').bootstrapValidator({
        message: 'This value is not valid',
        feedbackIcons: {
            valid: 'glyphicon glyphicon-ok',
            invalid: 'glyphicon glyphicon-remove',
            validating: 'glyphicon glyphicon-refresh'
        },
        submitHandler: function (validator, form, submitButton) {
            // Do nothing
        },
        fields: {
            account: {
                validators: {
                    notEmpty: {
                        message: '<?php echo $this->lang->line("ENTERACCOUNTNUMBER"); ?>'
                    }
                }
            },
            amount: {
                validators: {
                    notEmpty: {
                        message: '<?php echo $this->lang->line("PLEASEENTERAMOUNT"); ?>'
                    }
                }
            }
        }
    })
    .find('button[data-toggle]')
    .on('click', function () {
        var $target = $($(this).attr('data-toggle'));
        $target.toggle();
        if (!$target.is(':visible')) {
            $('#togglingForm').data('bootstrapValidator').disableSubmitButtons(false);
        }
    });
</script>