
<div class="page-content">
    <!-- Page Breadcrumb -->
    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#"><?php echo $this->lang->line("BANKING"); ?></a>
            </li>
            <li class="active"><?php echo $this->lang->line("ACCOUNT"); ?></li>
        </ul>
    </div>
    <!-- /Page Breadcrumb -->
    <!-- Page Header -->
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                <?php echo $this->lang->line("ACCOUNT"); ?>
            </h1>
        </div>
        <!--Header Buttons-->
        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>
        <!--Header Buttons End-->
    </div>
    <!-- /Page Header -->
    <!-- Page Body -->
    <!-- End Page Body -->
    <div class="page-body">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="row">
                    <div class="col-xs-12 col-md-12">
                        <div class="widget">
                            <div class="widget-body">
                                <div class = "row center">
                                    <div class="col-lg-12 col-sm-12 col-xs-12">
                                        <div class="widget center">
                                            <div>
                                                <div id="horizontal-form">
                                                    <form class="form-horizontal" id="togglingForm" role="form" method="POST" action="<?php echo site_url('finance/accounts/add_account')?>">
                                                        <input type="hidden" name="id" value="<?php echo !empty($account)?$account->ID:''?>">
                                                        <div class="form-group">
                                                            <label for="inputEmail3" class="col-sm-2 control-label no-padding-right">
                                                                <?php echo $this->lang->line("ACCOUNTNAME"); ?></label>
                                                            <div class="col-sm-10">
                                                                <input type="text" class="form-control" name="account_name" placeholder="<?php echo $this->lang->line("ACCOUNTNAME"); ?>" required value="<?php echo !empty($account)?$account->ACCOUNT_NAME:''?>" />
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="inputPassword3" class="col-sm-2 control-label no-padding-right" ><?php echo $this->lang->line("ACCOUNTNUMBER"); ?></label>
                                                            <div class="col-sm-10">
                                                                <input type="text" class="form-control" name="account_number" placeholder="<?php echo $this->lang->line("ACCOUNTNUMBER"); ?>" value="<?php echo !empty($account)?$account->ACCOUNT_NUMBER:''?>" />
                                                            </div>
                                                        </div>
                                                        <div class="form-group">
                                                            <label for="inputPassword3" class="col-sm-2 control-label no-padding-right"><?php echo $this->lang->line("INITIALBALANCE"); ?></label>
                                                            <div class="col-sm-10">
                                                                <?php if(!empty($account)){?>
                                                                    <input type="number" class="form-control" name="initial_balance"
                                                                           placeholder="<?php echo $this->lang->line("INITIALBALANCE"); ?>" required 
                                                                           value="<?php echo $this->formatslist->formatCurrency($account->INITIAL_BALANCE); ?>" readonly step="any" />
                                                                <?php }else{ ?>
                                                                    <input type="number" class="form-control" name="initial_balance" 
                                                                           placeholder="<?php echo $this->lang->line("INITIALBALANCE"); ?>" required step="any" />
                                                                <?php }?>
                                                            </div>
                                                        </div>
    <div class="form-group">
        <label for="inputPassword3" class="col-sm-2 control-label no-padding-right"><?php echo $this->lang->line("AVAILABLEBALANCE"); ?></label>
        <div class="col-sm-10">
            <input type="number" class="form-control" name="available_balance" readonly 
                   placeholder="<?php echo $this->lang->line("AVAILABLEBALANCE"); ?>"
                   value="<?php echo !empty($account)?$this->formatslist->formatCurrency($account->AVAILABLE_BALANCE):''?>" step="any" />
            
        </div>
    </div>
                                                        <div class="form-group">
                                                            <div class="col-sm-offset-2 col-sm-10">
                                                                <button type="submit" class="btn btn-success shiny">
                                                                <span class="fa fa-check"></span>
                                                                <?php echo $this->lang->line("SAVE"); ?></button>
                                                                <a id="close" href="<?php echo site_url('finance/accounts')?>" class="btn btn-danger shiny">
                                                                    <span class="fa fa-close"></span>
                                                                    <?php echo $this->lang->line("CLOSE"); ?>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div> 
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Page Content -->
<script src="<?php echo base_url(); ?>assets/js/validation/bootstrapValidator.js"></script>
<script type="text/javascript">
    $('#togglingForm').bootstrapValidator({
        message: 'This value is not valid',
        feedbackIcons: {
            valid: 'glyphicon glyphicon-ok',
            invalid: 'glyphicon glyphicon-remove',
            validating: 'glyphicon glyphicon-refresh'
        },
        submitHandler: function (validator, form, submitButton) {
            // Do nothing
        },
        fields: {
            account_name: {
                validators: {
                    notEmpty: {
                        message: '<?php echo $this->lang->line("ENTERACCOUNTNUMBER"); ?>'
                    }
                }
            },
            initial_balance: {
                validators: {
                    notEmpty: {
                        message: '<?php echo $this->lang->line("PLEASEENTERAMOUNT"); ?>'
                    }
                }
            },
        }
    })
    .find('button[data-toggle]')
    .on('click', function () {
        var $target = $($(this).attr('data-toggle'));
        $target.toggle();
        if (!$target.is(':visible')) {
            $('#togglingForm').data('bootstrapValidator').disableSubmitButtons(false);
        }
    });
</script>