
<div class="page-content">
    <!-- Page Breadcrumb -->
    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#">Employee</a>
            </li>
            <li class="active">Leave</li>
        </ul>
    </div>
    <!-- /Page Breadcrumb -->

    <!-- Page Header -->
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                Leave Type
            </h1>
        </div>
        <!--Header Buttons-->
        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>
        <!--Header Buttons End-->
    </div>
    <!-- /Page Header -->
    <!-- Page Body -->
    



    
    <!-- End Page Body -->
                

    <div class="page-body">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="row">
                    <div class="col-xs-12 col-md-12">
                        <div class="widget">
                            <div class="widget-header ">
                                <span class="widget-caption">Leave Type</span>
                                <div class="widget-buttons">
                                    <a href="#" data-toggle="maximize">
                                        <i class="fa fa-expand"></i>
                                    </a>
                                    <a href="#" data-toggle="collapse">
                                        <i class="fa fa-minus"></i>
                                    </a>
                                    <a href="#" data-toggle="dispose">
                                        <i class="fa fa-times"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="widget-body">
                                <div class="table-toolbar">
                                    <a id="add_leave" href="<?php echo site_url('add_leave')?>" class="btn btn-success">
                                        <span class="fa fa-plus"></span>
                                        
                                    </a>
                                    <a id="delete_account" onclick="deleteAccount()" class="btn btn-danger">
                                        <span class="fa fa-trash"></span>
                                        
                                    </a>
                                    
                                </div>
                                <form id="form_leaves" method="post" action="<?php echo site_url('delete_leaves')?>">
                                    
                                <table class="table table-striped table-hover table-bordered" id="leave">
                                    <thead>
                                        <tr role="row">
                                            <th>
                                                No
                                            </th>
                                            <th>
                                                <label>
                                                    <input type="checkbox">
                                                    <span class="text"></span>
                                                </label>
                                            </th>
                                            <th>
                                                Leave Name
                                            </th>
                                            <th>
                                                Leave Type
                                            </th>
                                            <th>
                                                Id
                                            </th>
                                        </tr>
                                    </thead>

                                    
                                </table>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Page Content -->

<script>

    $(document).ready(function(){
        var table=$('#leave').DataTable({
            "processing": true,
            "serverSide": true,
            "aLengthMenu": [
                    [5, 15, 20, 100, -1],
                    [5, 15, 20, 100, "All"]
            ],
            "sPaginationType": "bootstrap",
            "sDom": "Tflt<'row DTTTFooter'<'col-sm-6'i><'col-sm-6'p>>",
            "tableTools": {
                "aButtons": [
                        "copy"
                ]
            },
            "ajax":{
                "url": "<?php echo base_url('view_leaves') ;?>",
                "dataType": "json",
                "type": "POST",
                "data": function(d){
                    d.search_btn = $('#search_btn').val();
                }
            },
            "oLanguage": {
                "sLengthMenu": "\_MENU_",
                "sSearch": "" 
            },

            "columns": [
                    { "data": "id",
                        "render":function(data, type, row, meta){
                            return meta.row+meta.settings._iDisplayStart+1;
                        }
                    },
                    { "data": "checkbox",
                      "bSortable": false,
                      "render": function ( data, type, row){
                          return '<label><input type="checkbox" name="id[]" value="'+row.id+'"><span class="text"></span></label>';
                      }
                    },
                    { "data": "leave_type",
                      "render": function ( data, type, row){
                          return '<a href="'+"<?php echo site_url('leaves')?>"+"/"+row.id+'">'+data+'</a>';
                      }
                    },
                    { "data": "leave_number"},
                    { "data": "id"}
                ]	 

            });

            //search
            $("<a style='margin-left:5px'  class='search_btn btn btn-info fa fa-search'></a><a style='margin-left:5px'  class='remove_btn btn btn-info fa fa-remove'></a><input type='hidden' name='search_btn' id='search_btn'>").appendTo(".dataTables_filter");
        
            $(".search_btn").click(function(){
                $("#search_btn").val("search");
                table.ajax.reload();
                $("#search_btn").val("");
            });

            $(".remove_btn").click(function(){
                location.reload();

            });

            $("input[type=search]").on("keypress", function(e){

                if(e.keyCode === 13){

                    e.preventDefault(); // Ensure it is only this code that rusn

                    $(".search_btn").click();
                }else{
                    return;
                }

            });

            $('#leave').wrap($('<div style="overflow-x:scroll; width:100%"/>'));


            $(".search_btn").click(function(){
                $("#search_btn").val("search");
                table.ajax.reload();
                $("#search_btn").val("");
            });

            // Check All Functionality
            $('#leave thead th input[type=checkbox]').change(function() {
                var set = $("#leave tbody tr input[type=checkbox]");
                var checked = $(this).is(":checked");
                $(set).each(function() {
                    if (checked) {
                        $(this).prop("checked", true);
                        $(this).parents('tr').addClass("active");
                    } else {
                        $(this).prop("checked", false);
                        $(this).parents('tr').removeClass("active");
                    }
                });

            });
            $('#leave tbody tr input[type=checkbox]').change(function() {
                $(this).parents('tr').toggleClass("active");
            });

            

            

        });


    

    function deleteAccount(){
        var checked_input = false;

        var set = $("#leave tbody tr input[type=checkbox]");
        $(set).each(function() {
            if (this.checked) {
                checked_input = true;
            } 
        });
        if (!checked_input){
            return;
        }
        
        if (confirm("Delete the selected leaves?")){
            document.getElementById('form_leaves').submit();
        }
    }
    


    
</script>   