
<div class="page-content">
    <!-- Page Breadcrumb -->
    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#">Employee</a>
            </li>
            <li class="active">Employee</li>
        </ul>
    </div>
    <!-- /Page Breadcrumb -->

    <!-- Page Header -->
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                Employee
            </h1>
        </div>
        <!--Header Buttons-->
        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>
        <!--Header Buttons End-->
    </div>
    <!-- /Page Header -->
    <!-- Page Body -->
    



    
    <!-- End Page Body -->
                

    <div class="page-body">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="row">
                    <div class="col-xs-12 col-md-12">
                        <div class="widget">
                            <div class="widget-header ">
                                <span class="widget-caption">Employee</span>
                                <div class="widget-buttons">
                                    <a href="#" data-toggle="maximize">
                                        <i class="fa fa-expand"></i>
                                    </a>
                                    <a href="#" data-toggle="collapse">
                                        <i class="fa fa-minus"></i>
                                    </a>
                                    <a href="#" data-toggle="dispose">
                                        <i class="fa fa-times"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="widget-body">
                                <div class="table-toolbar">
                                    <a id="add_employee" href="<?php echo site_url('add_employee')?>" class="btn btn-success">
                                        <span class="fa fa-plus"></span>
                                    </a>
                                    <a id="delete_employee" onclick="deleteEmployee()" class="btn btn-danger">
                                        <span class="fa fa-trash"></span>
                                        
                                    </a>
                                </div>
                                <form id="form_accounts" method="post" action="<?php echo site_url('delete_employees')?>">
                                <table border="0" cellspacing="15" cellpadding="5" id="filter_inputs" >
                                    <tbody>
                                        <tr>
                                            <td>
                                                <div class="input-group">
                                                    <select id="filter_dept" name="filter_dept" style="width:100%" required>
                                                        <option value>Select Department</option>
                                                        <?php
                                                            foreach ($departments as $key => $value) {
                                                                echo "<option value=\"".$value->id."\" />".$value->name;    
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="input-group">
                                                    <select id="filter_desg" name="filter_desg" style="width:100%" required>
                                                        <option value>Select Designation</option>
                                                        <?php
                                                            foreach ($designations as $key => $value) {
                                                                echo "<option value=\"".$value->id."\" />".$value->title;    
                                                            }
                                                        ?>
                                                    </select>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                
                                    
                                
                                <table class="table table-striped table-hover table-bordered" id="tbl_employee">
                                    <thead>
                                        <tr role="row">
                                            <th>
                                                No
                                            </th>
                                            <th>
                                                <label>
                                                    <input type="checkbox">
                                                    <span class="text"></span>
                                                </label>  
                                            </th> 
                                            <th>
                                                Name
                                            </th>
                                            <th>
                                                Employee Id
                                            </th>
                                            <th>
                                                Department
                                            </th>
                                            <th>
                                                Designation
                                            </th>
                                            <th>
                                                Email
                                            </th>
                                            <th>
                                                CTC
                                            </th>
                                            <th>

                                            </th>
                                        </tr>
                                    </thead>
                                </table>


                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

   <!-- End Page Content    -->
<script>
    
    $(document).ready(function () {
        var table = $('#tbl_employee').DataTable({
            "processing": true,
            "serverSide": true,
            "aLengthMenu": [
                    [5, 15, 20, 100, -1],
                    [5, 15, 20, 100, "All"]
                ],
            "sPaginationType": "bootstrap",
            "sDom": "Tflt<'row DTTTFooter'<'col-sm-6'i><'col-sm-6'p>>",
            "tableTools": {
                "aButtons": [
                        "copy"
                    ]
            },
            "ajax":{
                "url": "<?php echo base_url('view_employees') ?>",
                "dataType": "json",
                "type": "POST",
                "data": function(d){
                    d.filter_dept = $('#filter_dept').val();
                    d.filter_desg = $('#filter_desg').val();
                    d.search_btn = $('#search_btn').val();
                }
            },
            "oLanguage": {
                "sLengthMenu": "\_MENU_",
                "sSearch": "" 
            },

            "columns": [
                    { "data": "userid",
                        "render":function(data, type, row, meta){
                            return meta.row+meta.settings._iDisplayStart+1;
                        }
                    },
                    { "data": "checkbox",
                      "bSortable": false,
                      "render": function ( data, type, row){
                          return '<input type="checkbox" value="'+data+'"><span class="text"></span>';
                      }  
                    },
                    {
                        "data":"name",
                        "render": function ( data, type, row){
                          return '<a href="'+"<?php echo site_url('employee')?>"+"/"+row.checkbox+'">'+data+'</a>';
                      }
                    },
                    { "data": "empid"},
                    { "data": "department" ,
                      "bSortable": false},
                    { "data": "designation" ,
                      "bSortable": false},
                    { "data": "email" ,
                      "bSortable": false},
                    { "data": "ctc",
                      "bSortable": false},
                    { "data": "send_email",
                      "bSortable": false,
                      "render": function ( data, type, row){
                          return '<a href="" class="btn btn-success" data-empid="'+data+'">'+row.email+'</a>';
                      }  
                    }
                ]	 

            });
        
        //search
            $("<a style='margin-left:5px'  class='search_btn btn btn-info fa fa-search'></a><a style='margin-left:5px'  class='remove_btn btn btn-info fa fa-remove'></a><input type='hidden' name='search_btn' id='search_btn'>").appendTo(".dataTables_filter");
        
            $(".search_btn").click(function(){
                $("#search_btn").val("search");
                table.ajax.reload();
                $("#search_btn").val("");
            });

            $(".remove_btn").click(function(){
                location.reload();

            });

            $("input[type=search]").on("keypress", function(e){

                if(e.keyCode === 13){

                    e.preventDefault(); // Ensure it is only this code that rusn

                    $(".search_btn").click();
                }else{
                    return;
                }

            });

        $('#tbl_employee').wrap($('<div style="overflow-x:scroll; width:100%"/>'));
    
        $(".search_btn").click(function(){
            $("#search_btn").val("search");
            table.ajax.reload();
            $("#search_btn").val("");
        });
        
        $('#filter_dept').change(function(){
            console.log("filter_dept");
            table.ajax.reload();
        });
        $('#filter_desg').change( function(){
            console.log("filter_desg");
            table.ajax.reload();
        });

        
 
    });
</script>