
<div class="page-content">
    <!-- Page Breadcrumb -->
    <div class="page-breadcrumbs">
        <ul class="breadcrumb">
            <li>
                <i class="fa fa-home"></i>
                <a href="#">Employee</a>
            </li>
            <li class="active">Department</li>
        </ul>
    </div>
    <!-- /Page Breadcrumb -->

    <!-- Page Header -->
    <div class="page-header position-relative">
        <div class="header-title">
            <h1>
                Employee Department
            </h1>
        </div>
        <!--Header Buttons-->
        <div class="header-buttons">
            <a class="sidebar-toggler" href="#">
                <i class="fa fa-arrows-h"></i>
            </a>
            <a class="refresh" id="refresh-toggler" href="">
                <i class="glyphicon glyphicon-refresh"></i>
            </a>
            <a class="fullscreen" id="fullscreen-toggler" href="#">
                <i class="glyphicon glyphicon-fullscreen"></i>
            </a>
        </div>
        <!--Header Buttons End-->
    </div>
    <!-- /Page Header -->
    <!-- Page Body -->
    



    
    <!-- End Page Body -->
                

    <div class="page-body">
        <div class="row">
            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                <div class="row">
                    <div class="col-xs-12 col-md-12">
                        <div class="widget">
                            <div class="widget-header ">
                                <span class="widget-caption">Employee Department</span>
                                <div class="widget-buttons">
                                    <a href="#" data-toggle="maximize">
                                        <i class="fa fa-expand"></i>
                                    </a>
                                    <a href="#" data-toggle="collapse">
                                        <i class="fa fa-minus"></i>
                                    </a>
                                    <a href="#" data-toggle="dispose">
                                        <i class="fa fa-times"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="widget-body">
                                <div class="table-toolbar">
                                    <a id="add_accouadd_departmentnt" href="<?php echo site_url('add_department')?>" class="btn btn-success">
                                        <span class="fa fa-plus"></span>
                                        
                                    </a>
                                    <a id="add_accouadd_departmentnt" onclick="update_multi_status(1)" class="btn btn-blue">
                                        <span class="fa fa-check"></span>
                                    </a>
                                    <a id="add_accouadd_departmentnt" onclick="update_multi_status(0)" class="btn btn-warning">
                                        <span class="fa fa-remove"></span>
                                    </a>
                                    <a id="delete_account" onclick="deleteAccount()" class="btn btn-danger">
                                        <span class="fa fa-trash"></span>
                                        
                                    </a>
                                    
                                </div>
                                <form id="form_departments" method="post" action="<?php echo site_url('delete_departments')?>">
                                    
                                <table border="0" cellspacing="15" cellpadding="5" id="filter_input" >
                                    <tbody>
                                        <tr>
                                            <td>
                                                <div class="input-group">
                                                    <select id="filter_status" name="filter_status" style="width:100%" required>
                                                        <option value>Status</option>
                                                        <option value="1">Published</option>
                                                        <option value="0">Unpublished</option>
                                                    </select>
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <table class="table table-striped table-hover table-bordered" id="department">
                                    <thead>
                                        <tr role="row">
                                            <th>
                                                No
                                            </th>
                                            <th>
                                                <label>
                                                    <input type="checkbox">
                                                    <span class="text"></span>
                                                </label>
                                            </th>
                                            <th>
                                                Name
                                            </th>
                                            <th>
                                                Status
                                            </th>
                                            <th>
                                                Id
                                            </th>
                                        </tr>
                                    </thead>

                                    
                                </table>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- End Page Content -->

<script>

    $(document).ready(function(){
        var table=$('#department').DataTable({
            "processing": true,
            "serverSide": true,
            "aLengthMenu": [
                    [5, 15, 20, 100, -1],
                    [5, 15, 20, 100, "All"]
            ],
            "sPaginationType": "bootstrap",
            "sDom": "Tflt<'row DTTTFooter'<'col-sm-6'i><'col-sm-6'p>>",
            "tableTools": {
                "aButtons": [
                        "copy"
                ]
            },
            "ajax":{
                "url": "<?php echo base_url('view_departments') ;?>",
                "dataType": "json",
                "type": "POST",
                "data": function(d){
                    d.filter_status = $('#filter_status').val();
                    d.search_btn = $('#search_btn').val();
                }
            },
            "oLanguage": {
                "sLengthMenu": "\_MENU_",
                "sSearch": "" 
            },

            "columns": [
                    { "data": "id",
                        "render":function(data, type, row, meta){
                            return meta.row+meta.settings._iDisplayStart+1;
                        }
                    },
                    { "data": "checkbox",
                      "bSortable": false,
                      "render": function ( data, type, row){
                          return '<label><input type="checkbox" name="id[]" data-status="'+row.published+'" value="'+row.id+'"><span class="text"></span></label>';
                      }
                    },
                    { "data": "name", 
                      "render": function ( data, type, row){
                          return '<a href="'+"<?php echo site_url('departments')?>"+"/"+row.id+'">'+data+'</a>';
                      }  

                    },
                    { "data": "published",
                        "bSortable": false,
                        "render": function (data, type, row){
                            if(data==0){
                                return '<a class="btn btn-circle btn-xs btn-danger" onclick="update_status('+row.id+','+1+')"><span class="fa fa-remove"></span></a>';
                            }else{
                                return '<a class="btn btn-circle btn-xs btn-success" onclick="update_status('+row.id+','+0+')"><span class="fa fa-check"></span></a>';
                            }
                        }
                    },
                    { "data": "id"}
                ]	 

            });

            //search
            //search
            $("<a style='margin-left:5px'  class='search_btn btn btn-info fa fa-search'></a><a style='margin-left:5px'  class='remove_btn btn btn-info fa fa-remove'></a><input type='hidden' name='search_btn' id='search_btn'>").appendTo(".dataTables_filter");
        
            $(".search_btn").click(function(){
                $("#search_btn").val("search");
                table.ajax.reload();
                $("#search_btn").val("");
            });

            $(".remove_btn").click(function(){
                location.reload();

            });

            $("input[type=search]").on("keypress", function(e){

                if(e.keyCode === 13){

                    e.preventDefault(); // Ensure it is only this code that rusn

                    $(".search_btn").click();
                }else{
                    return;
                }

            });

            $('#department').wrap($('<div style="overflow-x:scroll; width:100%"/>'));
    

            // Check All Functionality
            $('#department thead th input[type=checkbox]').change(function() {
                var set = $("#department tbody tr input[type=checkbox]");
                var checked = $(this).is(":checked");
                $(set).each(function() {
                    if (checked) {
                        $(this).prop("checked", true);
                        $(this).parents('tr').addClass("active");
                    } else {
                        $(this).prop("checked", false);
                        $(this).parents('tr').removeClass("active");
                    }
                });

            });
            $('#department tbody tr input[type=checkbox]').change(function() {
                $(this).parents('tr').toggleClass("active");
            });

            $('#filter_status').change(function(){
                console.log("filter_status");
                table.ajax.reload();
            });
        });



    function deleteAccount(){
        var checked_input = false;

        var set = $("#department tbody tr input[type=checkbox]");
        $(set).each(function() {
            if (this.checked) {
                checked_input = true;
            } 
        });
        if (!checked_input){
            return;
        }
        
        if (confirm("Delete the selected departments?")){
            document.getElementById('form_departments').submit();
        }
    }

    function update_status(id, status){
        $.ajax({
            url:"<?php echo site_url('update_department_status')?>",
            type: 'POST',
            dataType: 'json',
            data:{'id': id, 'published': status, "<?php echo $this->security->get_csrf_token_name(); ?>" : "<?php echo $this->security->get_csrf_hash(); ?>" },
            success: function(data){
                console.log(data);
                var table=$('#department').DataTable()
                table.ajax.reload();
                $("#department thead th input[type=checkbox]").attr('checked', false);
            },
            error: function(error){
                console.log(error);
            }

        });
    }

    function update_multi_status(status){
        var set = $("#department tbody tr input[type=checkbox]");

        $(set).each(function() {
            if (this.checked) {
                // checked_input = true;
                id = $(this).val();
                update_status(id, status);
            } 
        });
    }
    
</script>   