<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Warehouse_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
    //GET WAREHOUSES
    function getwarehouses() {
        $page = $this->input->post('page');
        $limit = $this->input->post('rows'); // get how many rows we want to have into the grid
        $sidx = $this->input->post('sidx'); // get index row - i.e. user click to sort
        $sord = $this->input->post('sord'); // get the direction

    //Default values
        if (!$sidx) $sidx = 'id';
        if (!$sord) $sord = 'asc';
        if (!$page) $page = 1;
        if (!$limit) $limit = 25;
        $search = $this->input->post('_search');

        if($search=='true')
        {
            $searchField = $this->input->post('searchField');
            $searchOper = $this->input->post('searchOper');
            $searchString = $this->input->post('searchString');
            $oper='';
            if($searchOper=='cn')
                $searchQry = 'LOCATIONS.'.$searchField . ' LIKE "%' . $searchString . '%"';
            else if($searchOper=='eq')
                $searchQry = 'LOCATIONS.'.$searchField . ' = "' . $searchString .'"';

            $this->db->where($searchQry);
        }
    //Total Returned Rows Count
        $this->db->from('LOCATIONS');
        $where='ID <> "-1" AND ID <> "0"';
        $this->db->where($where);
        $count = $this->db->count_all_results();

     //Total Pages
        if ($count > 0 && $limit > 0) {
            $total_pages = ceil($count / $limit);
            //Set start record number
            $start = $limit * $page - $limit;
        } else {
            $total_pages = 0;
            //Set start record number
            $start = 0;
        }


     //Check requested page
        if ($page > $total_pages) $page=$total_pages;

     //Set start record number
        $start = $limit*$page - $limit;

    //Format data for jqGrid output
       $data['page'] = "" . $page . "";
        $data['total'] = "" . $total_pages . "";
        $data['records'] = "" . $count . "";


     //Fetch data
        $this->db->select('ID, NAME,ADDRESS');
        $where='ID <> "-1" AND ID <> "0"';
        $this->db->where($where);
        if($search=='true') $this->db->where($searchQry);
        $this->db->order_by($sidx, $sord);
        //Total Pages
        if ($count > 0 && $limit > 0) {
            $total_pages = ceil($count / $limit);
            //Set start record number
            $start = $limit * $page - $limit;
        } else {
            $total_pages = 0;
            //Set start record number
            $start = 0;
        }
        $this->db->limit($limit, $start);
        $rows = $this->db->get("LOCATIONS")->result_array();

     //Format data
        $i=0;
        foreach($rows as $row){
            $data['rows'][$i]['id']=$i+1;
            $data['rows'][$i]['cell']=array($row['ID'], $row['NAME'],$row['ADDRESS']);
            $i++;
        }
        return json_encode($data);
    }
    
    function getwarehouseautocomplete($term='') {
         $this->db->select('ID, NAME');
         if(isset($term))
            $this->db->like('NAME',$term);
         return $this->db->get("LOCATIONS")->result();
    }

// GET ALL LOCATIONS EXCEPT MAIN
    function getsublocationscombo($id = NULL) {
        $this->db->select('ID, NAME');
        $this->db->where('ID <> "0"');
        $catarr = $this->db->get('LOCATIONS')->result();
        $data = '';
        for ($i = 0; $i < count($catarr); $i++) {
            if ($id != NULL && $id == $catarr[$i]->ID)
                $data .= "<option  \"id=\"option_custom\" selected=\"yes\" value=\"" . $catarr[$i]->ID . "\">" . $catarr[$i]->NAME . "</option>\n";
            else
                $data .= "<option \" id=\"option_custom\" value=\"" . $catarr[$i]->ID . "\">" . $catarr[$i]->NAME . "</option>\n";
        }
        return $data;
    }
    
    
    // GET LOCATIONS
    function getlocationscombo($id = NULL) {
        $this->db->select('ID, NAME');
        $catarr = $this->db->get('LOCATIONS')->result();
        $data = '';
        for ($i = 0; $i < count($catarr); $i++) {
            if ($id != NULL && $id == $catarr[$i]->ID)
                $data .= "<option  \"id=\"option_custom\" selected=\"yes\" value=\"" . $catarr[$i]->ID . "\">" . $catarr[$i]->NAME . "</option>\n";
            else
                $data .= "<option \" id=\"option_custom\" value=\"" . $catarr[$i]->ID . "\">" . $catarr[$i]->NAME . "</option>\n";
        }
        return $data;
    }
    
    function getlocationsgridcombo($id = NULL) {
        $this->db->select('ID, NAME');
        $catarr = $this->db->get('LOCATIONS')->result();
        $data = '';
        for ($i = 0; $i < count($catarr); $i++) {
            $data .= $catarr[$i]->ID . ":" . $catarr[$i]->NAME . ";";
        }
        if(strlen($data)>0)
        return substr($data, 0, strlen($data)-1);
    else {
    return '';    
    }
    }

    function getwarehousesautocomplete($term) {
       $this->db->select('U.ID, U.NAME');
        $where = "U.NAME LIKE '". $term . "%'";
         $this->db->where($where);
         return $this->db->get("LOCATIONS U")->result();
    }
    
    
    function warehouseInfo($id) {
	$this->db->where('ID', $id);
	return $this->db->get('LOCATIONS')->result();
	}
    //DELETE WAREHOUSE    
    function delete($id) {
        return ($this->db->delete('LOCATIONS', array('ID' => $id))) ? true : false;
     }
    //ADD WAREHOUSE 
    function add($form_data){
        $this->db->insert('LOCATIONS', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
     //UPDATE WAREHOUSE
    function update($id, $form_data){
        $this->db->where('ID', $id);
        $this->db->update('LOCATIONS', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
}
