<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Taxes_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
    
    function gettaxocomplete($term) {
         $this->db->select('ID , NAME');
            $where = "TAXES.NAME LIKE '". $term . "%'";
            $this->db->where($where);
            return $this->db->get("TAXES")->result();
    }
    
    
      function taxcategoriesautocomplete($term) {
         $this->db->select('ID , NAME');
            $where = "TAXCATEGORIES.NAME LIKE '". $term . "%'";
            $this->db->where($where);
            return $this->db->get("TAXCATEGORIES")->result();
    }
    
    
    //GET TAXES AUTOCOMPLETE
    function gettaxcategoryautocomplete($term) {
         $this->db->select('T.ID , T.NAME');
            $where = "T.NAME LIKE '". $term . "%'";
            $this->db->where($where);
            return $this->db->get("TAXCATEGORIES T")->result();
    }
    
    //GET TAXES
      function gettax()    {

        $this->db->select("TAXES.ID,TAXES.NAME,TAXCATEGORIES.NAME AS TAXCATEGORY,TAXCUSTCATEGORIES.NAME AS CUSTCATEGORY,((TAXES.RATE)*100) AS RATE,TAXES.RATEORDER,TAXES.RATECASCADE,TAXES.CUSTCATEGORY AS CUSTCATID,TAXES.CATEGORY AS CATID");
        $this->db->join('TAXCUSTCATEGORIES', 'TAXCUSTCATEGORIES.ID = TAXES.CUSTCATEGORY','LEFT');
        $this->db->join('TAXCATEGORIES', 'TAXCATEGORIES.ID = TAXES.CATEGORY','LEFT');
      $this->db->order_by("TAXES.RATE", "ASC");
            $rows = $this->db->get("TAXES")->result_array();
            return $rows;
    }

    function getTaxData($id) {
        $this->db->where('ID', $id);
        return $this->db->get('TAXES')->result();
    }

    //GET TAX CATEGORY
    function gettaxcats() {

        $page = $this->input->post('page');
        $limit = $this->input->post('rows'); // get how many rows we want to have into the grid
        $sidx = $this->input->post('sidx'); // get index row - i.e. user click to sort
        $sord = $this->input->post('sord'); // get the direction

        //Default values
        if (!$sidx) $sidx = 'id';
        if (!$sord) $sord = 'asc';

        if (!$page) $page = 1;
        if (!$limit) $limit = 25;
        
        $search = $this->input->post('_search');
        if($search=='true')
        {
            $searchField = $this->input->post('searchField');
            $searchOper = $this->input->post('searchOper');
            $searchString = $this->input->post('searchString');
            $oper='';
            if($searchOper=='cn')
                $searchQry = 'TAXCATEGORIES.'.$searchField . ' LIKE "%' . $searchString . '%"';
            else if($searchOper=='eq')
                $searchQry = 'TAXCATEGORIES.'.$searchField . ' = "' . $searchString .'"';
            $this->db->where($searchQry);
        }
        
        //Total Returned Rows Count
        $this->db->from('TAXCATEGORIES');
        $count = $this->db->count_all_results();

        //Total Pages
        if( $count > 0 && $limit > 0) {
              $total_pages = ceil($count/$limit);
        } else {
              $total_pages = 0;
        }

        //Check requested page
        if ($page > $total_pages) $page=$total_pages;

        //Set start record number
        $start = $limit*$page - $limit;

        //Format data for jqGrid output
        $data['page'] = "".$page."";
        $data['total'] = "".$total_pages."";
        $data['records'] = "".$count."";


        //Fetch data
        $this->db->select("ID, NAME");
        $where='ID <> "-1" AND ID <> "000"';
        $this->db->where($where);
        $this->db->order_by($sidx, $sord);
                
        if($search=='true') $this->db->where($searchQry);
        $this->db->limit($limit, $start);
        $rows = $this->db->get("TAXCATEGORIES")->result_array();

        //Format data
        $i=0;
        foreach($rows as $row){
            $data['rows'][$i]['id']=$i+1;
            $data['rows'][$i]['cell']=array($row['ID'],$row['NAME']);
            $i++;
        }
        return json_encode($data);
    }
 

    function getcat($name) {
        $this->db->where('NAME', $name);
        $q = $this->db->get('TAXCATEGORIES')->result();
        return $q[0]->ID;
    }
    
    function delete($id) {
        return ($this->db->delete('TAXCATEGORIES', array('ID' => $id))) ? true : false;
    }
    function add($form_data){
        $this->db->insert('TAXCATEGORIES', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
     function update($id, $form_data){
        $this->db->where('ID', $id);
        $this->db->update('TAXCATEGORIES', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
     function deletetax($id) {
        return ($this->db->delete('TAXES', array('ID' => $id))) ? true : false;
     }
     function addtax($form_data){
        $this->db->insert('TAXES', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
     function updatetax($id, $form_data){
        $this->db->where('ID', $id);
        $this->db->update('TAXES', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
     
    function getTaxByCatId($catid='') {
        $this->db->where('CATEGORY', $catid);
        $q = $this->db->get('TAXES')->result();
        return $q[0]->RATE;
    }
    
 }