<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Resources_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    //GET RESOURCES
    function getresources() {
        $page = $this->input->post('page');
        $limit = $this->input->post('rows'); // get how many rows we want to have into the grid
        $sidx = $this->input->post('sidx'); // get index row - i.e. user click to sort
        $sord = $this->input->post('sord'); // get the direction
        
        //Default values
        if (!$sidx)
            $sidx = 'id';
        if (!$sord)
            $sord = 'asc';

        if (!$page)
            $page = 1;
        if (!$limit)
            $limit = 25;
        $search = $this->input->post('_search');
        if($search=='true')
        {
            $searchField = $this->input->post('searchField');
            $searchOper = $this->input->post('searchOper');
            $searchString = $this->input->post('searchString');
            $oper='';
            if($searchOper=='cn')
                $searchQry = 'RESOURCES.'.$searchField . ' LIKE "%' . $searchString . '%"';
            else if($searchOper=='eq')
                $searchQry = 'RESOURCES.'.$searchField . ' = "' . $searchString .'"';

            $this->db->where($searchQry);
        }
        
        //Total Returned Rows Count
        $this->db->from('RESOURCES');
        $this->db->where("RESTYPE","0");
        $count = $this->db->count_all_results();
 //Set start record number
        $start = $limit * $page - $limit;
        //Total Pages
        if ($count > 0 && $limit > 0) {
            $total_pages = ceil($count / $limit);
        } else {
            $total_pages = 0;
            $start=0;
        }

        //Check requested page
        if ($page > $total_pages)
            $page = $total_pages;

       

        //Format data for jqGrid output
        $data['page'] = "" . $page . "";
        $data['total'] = "" . $total_pages . "";
        $data['records'] = "" . $count . "";

        //Fetch data
        $this->db->select("ID, NAME, RESTYPE,CONTENT");
        $this->db->where("RESTYPE","0");
        $this->db->order_by($sidx, $sord);
        $this->db->limit($limit, $start);
        if($search=='true') $this->db->where($searchQry);
        $rows = $this->db->get("RESOURCES")->result_array();

        //Format data
        $i = 0;
        libxml_use_internal_errors(true);
        foreach ($rows as $row) {

            if ($row['RESTYPE'] == "0") {
                $row['RESTYPE'] = "Text";
            } else {
                $row['RESTYPE'] = "Image";
            }

            $data['rows'][$i]['id'] = $i + 1;
            $id = $i + 1;
            $sxe = simplexml_load_string($row['CONTENT']);
            if ($sxe === false) 
                {
            $data['rows'][$i]['cell'] = array($row['ID'], $row['NAME'], $row['RESTYPE'],  $row['CONTENT']);
            }
            else
            {
                $data['rows'][$i]['cell'] = array($row['ID'], $row['NAME'], $row['RESTYPE'], $row['CONTENT']);
            }

            $i++;
        }
        return @json_encode($data);
    }

    public function getResourceImage($id) {
        $table_name = "RESOURCES";
        $this->db->select('CONTENT')->from($table_name);
        $this->db->where('NAME', $id);
        return $this->db->get()->result();
    }
      function getresourcesautocomplete($term) {
         $this->db->select('ID , NAME');
         $where = "RESOURCES.NAME LIKE '".$term . "%'";
         $this->db->where($where);
         return $this->db->get("RESOURCES")->result();
    }

    function resourceInfo($id) {
        $this->db->where('ID', $id);
        return $this->db->get('RESOURCES')->result();
    }

    public function getlines() {
        $sql = "SELECT * FROM RESOURCES";
        $query = $this->db->query($sql);
        return $query->result();
    }

    function updateResource($id, $name, $textarea) {
        $this->db->where('ID', $id);
        $update = array(
            'NAME' => $name,
            'CONTENT' => $textarea
        );
        return ($this->db->update('RESOURCES', $update)) ? true : false;
    }

    function getmenu()
    {
        $this->db->select('CONTENT');
        $this->db->where('NAME', 'Webin.Menu');
        $q = $this->db->get('RESOURCES')->result();
        
        return $q[0]->CONTENT;
    }
    
    function getreportsmenu()
    {
        $this->db->select('CONTENT');
        $this->db->where('NAME', 'Webin.Reports');
        $q = $this->db->get('RESOURCES')->result();
        
        return $q[0]->CONTENT;
    }
    
    function add($form_data){
        $this->db->insert('RESOURCES', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
     
    function update($id, $form_data){
        $this->db->where('ID', $id);
        $this->db->update('RESOURCES', $form_data);
        if ($this->db->affected_rows() == '1') {
            return TRUE;
        }
        return FALSE;
     }
     
    function delete($id) {
        return ($this->db->delete('RESOURCES', array('ID' => $id))) ? true : false;
    }
    public function getresourcesdata() {
        //        $data['data'] = $this->common->getAll('RESOURCES');
        $data = $this->common->customquery('SELECT ID, NAME,(CASE WHEN RESTYPE=0 THEN "Text" WHEN RESTYPE=1 THEN "Image" WHEN RESTYPE=2 THEN "Binary" ELSE "Text" END) RESTYPETEXT,RESTYPE FROM RESOURCES');
        return json_encode($data);
    }
}