<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Activetickets_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    function getactivetickets() {
        $page = $this->input->post('page');
        $limit = $this->input->post('rows'); // get how many rows we want to have into the grid
        $sidx = $this->input->post('sidx'); // get index row - i.e. user click to sort
        $sord = $this->input->post('sord'); // get the direction
//Default values
        if (!$sidx)
            $sidx = 'id';
        if (!$sord)
            $sord = 'asc';

        if (!$page)
            $page = 1;
        if (!$limit)
            $limit = 25;

//Total Returned Rows Count
        $this->db->from('SHAREDTICKETS');
        $count = $this->db->count_all_results();

//Total Pages
        if ($count > 0 && $limit > 0) {
            $total_pages = ceil($count / $limit);
        } else {
            $total_pages = 0;
        }

//Check requested page
        if ($page > $total_pages)
            $page = $total_pages;

//Set start record number
        $start = $limit * $page - $limit;

//Format data for jqGrid output
        $data['page'] = "" . $page . "";
        $data['total'] = "" . $total_pages . "";
        $data['records'] = "" . $count . "";


//Fetch data
//$this->db->select("ID, NAME");
        $this->db->select('SHAREDTICKETS.ID, PLACES.NAME');
        $this->db->join("PLACES", "PLACES.ID = SHAREDTICKETS.ID");
        $this->db->order_by($sidx, $sord);
        //$this->db->limit($limit, $start);
        $rows = $this->db->get("SHAREDTICKETS")->result_array();

//Format data
        $i = 0;
        foreach ($rows as $row) {
            $data['data'][$i]['id'] = $i + 1;
            $data['data'][$i]['cell'] = array($row['ID'], $row['NAME']);
            $i++;
        }
        return json_encode($data);
    }

    public function getactiveticketlinesbyparam($id) {

        $table_name = "SHAREDTICKETS, PLACES";


        $this->db->select('SHAREDTICKETS.ID, PLACES.NAME, SHAREDTICKETS.CONTENT')->from($table_name);
        $this->db->where('SHAREDTICKETS.ID = PLACES.ID');
        $this->db->group_by("SHAREDTICKETS.ID");

        return $this->db->get()->result();
    }

    public function getactiveticketlist() {
        $table_name = "SHAREDTICKETS";
        $this->db->select('ID,NAME')->from($table_name);
//        $this->db->where('SHAREDTICKETS.ID = PLACES.ID');
//        $this->db->group_by("SHAREDTICKETS.ID");
        return $this->db->get()->result();
    }
    
}