<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Ticket_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    function gettickets($datas) {
        $page = $this->input->post('page');
        $limit = $this->input->post('rows'); // get how many rows we want to have into the grid
        $sidx = $this->input->post('sidx'); // get index row - i.e. user click to sort
        $sord = $this->input->post('sord'); // get the direction
//Default values
        if (!$sidx)
            $sidx = 'NAME';
        if (!$sord)
            $sord = 'ASC';

        if (!$page)
            $page = 1;
        if (!$limit)
            $limit = 25;

        $j = 0;
        $doc = new DOMDocument('1.0');
        $doc->loadXml($this->getsharedticket($datas['tableID']));
        $doc->saveXML();
        $items = $doc->getElementsByTagName("com.posics.pos.ticket.TicketLineInfo");

        $at1 = 4;
        $at2 = 2;
        $at3 = 5;
        foreach ($items as $item) {

            $id = $item->getElementsByTagName("productid");
            $pid = $id->item(0)->nodeValue;
            $array['id'] = $pid;


            $p1 = $doc->getElementsByTagName('property')->item($at1);
            foreach ($p1->attributes as $atrbt1) {
                if ($atrbt1->nodeName == 'value') {
                    $array['product'] = $atrbt1->nodeValue;
                }
            }
            $at1 = $at1 + 7;

            $p2 = $doc->getElementsByTagName('property')->item($at2);
            foreach ($p2->attributes as $atrbt2) {
                if ($atrbt2->nodeName == 'value') {
                    $array['price'] = $atrbt2->nodeValue;
                }
            }
            $at2 = $at2 + 7;

            $qty = $item->getElementsByTagName("multiply");
            $$qtyvalue = $qty->item(0)->nodeValue;
            $array['quantity'] = $$qtyvalue;

            $p3 = $doc->getElementsByTagName('property')->item($at3);
            foreach ($p3->attributes as $atrbt3) {
                if ($atrbt3->nodeName == 'value') {
                    $array['kot'] = $atrbt3->nodeValue;
                }
            }
            $at3 = $at3 + 7;
            $rows[$j] = $array;

            $j++;
        }

        $count = $j;


//Total Pages
        if ($count > 0 && $limit > 0) {
            $total_pages = ceil($count / $limit);
//Set start record number
            $start = $limit * $page - $limit;
        } else {
            $total_pages = 0;
            $start = 0;
        }
//Check requested page
        if ($page > $total_pages)
            $page = $total_pages;

//Set start record number
//Format data for jqGrid output
        $data['page'] = "" . $page . "";
        $data['total'] = "" . $total_pages . "";
        $data['records'] = "" . $count . "";

        $i = 0;

        foreach ($rows as $row) {
            $data['rows'][$i]['id'] = $i + 1;
            $id = $i + 1;
            $data['rows'][$i]['cell'] = array($row['id'], $row['product'], $row['price'], $row['quantity'], $row['kot']);
            $i++;
        }


        return json_encode($data);
    }

    function getsharedticket($tableID) {
        $this->db->select('ST.NAME,ST.ID ,ST.CONTENT');
        $this->db->where('ST.ID', $tableID);
        $q = $this->db->get('SHAREDTICKETS ST');
        $ans = $q->result_array();
        return $ans[0]['CONTENT'];
    }

    function itemPlus($tableID, $updateticket) {
        $this->db->where('ID', $tableID);
        $this->db->update('SHAREDTICKETS', $updateticket);
        if ($this->db->affected_rows() == '1') {
            return TRUE;
        }
        return FALSE;
    }

    function billSettlement($tableID, $updateticket) {
        $this->db->where('ID', $tableID);
        $this->db->update('SHAREDTICKETS', $updateticket);
        if ($this->db->affected_rows() == '1') {
            return TRUE;
        }
        return FALSE;
    }

    function deleteTicket($data) {

        return ($this->db->delete('SHAREDTICKETS', array('ID' => $data['tableID']))) ? true : false;
    }

}
