<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');
class Customers_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    function customersCount() {
        return $this->db->get('CUSTOMERS')->num_rows();
    }
    
    //get customers autocomplete
    function getcustomersautocomplete($term) {
        $this->db->select('ID, NAME');
        $where = "NAME LIKE '". $term. "%'";
        $this->db->where($where);
        return $this->db->get("CUSTOMERS")->result();
    }
    
    //GET CARD AUTOCOMPLATE
    function getcustomercardautocomplete($term) {
        $this->db->select('ID, CARD');
        $where = "CARD LIKE '". $term. "%'";
        $this->db->where($where);
        return $this->db->get("CUSTOMERS")->result();
    }
    
    //GET CATEGORY AUTOCOMPLETE
    function getcategoriesautocomplete($term) {
        $this->db->select('TAXCUSTCATEGORIES.NAME AS TAXCATEGORY');
        $where = "TAXCUSTCATEGORIES.NAME LIKE '". $term. "%'";
        $this->db->where($where);
        return $this->db->get("TAXCUSTCATEGORIES")->result();
    }
     function getsearchkeyautocomplete($term) {
        $this->db->select('ID, SEARCHKEY');
        $this->db->from('CUSTOMERS');
        $where = "SEARCHKEY LIKE '". $term. "%'";
        $this->db->where($where);
        return $this->db->get()->result();       
 }
    function getcidbn($name) {
        $this->db->where('NAME', $name);
        $q = $this->db->get('CUSTOMERS')->result();
	return $q[0]->ID;
    }
    
    //GET PARTNER CATEGORIES
    function getcategories() {
        $page = $this->input->post('page');
        $limit = $this->input->post('rows'); // get how many rows we want to have into the grid
        $sidx = $this->input->post('sidx'); // get index row - i.e. user click to sort
        $sord = $this->input->post('sord'); // get the direction
        //Default values
        if (!$sidx)
            $sidx = 'id';
        if (!$sord)
            $sord = 'asc';

        if (!$page)
            $page = 1;
        if (!$limit)
            $limit = 25;
        $search = $this->input->post('_search');

        if($search=='true')
        {
        $searchField = $this->input->post('searchField');
        $searchOper = $this->input->post('searchOper');
        $searchString = $this->input->post('searchString');
        $oper='';
        if($searchOper=='cn')
            $searchQry = 'TAXCUSTCATEGORIES.'.$searchField . ' LIKE "%' . $searchString . '%"';
        else if($searchOper=='eq')
            $searchQry = 'TAXCUSTCATEGORIES.'.$searchField . ' = "' . $searchString .'"';

        $this->db->where($searchQry);
        }
        //Total Returned Rows Count
        $this->db->from('TAXCUSTCATEGORIES');
        $count = $this->db->count_all_results();

        //Total Pages
           if ($count > 0 && $limit > 0) {
            $total_pages = ceil($count / $limit);
            $start = $limit * $page - $limit;
        } else {
            $total_pages = 0;
            $start=0;
        }

        //Check requested page
        if ($page > $total_pages)
            $page = $total_pages;

        //Set start record number
        $start = $limit * $page - $limit;

        //Format data for jqGrid output
        $data['page'] = "" . $page . "";
        $data['total'] = "" . $total_pages . "";
        $data['records'] = "" . $count . "";

        //Fetch data
        $this->db->select("ID, NAME");
        $this->db->order_by($sidx, $sord);
         if($search=='true') $this->db->where($searchQry);
         
        //Total pages
         if ($count > 0 && $limit > 0) {
            $total_pages = ceil($count / $limit);
            $start = $limit * $page - $limit;
        } else {
            $total_pages = 0;
            $start=0;
        }
         $this->db->limit($limit, $start);
        $rows = $this->db->get("TAXCUSTCATEGORIES")->result_array();

        //Format data
        $i = 0;
        foreach ($rows as $row) {
            $data['rows'][$i]['id'] = $i + 1;
            $data['rows'][$i]['cell'] = array($row['ID'], $row['NAME']);
            $i++;
        }

        return json_encode($data);
    }

    function cCatName($id) {
        $this->db->where('ID', $id);
        $q = $this->db->get('TAXCUSTCATEGORIES')->result();
        return $q[0]->NAME;
    }

    function getCCatData($id) {
        $this->db->where('ID', $id);

        return $this->db->get('TAXCUSTCATEGORIES')->result();
    }

   function getCustomerCategories() {

        $this->db->select('ID, NAME');
        return $this->db->get('TAXCUSTCATEGORIES')->result();
    }
   
    function getCustomerById($id) {
        $this->db->where('ID', $id);
        return $this->db->get('CUSTOMERS')->result();
    }
    function getcustomerautocomplete($term) {
        $this->db->select('C.ID, C.NAME');
        $this->db->from('CUSTOMERS AS C');
        $where = "C.NAME LIKE '". $term. "%'";
        return $this->db->get()->result();

    }
    function add($form_data){
        $this->db->insert('CUSTOMERS', $form_data);
        if ($this->db->affected_rows() == '1') {
            return TRUE;
        }
        return FALSE;
     }
     function addpartnercat($form_data){
        $this->db->insert('TAXCUSTCATEGORIES', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
  
     function update($id, $form_data){
        $this->db->where('ID', $id);
        $this->db->update('CUSTOMERS', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
      function updatepartnercat($id, $form_data){
        $this->db->where('ID', $id);
        $this->db->update('TAXCUSTCATEGORIES', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
   
    
     function delete($id) {
        return ($this->db->delete('CUSTOMERS', array('ID' => $id))) ? true : false;
     }
     
     function deletepartnercat($id) {
        return ($this->db->delete('TAXCUSTCATEGORIES', array('ID' => $id))) ? true : false;
     }
   
     //GET CUSTOMERS
     function getcustomers() {
    
        //Fetch data
        $this->db->select("CUSTOMERS.ID,CUSTOMERS.SEARCHKEY, CUSTOMERS.NAME, CUSTOMERS.CARD, CUSTOMERS.MAXDEBT, CUSTOMERS.CURDEBT, T.NAME AS TAXCATEGORY, CUSTOMERS.ADDRESS,CUSTOMERS.PHONE,CUSTOMERS.EMAIL,CUSTOMERS.FAX,CUSTOMERS.NOTES,CUSTOMERS.TAXCATEGORY AS TAXCATID");
        $this->db->join('TAXCUSTCATEGORIES AS T', 'T.ID = CUSTOMERS.TAXCATEGORY', 'LEFT');
    
        $rows = $this->db->get("CUSTOMERS")->result_array();
        
        return $rows;
    }
 
     //Partner Categories Autocomplete
    function getcustcatautocomplete($term) {
        $this->db->select('E.ID, E.NAME');
        $where = "E.NAME LIKE '". $term . "%'";
        $this->db->where($where);
        return $this->db->get("TAXCUSTCATEGORIES E")->result();
    }
    function customerImageSave($form_data=''){
        $this->db->insert('CUSTOMER_IMAGES', $form_data);
        if ($this->db->affected_rows() == '1') {
            return true;
        }
        return false;
    }
    function customerImageList($custid=''){
        $this->db->where('CUSTOMER', $custid);
        return $this->db->get('CUSTOMER_IMAGES')->result();
    }
    function customerimagedelete($id) {
        return ($this->db->delete('CUSTOMER_IMAGES', array('ID' => $id))) ? true : false;
    }
    
    function checkcustimageexisttable() {
        $totalCount = $this->common->customquery("SHOW TABLES LIKE 'CUSTOMER_IMAGES'");
        if($totalCount){
            return 1;
        } else {
            return 0;
        }
    }
    function checkcustmembexisttable() {
        $totalCount = $this->common->customquery("SHOW TABLES LIKE 'CUSTOMER_MEMBERS'");
		//echo $totalCount;exit;
        if($totalCount){
            return 1;
        } else {
            return 0;
        }
    }
    function customerMembersList($custId=''){
        $this->db->select('*');
        $where = "CUSTOMER_ID='".$custId."'";
        $this->db->where($where);
        return $this->db->get("CUSTOMER_MEMBERS")->result();
    }
    function getcustomermember($editid=''){
        $this->db->select('*');
        $where = "ID='".$editid."'";
        $this->db->where($where);
        $record =   $this->db->get("CUSTOMER_MEMBERS")->result();
        return $record[0];
    }
    
    function customerMembersAdd($form_data){
        $this->db->insert('CUSTOMER_MEMBERS', $form_data);
        if ($this->db->affected_rows() == '1') {
            return TRUE;
        }
        return FALSE;
    }
    
    function customerMembersupdate($form_data,$id=''){
        $this->db->where('ID', $id);
        $this->db->update('CUSTOMER_MEMBERS', $form_data);
        return TRUE;
    }
    
    function getCustomercardlabelformat(){
        $this->db->select('CONTENT');
        $this->db->where('NAME', 'Printer.CustomerCard');
        $q = $this->db->get("RESOURCES");
        if($q) {
            return simplexml_load_string(htmlspecialchars_decode($q->row()->CONTENT));
        } else {
            return null;    
        }
    }
    
    function getcustomerimage($imgid=''){
        $this->db->select('*');
        $where = "ID='".$imgid."'";
        $this->db->where($where);
        $record =   $this->db->get("CUSTOMER_IMAGES")->result();
        return $record[0];
    }
}

