<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Productsbywarehouse_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

//GET PRODUCT GROUPS
    public function getproductwarehouses() {
        $page = $this->input->post('page');
        $limit = $this->input->post('rows'); // get how many rows we want to have into the grid
        $sidx = $this->input->post('sidx'); // get index row - i.e. user click to sort
        $sord = $this->input->post('sord'); // get the direction
//Default values
        if (!$sidx)
            $sidx = 'id';
        if (!$sord)
            $sord = 'asc';

        if (!$page)
            $page = 1;
        if (!$limit)
            $limit = 25;

//Total Returned Rows Count
        $this->db->from('LOCATIONS');
        $count = $this->db->count_all_results();

//Total Pages
        if ($count > 0 && $limit > 0) {
            $total_pages = ceil($count / $limit);
        } else {
            $total_pages = 0;
        }

//Check requested page
        if ($page > $total_pages)
            $page = $total_pages;

//Set start record number
        $start = $limit * $page - $limit;

//Format data for jqGrid output
        $data['page'] = "" . $page . "";
        $data['total'] = "" . $total_pages . "";
        $data['records'] = "" . $count . "";


//Fetch data
        $this->db->select("ID, NAME");
        $this->db->order_by($sidx, $sord);
//$this->db->limit($limit, $start);
        $rows = $this->db->get("LOCATIONS")->result_array();

//Format data
        $i = 0;
        foreach ($rows as $row) {
            $data['rows'][$i]['id'] = $i + 1;
            $data['rows'][$i]['cell'] = array($row['ID'], $row['NAME']);
            $i++;
        }
        return json_encode($data);
    }
     //FOR   PRODUCT GROUPS AUTOCOMPLETE

  function getproductgroupsautocomplete($term) {

        $this->db->select('ID, NAME');
        $this->db->like('NAME', $term);
         return $this->db->get("PRODUCTGROUPS")->result();

    }

    public function getlines($id) {

        $table_name = "LOCATIONS_PROD";
        $this->db->select("PRODUCTS.NAME AS PRODUCT")->from($table_name);
        $this->db->where('LOCATIONS_PROD.LOCATION', $id);
        $this->db->join('PRODUCTS', 'PRODUCTS.ID = LOCATIONS_PROD.PRODUCT','LEFT');
        return $this->db->get()->result();
    }

    function getNames() {
        $this->db->select('ID, NAME');
        return $this->db->get('PRODUCTGROUPS')->result();
        //returned to table "locations"
    }

    function getNamName($id) {
        $this->db->where('ID', $id);
        $q = $this->db->get('PRODUCTGROUPS')->result();
        return $q[0]->NAME;
    }

 function empty_product($id){
    $table_name = "PRODUCTGROUPS_PROD";
    $this->db->select('PRODUCTGROUPS_PROD.PRODUCT')->from($table_name);
     $this->db->where('PRODUCTGROUPS_PROD.PRODUCTGROUP',$id);
       return $this->db->get()->result() ? true : false;
	}
    function addGroup($array) {
        return ($this->db->insert('PRODUCTGROUPS', $array)) ? true : false;
    }

    function addLine($array) {
        return ($this->db->insert('LOCATIONS_PROD', $array)) ? true : false;
    }

    function updateGroup($id, $PRODUCT) {
        $this->db->where('ID', $id);
        $update = array(
            'NAME' => $PRODUCT
        );
        return ($this->db->update('LOCATIONS_PROD', $update)) ? true : false;
    }

    function deleteLines($id) {
        return ($this->db->delete('LOCATIONS_PROD', array('LOCATION' => $id))) ? true : false;
    }

    public function viewproductgroups($id) {

        $table_name = "PRODUCTGROUPS, PRODUCTGROUPS_PROD";
        $this->db->select('PRODUCTGROUPS_PROD.PRODUCT')->from($table_name);
        $this->db->where('PRODUCTGROUPS.ID = PRODUCTGROUPS_PROD.PRODUCTGROUP');
        $this->db->group_by("PRODUCTGROUPS.ID");
        return $this->db->get()->result();
    }

    public function getproductlist($id) {

        $table_name = "PRODUCTGROUPS, PRODUCTGROUPS_PROD";
        $this->db->select('PRODUCTGROUPS_PROD.PRODUCT')->from($table_name);
        $this->db->where('PRODUCTGROUPS.ID = PRODUCTGROUPS_PROD.PRODUCTGROUP');
        $this->db->group_by("PRODUCTGROUPS.ID");
        return $this->db->get()->result();
    }

    function getGroupById($id) {
        $this->db->where('ID', $id);
        return $this->db->get('LOCATIONS')->result();
    }

    function getpnbid($id) {
        $this->db->where('ID', $id);
        return $this->db->get('LOCATIONS')->result();
    }

    function getpidbn($name) {
        $this->db->where('NAME', $name);
        return $this->db->get('PRODUCTGROUPS')->result();
    }

    function getLinesById($id) {
        $table_name = "LOCATIONS_PROD, PRODUCTS";
        $this->db->where('LOCATIONS_PROD.LOCATION', $id);
        $this->db->where('LOCATIONS_PROD.PRODUCT = PRODUCTS.ID');
        $this->db->select('PRODUCTS.NAME')->from($table_name);

        return $this->db->get()->result();
    }

    function deleteProductgroup($id) {
        return ($this->db->delete('PRODUCTGROUPS', array('ID' => $id))) ? true : false;
    }

}

