<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Attribute_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    // GET PRODUCT ATTRIBUTES
    function getproductattributes() {
        $page = $this->input->post('page');
        $limit = $this->input->post('rows'); // get how many rows we want to have into the grid
        $sidx = $this->input->post('sidx'); // get index row - i.e. user click to sort
        $sord = $this->input->post('sord'); // get the direction
   
        //Default values
        if (!$sidx)
            $sidx = 'id';
        if (!$sord)
            $sord = 'asc';

        if (!$page)
            $page = 1;
        if (!$limit)
            $limit = 25;
        $search = $this->input->post('_search');

        if($search=='true')
        {
            $searchField = $this->input->post('searchField');
            $searchOper = $this->input->post('searchOper');
            $searchString = $this->input->post('searchString');
            $oper='';
            if($searchOper=='cn')
                $searchQry = 'ATTRIBUTE.'.$searchField . ' LIKE "%' . $searchString . '%"';
            else if($searchOper=='eq')
                $searchQry = 'ATTRIBUTE.'.$searchField . ' = "' . $searchString .'"';
                 
            $this->db->where($searchQry);         
        }
        
        //Total Returned Rows Count
        $this->db->from('ATTRIBUTE');
        $count = $this->db->count_all_results();

        //Total Pages
        if ($count > 0 && $limit > 0) {
            $total_pages = ceil($count / $limit);
            $start = $limit * $page - $limit;
        } else {
            $total_pages = 0;
            $start=0;
        }

        //Check requested page
        if ($page > $total_pages)
            $page = $total_pages;

        //Set start record number
        //$start = $limit * $page - $limit;
        

        //Format data for jqGrid output
        $data['page'] = "" . $page . "";
        $data['total'] = "" . $total_pages . "";
        $data['records'] = "" . $count . "";

        //Fetch data
        $this->db->select('ID, NAME');
        $this->db->order_by($sidx, $sord);
        $this->db->limit($limit, $start);
        if($search=='true') $this->db->where($searchQry);
        $rows = $this->db->get("ATTRIBUTE")->result_array();

        //Format data
        $i = 0;
        foreach ($rows as $row) {
            $data['rows'][$i]['id'] = $i + 1;
            $data['rows'][$i]['cell'] = array($row['ID'], $row['NAME']);
            $i++;
        }
        return json_encode($data);
    }

    // GET PRODUCT ATTRIBUTE SETS
    function getproductattributesets() {
        $page = $this->input->post('page');
        $limit = $this->input->post('rows'); // get how many rows we want to have into the grid
        $sidx = $this->input->post('sidx'); // get index row - i.e. user click to sort
        $sord = $this->input->post('sord'); // get the direction
        
        //Default values
        if (!$sidx)
            $sidx = 'id';
        if (!$sord)
            $sord = 'asc';

        if (!$page)
            $page = 1;
        if (!$limit)
            $limit = 25;

        $search = $this->input->post('_search');

        if($search=='true')
        {
            $searchField = $this->input->post('searchField');
            $searchOper = $this->input->post('searchOper');
            $searchString = $this->input->post('searchString');
            $oper='';
            if($searchOper=='cn')
                $searchQry = 'ATTRIBUTESET.'.$searchField . ' LIKE "%' . $searchString . '%"';
            else if($searchOper=='eq')
                $searchQry = 'ATTRIBUTESET.'.$searchField . ' = "' . $searchString .'"';
                 
            $this->db->where($searchQry);         
        }
        
        //Total Returned Rows Count
        $this->db->from('ATTRIBUTESET');
        $count = $this->db->count_all_results();

        //Total Pages
         if ($count > 0 && $limit > 0) {
            $total_pages = ceil($count / $limit);
            $start = $limit * $page - $limit;
        } else {
            $total_pages = 0;
            $start=0;
        }
        //Check requested page
        if ($page > $total_pages)
            $page = $total_pages;

        //Set start record number
        $start = $limit * $page - $limit;

        //Format data for jqGrid output
        $data['page'] = "" . $page . "";
        $data['total'] = "" . $total_pages . "";
        $data['records'] = "" . $count . "";


        //Fetch data
        $this->db->select('ID, NAME');
        $this->db->order_by($sidx, $sord);
        // $this->db->limit($limit, $start);
        if($search=='true') $this->db->where($searchQry);
        $rows = $this->db->get("ATTRIBUTESET")->result_array();

        //Format data
        $i = 0;
        foreach ($rows as $row) {
            $data['rows'][$i]['id'] = $i + 1;
            $data['rows'][$i]['cell'] = array($row['ID'], $row['NAME']);
            $i++;
        }
        return json_encode($data);
    }

    // GET PRODUCT ATTRIBUTE VALUES
    function getproductattributevalues() {
        $page = $this->input->post('page');
        $limit = $this->input->post('rows'); // get how many rows we want to have into the grid
        $sidx = $this->input->post('sidx'); // get index row - i.e. user click to sort
        $sord = $this->input->post('sord'); // get the direction
        
        //Default values
        if (!$sidx)
            $sidx = 'id';
        if (!$sord)
            $sord = 'asc';
        if (!$page)
            $page = 1;
        if (!$limit)
            $limit = 25;
  $search = $this->input->post('_search');

        if($search=='true')
        {
            $searchField = $this->input->post('searchField');
            $searchOper = $this->input->post('searchOper');
            $searchString = $this->input->post('searchString');
            $oper='';
            if($searchOper=='cn')
                $searchQry = 'ATTRIBUTEVALUE.'.$searchField . ' LIKE "%' . $searchString . '%"';
            else if($searchOper=='eq')
                $searchQry = 'ATTRIBUTEVALUE.'.$searchField . ' = "' . $searchString .'"';
                 
            $this->db->where($searchQry);         
        }
        //Total Returned Rows Count
        $this->db->from('ATTRIBUTEVALUE');
        $count = $this->db->count_all_results();

       
        //Total Pages
         if ($count > 0 && $limit > 0) {
            $total_pages = ceil($count / $limit);
            $start = $limit * $page - $limit;
        } else {
            $total_pages = 0;
            $start=0;
        }

        //Check requested page
        if ($page > $total_pages)
            $page = $total_pages;

        //Set start record number
        $start = $limit * $page - $limit;

        //Format data for jqGrid output
        $data['page'] = "" . $page . "";
        $data['total'] = "" . $total_pages . "";
        $data['records'] = "" . $count . "";

        //Fetch data
        $this->db->select('ATTRIBUTEVALUE.ID,ATTRIBUTE.NAME,ATTRIBUTEVALUE.VALUE,ATTRIBUTEVALUE.ATTRIBUTE_ID');
        $this->db->join('ATTRIBUTE', 'ATTRIBUTE.ID = ATTRIBUTEVALUE.ATTRIBUTE_ID', 'LEFT');
        $this->db->order_by($sidx, $sord);
         //Total Pages
         if ($count > 0 && $limit > 0) {
            $total_pages = ceil($count / $limit);
            $start = $limit * $page - $limit;
        } else {
            $total_pages = 0;
            $start=0;
        }
        if($search=='true') $this->db->where($searchQry);
        $this->db->limit($limit, $start);
        $rows = $this->db->get("ATTRIBUTEVALUE")->result_array();

        //Format data
        $i = 0;
        foreach ($rows as $row) {
            $data['rows'][$i]['id'] = $i + 1;
            $data['rows'][$i]['cell'] = array($row['ID'], $row['NAME'], $row['VALUE'], $row['ATTRIBUTE_ID']);
            $i++;
        }
        return json_encode($data);
    }
   
    // GET PRODUCT ATTRIBUTE DROPDOWN
    public function productattributedropdown() {
        $this->db->select('ID, NAME');
        return $this->db->get('ATTRIBUTE')->result();
    }
       
    function getattributeid($name) {
        $this->db->where('NAME', $name);
        $q = $this->db->get('ATTRIBUTE')->result();
        return $q[0]->ID;
    }
     
    //FOR AUTOCOMPLETE
    function attributeautocomplete($term) {
          $this->db->select('A.ID, A.NAME');
            $where = "A.NAME LIKE '". $term . "%'";
            $this->db->where($where);
            return $this->db->get("ATTRIBUTE A")->result(); 
    }
    function attributesautocomplete($term) {
          $this->db->select('ID,NAME');
            $where = "NAME LIKE '". $term . "%'";
            $this->db->where($where);
            return $this->db->get("ATTRIBUTE")->result(); 
    }    
    
    function attributevalueautocomplete($term) {
          $this->db->select('ID,VALUE');
            $where = "VALUE LIKE '". $term . "%'";
            $this->db->where($where);
            return $this->db->get("ATTRIBUTEVALUE")->result(); 
    } 
    
    function attributesetautocomplete($term) {
          $this->db->select('ID,NAME');
            $where = "NAME LIKE '". $term . "%'";
            $this->db->where($where);
            return $this->db->get("ATTRIBUTESET")->result(); 
    } 
    function delete($id) {
        return ($this->db->delete('ATTRIBUTESET', array('ID' => $id))) ? true : false;
     }
    
     function add($form_data){
        $this->db->insert('ATTRIBUTESET', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
         return FALSE;
     }
     
     function update($id, $form_data){
        $this->db->where('ID', $id);
        $this->db->update('ATTRIBUTESET', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
        
     function deleteattribute($id) {
        return ($this->db->delete('ATTRIBUTE', array('ID' => $id))) ? true : false;
     }
    
     function addattribute($form_data){
        $this->db->insert('ATTRIBUTE', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
         return FALSE;
     }
     
     function updateattribute($id, $form_data){
        $this->db->where('ID', $id);
        $this->db->update('ATTRIBUTE', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
        
     function deleteattributevalue($id) {
        return ($this->db->delete('ATTRIBUTEVALUE', array('ID' => $id))) ? true : false;
     }
    
     function addattributevalue($form_data){
        $this->db->insert('ATTRIBUTEVALUE', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
         return FALSE;
     }
     
     function updateattributevalue($id, $form_data){
        $this->db->where('ID', $id);
        $this->db->update('ATTRIBUTEVALUE', $form_data);
		if ($this->db->affected_rows() == '1')
		{
			return TRUE;
		}
        return FALSE;
     }
  }