<?php
class TModeModel extends CI_Model {
    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function add_tmode($data) {
        $this->db->insert('transactionmodes',$data);
        return true;
    }

    public function update_tmode($id,$data) {
//        $this->db->where(array('id' => $id,'ownerid' => $ownerid));
        $this->db->where(array('ID' => $id));
        $this->db->update('transactionmodes',$data);
        return true;
    }

    public function get_tmode($id) {
        $this->db->where('ID', $id);
        $query = $this->db->get('transactionmodes');
        return $query->result();
    }

//    public function delete_tmodes($ids) {
//        $this->db->where_in('id', $ids);
//        $this->db->delete('transactionmodes');
//        return true;
//    }

//    public function delete_tmodes($id) {
//        $this->db->where('id', $id);
//        $this->db->delete('transactionmodes');
//        return true;
//    }
    
    function all_tmodes_count() {
        $query = $this->db->get('transactionmodes');
        return $query->num_rows();
    }

    function all_tmodes($limit, $start, $col, $dir) {
        $this->db->select('*');
        $this->db->from('transactionmodes');
        $this->db->order_by($col, $dir);
        $this->db->limit($limit, $start);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    function tmodes_search($limit,$start,$search_array,$col,$dir,$ownerid) {
        // $where = ' Where ownerid='.$ownerid;
        $where = '';
        if (isset($search_array['search'])) {
            $where .= ' Where LOWER(title) like "%' . $search_array['search'] . '%"';
        }
        $sql = 'SELECT * FROM transactionmodes' .
            $where . ' Order by ' . $col . ' ' . $dir .
            ' Limit ' . $limit . ' Offset ' . $start;
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    function tmodes_search_count($search, $ownerid) {
        // $where = ' Where ownerid='.$ownerid;
        $where = '';
        if (isset($search_array['search'])) {
            $where .= ' where LOWER(title) like "%' . $search_array['search'] . '%"';
        }
        $sql = 'SELECT * FROM transactionmodes' . $where;

        $query = $this
                ->db
                ->query($sql);

        return $query->num_rows();
    }

    function dropdown_tmodes() {
        $this->db->select('*');
        $this->db->from('transactionmodes');

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

    function get_tmodes() {
        //get listing of all user of an owner

        $sql = 'SELECT * from transactionmodes';
        $query = $this->db->query($sql);

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return null;
        }
    }

}
