<?php
class LeaveModel extends CI_Model
{
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
       
	public function add_leave($data)
	{
		$this->db->insert('lkqou_vbizz_leaves',$data);
		return true;
	}

	public function update_leave($id, $ownerid, $data)
	{
		$this->db->where(array('id'=>$id, 'ownerid'=>$ownerid));
		$this->db->update('lkqou_vbizz_leaves', $data);
		return true;
	}
	public function get_leave($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get('lkqou_vbizz_leaves');
		return $query->result();
	}

	public function delete_leaves($ids){
		$this->db->where_in('id', $ids);
		$this->db->delete('lkqou_vbizz_leaves');
		return true;
	}

	

	function all_leaves_count()
    {   
        $query = $this
                ->db
                ->get('lkqou_vbizz_leaves');
    
        return $query->num_rows();  

    }
    
    function all_leaves($limit,$start,$col,$dir)
    {   

		$this->db->select('*');
		$this->db->from('lkqou_vbizz_leaves');
		$this->db->order_by($col,$dir);
		$this->db->limit($limit, $start);

		$query = $this->db->get();
        
        if($query->num_rows()>0)
        {
            return $query->result(); 
        }
        else
        {
            return null;
        }
        
    }
   
    function leaves_search($limit,$start,$search_array,$col,$dir, $ownerid)
    {
        // $where = ' Where ownerid='.$ownerid;
        $where = '';

        if(isset($search_array['search'])){
            $where .= ' Where LOWER(leave_type) like "%'.$search_array['search'].'%"';
        }
        
		$sql ='SELECT * FROM lkqou_vbizz_leaves'.
              $where.' Order by '.$col.' '.$dir.
			  ' Limit '.$limit.' Offset '.$start;
        
        $query = $this
                ->db
                ->query($sql);
    
        
        if($query->num_rows()>0)
        {
            return $query->result(); 
        }
        else
        {
            return null;
        }
    }

    function leaves_search_count($search, $ownerid)
    {
		// $where = ' Where ownerid='.$ownerid;
        $where = '';

        if(isset($search_array['search'])){
            $where .= ' Where LOWER(leave_type) like "%'.$search_array['search'].'%"';
        }
        
		$sql ='SELECT * FROM lkqou_vbizz_leaves'.
              $where;
        
        $query = $this
                ->db
                ->query($sql);
    
        return $query->num_rows();
    } 

	function dropdown_leaves()
	{
		$this->db->select('*');
		$this->db->from('lkqou_vbizz_leaves');

		$query = $this->db->get();
        
        if($query->num_rows()>0)
        {
            return $query->result(); 
        }
        else
        {
            return null;
        }

	}

	
    function get_leaves()
	{
		//get listing of all user of an owner
		
		$sql = 'SELECT * from lkqou_vbizz_leaves';
		$query = $this->db->query($sql);
		
		if($query->num_rows()>0)
        {
            return $query->result(); 
        }
        else
        {
            return null;
        }
	}

	
    
	
}