<?php
class DesignationModel extends CI_Model
{
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
       
	public function add_designation($data)
	{
		$this->db->insert('lkqou_vbizz_employee_desg',$data);
		return true;
	}

	public function update_designation($id, $ownerid, $data)
	{
		$this->db->where(array('id'=>$id, 'ownerid'=>$ownerid));
		$this->db->update('lkqou_vbizz_employee_desg', $data);
		return true;
	}
	public function get_designation($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get('lkqou_vbizz_employee_desg');
		return $query->result();
	}

	public function delete_designations($ids){
		$this->db->where_in('id', $ids);
		$this->db->delete('lkqou_vbizz_employee_desg');
		return true;
	}

	

	function all_designations_count()
    {   
        $query = $this
                ->db
                ->get('lkqou_vbizz_employee_desg');
    
        return $query->num_rows();  

    }
    
    function all_designations($limit,$start,$col,$dir)
    {   

		$this->db->select('*');
		$this->db->from('lkqou_vbizz_employee_desg');
		$this->db->order_by($col,$dir);
		$this->db->limit($limit, $start);

		$query = $this->db->get();
        
        if($query->num_rows()>0)
        {
            return $query->result(); 
        }
        else
        {
            return null;
        }
        
    }
   
    function designations_search($limit,$start,$search_array,$col,$dir, $ownerid)
    {
        $where = ' Where ownerid='.$ownerid;

        if(isset($search_array['search'])){
            $where .= ' and LOWER(title) like "%'.$search_array['search'].'%"';
        }
        
        if(isset($search_array['filter_status'])){
            $where .= ' and published ='.$search_array['filter_status'];
        }
		$sql ='SELECT * FROM lkqou_vbizz_employee_desg'.
              $where.' Order by '.$col.' '.$dir.
			  ' Limit '.$limit.' Offset '.$start;
        
        $query = $this
                ->db
                ->query($sql);
    
        
        if($query->num_rows()>0)
        {
            return $query->result(); 
        }
        else
        {
            return null;
        }
    }

    function designations_search_count($search, $ownerid)
    {
		$where = ' Where ownerid='.$ownerid;

        if(isset($search_array['search'])){
            $where .= ' and LOWER(title) like "%'.$search_array['search'].'%"';
        }
        
        if(isset($search_array['filter_status'])){
            $where .= ' and published ='.$search_array['filter_status'];
        }
		$sql ='SELECT * FROM lkqou_vbizz_employee_desg'.
              $where;
        
        $query = $this
                ->db
                ->query($sql);
    
        return $query->num_rows();
    } 

	function dropdown_designations()
	{
		$this->db->select('*');
		$this->db->from('lkqou_vbizz_employee_desg');

		$query = $this->db->get();
        
        if($query->num_rows()>0)
        {
            return $query->result(); 
        }
        else
        {
            return null;
        }

	}

	
    function get_designations()
	{
		//get listing of all user of an owner
		
		$sql = 'SELECT * from lkqou_vbizz_employee_desg WHERE published=1 ';
		$query = $this->db->query($sql);
		
		if($query->num_rows()>0)
        {
            return $query->result(); 
        }
        else
        {
            return null;
        }
	}

    function update_designation_status($id, $status){
        $data = array('published'=>$status);
        $this->db->where('id', $id);
        if($this->db->update('lkqou_vbizz_employee_desg', $data)){
            return true;
        }else{
            return false;
        }
    }

	
    
	
}