<?php
class DepartmentModel extends CI_Model
{
	function __construct() {
		parent::__construct();
		$this->load->database();
	}
       
	public function add_department($data)
	{
		$this->db->insert('lkqou_vbizz_employee_dept',$data);
		return true;
	}

	public function update_department($id, $ownerid, $data)
	{
		$this->db->where(array('id'=>$id, 'ownerid'=>$ownerid));
		$this->db->update('lkqou_vbizz_employee_dept', $data);
		return true;
	}
	public function get_department($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get('lkqou_vbizz_employee_dept');
		return $query->result();
	}

	public function delete_departments($ids){
		$this->db->where_in('id', $ids);
		$this->db->delete('lkqou_vbizz_employee_dept');
		return true;
	}

	

	function all_departments_count()
    {   
        $query = $this
                ->db
                ->get('lkqou_vbizz_employee_dept');
    
        return $query->num_rows();  

    }
    
    function all_departments($limit,$start,$col,$dir)
    {   

		$this->db->select('*');
		$this->db->from('lkqou_vbizz_employee_dept');
		$this->db->order_by($col,$dir);
		$this->db->limit($limit, $start);

		$query = $this->db->get();
        
        if($query->num_rows()>0)
        {
            return $query->result(); 
        }
        else
        {
            return null;
        }
        
    }
   
    function departments_search($limit,$start,$search_array,$col,$dir, $ownerid)
    {
        $where = ' Where ownerid='.$ownerid;

        if(isset($search_array['search'])){
            $where .= ' and LOWER(name) like "%'.$search_array['search'].'%"';
        }
        
        if(isset($search_array['filter_status'])){
            $where .= ' and published ='.$search_array['filter_status'];
        }
		$sql ='SELECT * FROM lkqou_vbizz_employee_dept'.
              $where.' Order by '.$col.' '.$dir.
			  ' Limit '.$limit.' Offset '.$start;
        
        $query = $this
                ->db
                ->query($sql);
    
        
        if($query->num_rows()>0)
        {
            return $query->result(); 
        }
        else
        {
            return null;
        }
    }

    function departments_search_count($search, $ownerid)
    {
		$where = ' Where ownerid='.$ownerid;

        if(isset($search_array['search'])){
            $where .= ' and LOWER(name) like "%'.$search_array['search'].'%"';
        }
        
        if(isset($search_array['filter_status'])){
            $where .= ' and published ='.$search_array['filter_status'];
        }
		$sql ='SELECT * FROM lkqou_vbizz_employee_dept'.
              $where;
        
        $query = $this
                ->db
                ->query($sql);
    
        return $query->num_rows();
    } 

	function dropdown_departments()
	{
		$this->db->select('*');
		$this->db->from('lkqou_vbizz_employee_dept');

		$query = $this->db->get();
        
        if($query->num_rows()>0)
        {
            return $query->result(); 
        }
        else
        {
            return null;
        }

	}

	
    function get_departments()
	{
		//get listing of all user of an owner
		
		$sql = 'SELECT * from lkqou_vbizz_employee_dept WHERE published=1 ';
		$query = $this->db->query($sql);
		
		if($query->num_rows()>0)
        {
            return $query->result(); 
        }
        else
        {
            return null;
        }
	}

    function update_department_status($id, $status){
        $data = array('published'=>$status);
        $this->db->where('id', $id);
        if($this->db->update('lkqou_vbizz_employee_dept', $data)){
            return true;
        }else{
            return false;
        }
    }

	
    
	
}