<?php
/**
 * @abstract Classe pour generer des �tiquettes et d'y appliquer un modele / gabarit
 * @author    Ludovic Riaudel
 * @copyright 2006-2010 Ludovic Riaudel - lriaudel@gmail.com
 * @link http://cab.madvic.net/
 * @license http://www.gnu.org/copyleft/lesser.html LGPL
 * @version   1.3
 */

 abstract class label extends tcpdf{
	
	/**
	 * Acces au fichier de configuration (par defaut : label.xml)
	 *
	 * @var string $path . $filename
	 */
	protected $labelSizes = "";
        
	/**
	 * id de l'etiquette proveneant du fichier de parametrage
	 *
	 * @var string
	 */
	protected $idLabel;

	/**
	 * Nom de l'etiquette proveneant du fichier de parametrage
	 *
	 * @var string
	 */
	protected $labelName;

	/**
	 * Description de l'etiquette proveneant du fichier de parametrage
	 *
	 * @var string
	 */
	protected $labelDescription;

	/**
	 * Marque de l'etiquette proveneant du fichier de parametrage
	 *
	 * @var string
	 */
	protected $labelBrand;

	/**
	 * Fournisseur de l'etiquette proveneant du fichier de parametrage
	 *
	 * @var string
	 */
	protected $labelSupplier;

	/**
	 * Largeur de l'etiquette proveneant du fichier de parametrage
	 *
	 * @var string
	 */
	protected $labelWidth;

	/**
	 * Hauteur de l'etiquette proveneant du fichier de parametrage
	 *
	 * @var string
	 */
	protected $labelHeight;

	/**
	 * Marge de l'etiquette proveneant du fichier de parametrage
	 *
	 * @var string
	 */
	protected $labelMargin;

	/**
	 * Format de la planche d'etiquette proveneant du fichier de parametrage (voir type de format de la classe TCPDF (A3, A4, A5, etc..)
	 *
	 * @var string
	 */
	protected $sheetFormat;
        protected $sheetFormatName;

	/**
	 * Orientation de la planche d'etiquette proveneant du fichier de parametrage (voir type de format de la classe TCPDF
	 * 'P' : Portrait
	 * 'L' : Paysage (landscape)
	 *
	 * @var string
	 */
	protected $sheetOrientation;

	/**
	 * Affiche ou non la bordure de l'etiquette
	 *
	 * @var boolean
	 */
	public $border;

	/**
	 * Couleur de la bordure de l'etiquette
	 *
	 * @var string
	 */
	protected $borderColor;

	/**
	 * Epaisseur de la bordure de l'etiquette
	 *
	 * @var string
	 */
	protected $borderWidth;

	/**
	 * Nombre de colonnes d'etiquettes de la planche
	 *
	 * @var integer
	 */
	protected $labelSheetCols = '';
	
	/**
	 * Nombre de lignes d'etiquettes de la planche
	 *
	 * @var integer
	 */
	protected $labelSheetRows;
	
	/**
	 * Marge superieur de la planche d'etiquettes 
	 *
	 * @var integer
	 */
	protected $labelSheetTopMargin;
	
	/**
	 * Marge gauche de la planche d'etiquettes 
	 *
	 * @var integer
	 */
	protected $labelSheetLeftMargin;

	/**
	 * Tableau des informations a passer au template
	 *
	 * @var array
	 */
	protected $data;
	
	/**
	 * Nombre de lignes d'etiquette a produire (Variable calcul�e)
	 *
	 * @var integer
	 */
	private $nb_rows;

	/**
	 * Nombre de pages d'etiquette a produire (Variable calcul�e)
	 *
	 * @var integer
	 */
	private $nb_pages;

	/**
	 * Marge horizontale entre les �tiquettes (Variable calcul�e)
	 *
	 * @var integer
	 */
	private $h_Marge;

	/**
	 * Marge verticale entre les �tiquettes	(Variable calcul�e)
	 *
	 * @var integer
	 */
	private $v_Marge;

	/**
	 * Constructeur de la classe label
	 *
	 *
	 * @param integer $label_id		id de l'etiquette dans le fichier de configuration
	 * @param integer $data			Tableau de donn�es pour la r�alisation du gabarit. Chaque entr�e dans le tableau correspond � une �tiquette (nombre d'�tiquettes = count($data) ).
	 * @param integer $pathConfig	Chemin vers le r�pertoire ou est situ� le fichier de param�trage label.xml (avec le "/" � la fin).
	 * @param integer $configFile	Nom du fichier de param�trage (Par d�faut : "label.xml" )
	 * @param integer $border		Affiche ou non les traits de s�paration de chaque �tiquette (peux servir au d�coupage papier) (Par d�faut : false).
	 */
	function __construct($label_id, $data, $labelSizes, $border = false){

		$this->labelSizes = $labelSizes;
                
		// Affectation d'un ID �tiquette
                $this->data = $data;
                $this->loadLabelConfig($label_id);
		$this->border = $border;
                

		// Appel du constructeur parent TCPDF
		tcpdf::__construct($this->sheetOrientation , PDF_UNIT, $this->labelSheetFormat , true);

		$this->ctrlLabelConfig();
		
		// margin
		$this->SetMargins($this->labelMargin, $this->labelMargin);
		$this->SetCellPadding(0);
	}


	/**
	 * Sortie erreur
	 *
	 *
	 * @access private
	 * @param $string or $array	Message d'erreur ou tableau d'erreurs
	 */
	private function exitLabel($error){
	
		print "<pre style='background:#faebd7;margin:20px;'>";
		echo "<h2>Error :</h2>";
		print_r($error);
		print '</pre>';
		die();

	}// end function exit

	/**
	 * Charge le fichier de configuration dans les attribut de la classe
	 *
	 *
	 * @access private
	 * @param integer $label_id		id de l'etiquette dans le fichier de configuration
	 */
	private function loadLabelConfig($label_id){
		
            
		if (!isset($label_id) || $label_id==""){
			$this->exitLabel('Selected label size is not found.');
		}
		
		if ($this->labelSizes) {
			$labelXml = $this->labelSizes;
		} else {
			$this->exitLabel('Label sizes not found.');
		} 
		
                
		
		
                                $this->labelWidth = floatval($labelXml->width);
				$this->labelHeight = floatval($labelXml->height);
                                if(intval($labelXml->rows) * $this->labelHeight > intval($labelXml->cols) * $this->labelWidth)
                                    $this->sheetOrientation = "P";
                                else
                                    $this->sheetOrientation = "L";
                                $this->labelSheetFormat = array(intval($labelXml->rows) * $this->labelHeight, intval($labelXml->cols) * $this->labelWidth);
                                $this->labelSheetFormatName = "";
				$this->labelMargin = intval($labelXml->margin);
				$this->labelSheetCols = intval($labelXml->cols);
                                $this->labelSheetRows = intval($labelXml->rows);
                                //$this->labelSheetTopMargin = strval($label->sheet->margins->topmargin);
                                //$this->labelSheetLeftMargin = strval($label->sheet->margins->leftmargin);
                                $this->borderColor = '#000000';
                                $this->borderWidth = 0.1;
				
				return;
		
	}// End of function loadLabelConfig

	/**
	 * Controle si les donnees de la planche soient logique (largeur etiquette < largeur planche, etc..)
	 *
	 *
	 * @access private
	 */
	private function ctrlLabelConfig(){

		$error = '';
                
                if($this->labelSheetFormatName != "DYN")
                {
		if ( ceil($this->getPageWidth()*10000)  < ceil(( ($this->labelSheetCols * $this->labelWidth) + $this->labelSheetLeftMargin)*10000) ){
			$this->exitLabel("<b>Erreur Fichier Config (".$this->configFile.")</b> : La sommes des &eacute;tiquettes en largeur (".$this->labelSheetCols." x ".$this->labelWidth.") + ".$this->labelSheetLeftMargin.") est sup&eacute;rieur &agrave; la largeur du format de la page (".$this->getPageWidth().") en ".$this->sheetOrientation.".");
		}

		if ( ceil($this->getPageHeight()*10000)  < ceil(( ($this->labelSheetRows * $this->labelHeight) + $this->labelSheetTopMargin)*10000) ){
			$this->exitLabel("<b>Erreur Fichier Config (".$this->configFile.")</b> : La sommes des &eacute;tiquettes en hauteur (".$this->labelSheetRows." x ".$this->labelHeight.") + ".$this->labelSheetTopMargin.") est sup&eacute;rieur &agrave; la hauteur du format de la page (".$this->getPageHeight().") en ".$this->sheetOrientation.".");
		}
                }

	} // End of function ctrlLabelConfig

	/**
	 * Affecte les param�tres d'affichages a l'objet TCPDF
	 * (non utilise / en attente)
	 *
	 * @access private
	 */
	private function Affichage(){
		$lg = Array();
		$lg['a_meta_charset'] = "ISO-8859-1";
		$lg['a_meta_dir'] = "ltr";
		$lg['a_meta_language'] = "en";
		//set some language-dependent strings
		$this->setLanguageArray($lg); 
	}

	/**
	 * Initialisation des donn�es pour la cr�ation des �tiquettes et des pages PDF
	 * Appel � la boucle de creation d'etiquette
	 *
	 *
	 * @access public
	 */
	public function AddLabel(){
	
		/* Test
			$nb_el = 0;
			for ($i =0; $i < count($this->data) ; $i++){
				$nb_el += $this->data[$i]["qteEtiq"];
			}
			echo $nb_el;
		*/
		// Nombre d'elements a afficher
		$nb_el = count($this->data);

		// Nombre de lignes
		$this->nb_rows = ceil($nb_el / $this->labelSheetCols);
		
		// Nombre de page
                if($this->labelSheetFormatName=="DYN"){$this->nb_pages =1;}
                else {$this->nb_pages = ceil($this->nb_rows / $this->labelSheetRows);}
		// Calcul du nombre horizontaux d'espaces entre �lements
		if ($this->labelSheetCols <= 1){ $nb_space = 1; } else { $nb_space  = $this->labelSheetCols - 1; }
			// Marge horizontale entre les �lements
			// (Largeur page - (nb colonnes * largeur �tiquette) - (2 x marge de gauche) ) / (nb colonnes - 1)
		if($this->labelSheetFormatName=="DYN")
                    $this->h_Marge =$this->labelSheetLeftMargin;
                else                  
                    $this->h_Marge = ($this->getPageWidth() -  ($this->labelSheetCols * $this->labelWidth) - (2 * $this->labelSheetLeftMargin) ) / $nb_space;
                
		
		// Calcul du nombre d'espaces verticaux entre �lements
		if ($this->nb_rows <= 1){ $nb_space = 1;  } else{   $nb_space  = $this->nb_rows - 1; }
			// Marge verticale entre les �tiquettes
		
                $this->v_Marge = ($this->getPageHeight() -  ($this->labelSheetRows * $this->labelHeight) - (2 * $this->labelSheetTopMargin) ) / $nb_space;
                
//                if($this->labelSheetFormatName=="DYN"){
//                    $this->v_Marge = $this->labelSheetTopMargin;
//                }
//                else{
//                    $this->v_Marge = ($this->getPageHeight() -  ($this->labelSheetRows * $this->labelHeight) - (2 * $this->labelSheetTopMargin) ) / $nb_space;
//                }
                    
                
		
		// Option d'affichage
		//$this->Affichage();

		// Lance le positionnement du template
		$this->posLoop();

	}//fin fonction

	/**
	 * Surcharge de la methode Addpage de l'objet TCPDF
	 *
	 *
	 * @access public
	 */
	public function AddPage_old(){
	
		$this->SetMargins($this->labelMargin, $this->labelMargin);
		$this->SetCellPadding(0);
		tcpdf::AddPage();
		
	}
        
        public function AddPage($orientation = '', $format = '', $keepmargins = false, $tocpage = false){
	
		$this->SetMargins($this->labelMargin, $this->labelMargin);
		$this->SetCellPadding(0);
		tcpdf::AddPage();
		
	}

	/**
	 * Methode de positionnement des etiquettes et du template
	 *
	 *
	 * @access private
	 */
	private function posLoop(){
			
		// Compteur element
		$n=0;
		
		//echo "nb lignes : ".$this->nb_rows." - nb pages : ".$this->nb_pages."<br/>";
		
		// BOUCLE PAGES
		for ($k=0; $k < $this->nb_pages; $k++){
			$this->AddPage(); // fonction d'heritage
			$x = 0;
			$y = 0;
			// Marge sup�rieur
	
					// Boucle pour les lignes
					for ($j=0; $j< $this->labelSheetRows; $j++){
 
							// ligne de l'image x hauteur + marge page + marge etiquette
							$y = $this->labelSheetTopMargin + ( $j * $this->labelHeight) + ($j * $this->v_Marge);
	
							// Boucle pour les cellules
							for ( $i=0 ; $i< $this->labelSheetCols; $i++ ){

								// colonne de l'image x largeur + marge page + marge etiquette	
								$x = $this->labelSheetLeftMargin+ ( $i  * $this->labelWidth) + ($i * $this->h_Marge);
								
								// Si on ne depasse pas le nombre d'elements
								if ($n < count($this->data)) {
									
                                                                    
                                                                    
									// Si on affiche une bordure
									if($this->border && !is_null( $this->data[$n])){
                                                                            
                                                                            
                                                                            
										//$this->borderColor = '#FF0000';
										$color_array = $this->convertHTMLColorToDec($this->borderColor);
                                                                                
										$borderstyle = array('width' => $this->borderWidth, 'cap' => 'butt', 'join' => 'miter', 'dash' => '', 'color' => array($color_array['R'], $color_array['G'], $color_array['B']));
                                                                                
										$this->Rect($x, $y, $this->labelWidth, $this->labelHeight, "D", array('all'=>$borderstyle ) ); 
									}
									
									// Si des informations sont dans le tableau
									if ( !is_null( $this->data[$n]) ){
										// Application du template
									
                                                                            $this->template($x, $y, $this->data[$n]);
									}
									
								}
								$n++;
								
							} // Fin boucle cellule	
	 
					} // Fin boucle ligne   
	
		} // Fin Boucle pages
	
	} // fin fonction posLoop

	/**
	 * Methode a surcharger afin de designer son etiquette
	 * Voir les exemples sur http://www.tecnick.com/public/code/cp_dpage.php?aiocp_dp=tcpdf_examples
	 *
	 * @param integer $x 			Coordonnee des abscisses de l'etiquette en cours. Permet d'utiliser cette variable pour calculer les objets a positionner
	 * @param integer $y 			Coordonnee des ordonnees de l'etiquette en cours. Permet d'utiliser cette variable pour calculer les objets a positionner
	 * @param integer $dataPrint	Tableau des informations permettant la creation d'un modele.
	 * @access abstract 
	 */
	abstract function template($x, $y, $dataPrint);


	public function Output($name='',$dest=''){
		tcpdf::Output($name, $dest);
	}

}//End of class labels

?>