<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

require_once dirname(__FILE__) . '/tcpdf/tcpdf.php';

class Pdf extends TCPDF
{
    function __construct()
    {
        parent::__construct();
        
    }
    
    //Page header
    public function Header() {
        
        if ($this->header_xobjid === false) {
            // start a new XObject Template
            $this->header_xobjid = $this->startTemplate($this->w, $this->tMargin);
             
            $headerfont = $this->getHeaderFont();
            $headerdata = $this->getHeaderData();
            $this->y = $this->header_margin;
            if ($this->rtl) {
                $this->x = $this->w - $this->original_rMargin;
            } else {
                $this->x = $this->original_lMargin;
            }
            if (($headerdata['logo']) AND ($headerdata['logo'] != K_BLANK_IMAGE)) {
                $headerdata = $this->getHeaderData();
                $imgdata = ($headerdata['logo']);
                //$this->setXY(0,5);
                $this->Image($headerdata['logo'], '', '', $headerdata['logo_width']);
            } 
            
            $cell_height = round(($this->cell_height_ratio * $headerfont[2]) / $this->k, 2);
            // set starting margin for text data cell
            if ($this->getRTL()) {
                $header_x = $this->original_rMargin + ($headerdata['logo_width'] * 1.1);
            } else {
                $header_x = $this->original_lMargin + ($headerdata['logo_width'] * 1.1);
            }
            $cw = $this->w - $this->original_lMargin - $this->original_rMargin - ($headerdata['logo_width'] * 1.1);
            $this->SetTextColorArray($this->header_text_color);
            // header title
            $this->SetFont($headerfont[0], 'B', $headerfont[2] + 2);
            $this->SetX($header_x);
            $pieces = explode("#", $headerdata['title']);
            $this->Cell($cw, $cell_height, $pieces[0], 0, 1, '', 0, '', 0);
            $this->SetFont('helvetica', 'B', 18);
            $this->Cell(200, $cell_height, $pieces[1], 0, false, 'R', 0, '', 0, false, 'M', 'M');
            // header string
            $this->SetFont($headerfont[0], $headerfont[1], $headerfont[2]-2);
            $this->SetX($header_x);
            $this->MultiCell($cw, $cell_height, $headerdata['string'], 0, '', 0, 1, '', '', true, 0, false, true, 0, 'T', false);
            // print an ending header line
            $this->SetLineStyle(array('width' => 0.85 / $this->k, 'cap' => 'butt', 'join' => 'miter', 'dash' => 0, 'color' => $headerdata['line_color']));
            //$this->SetY((2.835 / $this->k) + max($imgy, $this->y));
            if ($this->rtl) {
                $this->SetX($this->original_rMargin);
            } else {
                $this->SetX($this->original_lMargin);
            }
            $this->Cell(($this->w - $this->original_lMargin - $this->original_rMargin), 0, '', 'T', 0, 'C');
            $this->endTemplate();
        }
        // print header template
        $x = 0;
        $dx = 0;
        if (!$this->header_xobj_autoreset AND $this->booklet AND (($this->page % 2) == 0)) {
            // adjust margins for booklet mode
            $dx = ($this->original_lMargin - $this->original_rMargin);
        }
        if ($this->rtl) {
            $x = $this->w + $dx;
        } else {
            $x = 0 + $dx;
        }
        
        
        $this->printTemplate($this->header_xobjid, $x, 0, 0, 0, '', '', false);
        if ($this->header_xobj_autoreset) {
            // reset header xobject template at each page
            $this->header_xobjid = -1;
        }
        
    }

	// Page footer
	public function Footer() {
		// Position at 15 mm from bottom
		
		// Set font
		// Page number
            
            $this->SetFont('helvetica', '', 10);
            $headerdata = $this->getHeaderData();
            $pieces = explode("#", $headerdata['title']);
            $this->SetX($this->original_rMargin+10);
            $this->SetY(-25);
            $this->Cell(40, 10, "Customer Signature", 0, 1, 'R', 0, '', 0);
            //$this->SetX(200);
            $this->SetY(-25);
            $this->Cell(170, 10, "For ".$pieces[0], 0, 1, 'R', 0, '', 0);
            //$this->SetX($this->original_rMargin*-1);
            
            //$this->Cell(150, 10, $pieces[0], 0, false, 'R', 0, '', 0, false, 'M', 'M');
            $this->SetY(-15);
            $this->SetFont('helvetica', 'I', 8);
            $this->Cell(0, 10, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 0, false, 'R', 0, '', 0, false, 'T', 'M');
	}
}

?>
