<?php
    // Created By John.
    if (!defined('BASEPATH')) exit('No direct script access allowed');   
    Class Formatslist {
        var $locales = array();
        function __construct() {
            $this->CI =& get_instance();
            $this->setConstantVariable();
        }
        // Define constant variable
        function setConstantVariable(){
            /* define constants */
            if(!defined('FORMATINTEGER') || !defined('FORMATDOUBLE') || !defined('FORMATCURRENCY') || !defined('FORMATPERCENT') || !defined('FORMATDATE') || !defined('FORMATTIME') || !defined('FORMATDATETIME')){
                $this->CI->load->model('settings/Companyinfo_model');
                $localinfo  =   $this->CI->Companyinfo_model->getlocaleinfo();
                define('FORMATINTEGER',$localinfo->FORMATINTEGER);
                define('FORMATDOUBLE',$localinfo->FORMATDOUBLE);
                define('FORMATCURRENCY',$localinfo->FORMATCURRENCY);
                define('FORMATPERCENT',$localinfo->FORMATPERCENT);
                define('FORMATDATE',$localinfo->FORMATDATE);
                define('FORMATTIME',$localinfo->FORMATTIME);
                define('FORMATDATETIME',$localinfo->FORMATDATETIME);
            }
        }
        
        
        // Format Date
        function dateFormat($date=''){
            $result =   date(FORMATDATE,strtotime($date ?? ''));
            return $result;
        }
        // Format Time
        function timeFormat($date=''){
            $result =   date(FORMATTIME,strtotime($date ?? ''));
            return $result;
        }
        // Format DateTime
        function datetimeFormat($date=''){
            $result =   date(FORMATDATETIME,strtotime($date ?? ''));
            return $result;
        }
        
        // Format Integrer Number
        function formatIntegerNumber($number){
            $hashpos    =   strpos(FORMATINTEGER,'#');
            #Filter Hash value
            if($hashpos){
                $constArray =   explode("#",FORMATINTEGER);
                $const1 =  $constArray[0];
                $const2 =  $constArray[1];
            } else {
                $const2 =  FORMATINTEGER;
            }
            $zeropos    =   strpos($const2,'0');
            $commapos   =   strpos($const2,',');
            if($zeropos==0) $number =   str_pad($number, 10, '0', STR_PAD_LEFT); // leading zero upto 10 digit numbers
            if(!is_numeric($number)) $number=0;
            if($commapos) $result =   number_format($number,0,'',','); // comma seperated integer value
            return $result;
        }
        // Format Integrer Number with hash value.
        function formatIntegerWithHash($number){
            $hashpos    =   strpos(FORMATINTEGER,'#');
            #Filter Hash value
            if($hashpos){
                $constArray =   explode("#",FORMATINTEGER);
                $const1 =  $constArray[0];
                $const2 =  $constArray[1];
            } else {
                $const2 =  FORMATINTEGER;
            }
            $zeropos    =   strpos($const2,'0');
            $commapos   =   strpos($const2,',');
            if($zeropos==0) $number =   str_pad($number, 10, '0', STR_PAD_LEFT); // leading zero upto 10 digit numbers
            if(!is_numeric($number)) $number=0;
            if($commapos) $result =   number_format($number,0,'',','); // comma seperated integer value
            //return $const1." ".$result;
            $retunrVal='';
            if(isset($const1))
                $retunrVal=$const1." ";
            if(isset($result))
                $retunrVal.=$result;
            return $retunrVal;
        }
        
        // Format Double Number
        function formatDoubleNumber($number){
            $hashpos    =   strpos(FORMATDOUBLE,'#');
            $zeropos    =   strpos(FORMATDOUBLE,'0');
            $commapos   =   strpos(FORMATDOUBLE,',');
            $dotpos     =   strpos(FORMATDOUBLE,'.');
            $floatpos   =   0;
            $decimalpoint   =   '';
            $separator      =   '';
            #Filter Hash value
            if($hashpos){
                $constArray =   explode("#",FORMATDOUBLE);
                $const1 =  $constArray[0];
                $const2 =  $constArray[1];
            } else {
                $const2 =  FORMATDOUBLE;
            }
            
            // format double number with dot.
            if($dotpos) {
                $decArr     =   explode('.',$const2);
                $floatpos   =   strlen($decArr[1]);
                $decimalpoint='.';
                // format double number with dot and comma
                if($commapos)   $separator=',';
            }else if($commapos){
                // format double number with comma
                $decArr     =   explode(',',$const2);
                $floatpos   =   strlen($decArr[1]);
                $decimalpoint=',';
            }else{
                $floatpos       =   0;
                $decimalpoint   =   '.';
                $separator      =   ',';
            }
            if($zeropos==0) $number =   str_pad($number, 10, '0', STR_PAD_LEFT); // leading zero upto 10 digit numbers
            if(!is_numeric($number)) $number=0;
            $result =   number_format($number,$floatpos,$decimalpoint,$separator);
            return $result;
        }
        // Format Double Number with hash value
        function formatDoubleWithHash($number){
            $hashpos    =   strpos(FORMATDOUBLE,'#');
            $zeropos    =   strpos(FORMATDOUBLE,'0');
            $commapos   =   strpos(FORMATDOUBLE,',');
            $dotpos     =   strpos(FORMATDOUBLE,'.');
            $floatpos   =   0;
            $decimalpoint   =   '';
            $separator      =   '';
            #Filter Hash value
            if($hashpos){
                $constArray =   explode("#",FORMATDOUBLE);
                $const1 =  $constArray[0];
                $const2 =  $constArray[1];
            } else {
                $const2 =  FORMATDOUBLE;
            }
            
            // format double number with dot.
            if($dotpos) {
                $decArr     =   explode('.',$const2);
                $floatpos   =   strlen($decArr[1]);
                $decimalpoint='.';
                // format double number with dot and comma
                if($commapos)   $separator=',';
            }else if($commapos){
                // format double number with comma
                $decArr     =   explode(',',$const2);
                $floatpos   =   strlen($decArr[1]);
                $decimalpoint=',';
            }else{
                $floatpos       =   0;
                $decimalpoint   =   '.';
                $separator      =   ',';
            }
            if($zeropos==0) $number =   str_pad($number, 10, '0', STR_PAD_LEFT); // leading zero upto 10 digit numbers
            if(!is_numeric($number)) $number=0;
            $result =   number_format($number,$floatpos,$decimalpoint,$separator);
            //return $const1." ".$result;
            $retunrVal='';
            if(isset($const1))
                $retunrVal=$const1." ";
            if(isset($result))
                $retunrVal.=$result;
            return $retunrVal;
        }
        // Format Currency
        function formatCurrency($number){
            $hashpos    =   strpos(FORMATCURRENCY,'#');
            $zeropos    =   strpos(FORMATCURRENCY,'0');
            $commapos   =   strpos(FORMATCURRENCY,',');
            $dotpos     =   strpos(FORMATCURRENCY,'.');
            $floatpos   =   0;
            $decimalpoint   =   '';
            $separator      =   '';
            #Filter Hash value
            if($hashpos){
                $constArray =   explode("#",FORMATCURRENCY);
                $const1 =  $constArray[0];
                $const2 =  $constArray[1];
            } else {
                $const2 =  FORMATCURRENCY;
            }
            // format double number with dot.
            if($dotpos) {
                $decArr     =   explode('.',$const2);
                $floatpos   =   strlen($decArr[1]);
                $decimalpoint='.';
                // format double number with dot and comma
                if($commapos)   $separator=',';
            }else if($commapos){
                // format double number with comma
                $decArr     =   explode(',',$const2);
                $floatpos   =   strlen($decArr[1]);
                $decimalpoint=',';
            }else{
                $floatpos       =   0;
                $decimalpoint   =   '.';
                $separator      =   ',';
            }
            if($zeropos==0) $number =   str_pad($number, 10, '0', STR_PAD_LEFT); // leading zero upto 10 digit numbers
            if(!is_numeric($number)) $number=0;
            $result =   number_format($number,$floatpos,$decimalpoint,$separator);
            return $result;
        }
        
        // Format Currency with Hash value
        function formatCurrencywithHash($number){
            $hashpos    =   strpos(FORMATCURRENCY,'#');
            $zeropos    =   strpos(FORMATCURRENCY,'0');
            $commapos   =   strpos(FORMATCURRENCY,',');
            $dotpos     =   strpos(FORMATCURRENCY,'.');
            $floatpos   =   0;
            $decimalpoint   =   '';
            $separator      =   '';
            #Filter Hash value
            if($hashpos){
                $constArray =   explode("#",FORMATCURRENCY);
                $const1 =  $constArray[0];
                $const2 =  $constArray[1];
            } else {
                $const2 =  FORMATCURRENCY;
            }
            // format double number with dot.
            if($dotpos) {
                $decArr     =   explode('.',$const2);
                $floatpos   =   strlen($decArr[1]);
                $decimalpoint='.';
                // format double number with dot and comma
                if($commapos)   $separator=',';
            }else if($commapos){
                // format double number with comma
                $decArr     =   explode(',',$const2);
                $floatpos   =   strlen($decArr[1]);
                $decimalpoint=',';
            }else{
                $floatpos       =   0;
                $decimalpoint   =   '.';
                $separator      =   ',';
            }
            if($zeropos==0) $number =   str_pad($number, 10, '0', STR_PAD_LEFT); // leading zero upto 10 digit numbers
            if(!is_numeric($number)) $number=0;
            $result =   number_format($number,$floatpos,$decimalpoint,$separator);
            $retunrVal='';
            if(isset($const1))
                $retunrVal=$const1." ";
            if(isset($result))
                $retunrVal.=$result;
            return $retunrVal;
        }
        
        // Format Percentage
        function formatPercentage($number){
            $hashpos    =   strpos(FORMATPERCENT,'#');
            $zeropos    =   strpos(FORMATPERCENT,'0');
            $commapos   =   strpos(FORMATPERCENT,',');
            $dotpos     =   strpos(FORMATPERCENT,'.');
            $floatpos   =   0;
            $decimalpoint   =   '';
            $separator      =   '';
            #Filter Hash value
            if($hashpos){
                $constArray =   explode("#",FORMATPERCENT);
                $const1 =  $constArray[0];
                $const2 =  $constArray[1];
            } else {
                $const2 =  FORMATPERCENT;
            }
            
            // format double number with dot.
            if($dotpos) {
                $decArr     =   explode('.',$const2);
                $floatpos   =   strlen($decArr[1]);
                $decimalpoint='.';
                // format double number with dot and comma
                if($commapos)   $separator=',';
            }else{
                $floatpos       =   0;
                $decimalpoint   =   '.';
                $separator      =   ',';
            }
            if($zeropos==0) $number =   str_pad($number, 10, '0', STR_PAD_LEFT); // leading zero upto 10 digit numbers
            if(!is_numeric($number)) $number=0;
            $result =   number_format($number,$floatpos,$decimalpoint,$separator);
            return $result;
        }
        // Format Percentage with hash value
        function formatPercentageWithHash($number){
            $hashpos    =   strpos(FORMATPERCENT,'#');
            $zeropos    =   strpos(FORMATPERCENT,'0');
            $commapos   =   strpos(FORMATPERCENT,',');
            $dotpos     =   strpos(FORMATPERCENT,'.');
            $floatpos   =   0;
            $decimalpoint   =   '';
            $separator      =   '';
            #Filter Hash value
            if($hashpos){
                $constArray =   explode("#",FORMATPERCENT);
                $const1 =  $constArray[0];
                $const2 =  $constArray[1];
            } else {
                $const2 =  FORMATPERCENT;
            }
            
            // format double number with dot.
            if($dotpos) {
                $decArr     =   explode('.',$const2);
                $floatpos   =   strlen($decArr[1]);
                $decimalpoint='.';
                // format double number with dot and comma
                if($commapos)   $separator=',';
            }else{
                $floatpos       =   0;
                $decimalpoint   =   '.';
                $separator      =   ',';
            }
            if($zeropos==0) $number =   str_pad($number, 10, '0', STR_PAD_LEFT); // leading zero upto 10 digit numbers
            if(!is_numeric($number)) $number=0;
            $result =   number_format($number,$floatpos,$decimalpoint,$separator);
            //return $const1." ".$result;
            $retunrVal='';
            if(isset($const1))
                $retunrVal=$const1." ";
            if(isset($result))
                $retunrVal.=$result;
            return $retunrVal;
        }
        // Decimalpoints set for Currency
        function getCurrencyDecimalPonts(){
            $dotpos     =   strpos(FORMATCURRENCY,'.');
            if($dotpos) {
                $decArr     =   explode('.',FORMATCURRENCY);
                $floatpos   =   strlen($decArr[1]);
                return $floatpos;
            }else{
                return 2;
            }
        }
    }