<?php
class MY_Controller extends CI_Controller {
    function __construct() {
        parent::__construct();
        if(!isset($this->session->userid)) {
            redirect(base_url().'login');
        }
        //date_default_timezone_set('Europe/Dublin');
		$this->set_timezone();
        if($this->session->lang != "" && $this->session->langfolder != ""){
            $this->lang->load($this->session->lang, $this->session->langfolder);
        }
        $vars['mainmenu'] = $this->getmainmenu();
         $this->load->model('common');
        $this->load->vars($vars);
        if ($this->session->userdata('logged_in')) {
            if(!$this->hasPermission()) {
                redirect(base_url().'info/accessdenied');
            }
        }
    }

    private function hasPermission() {
        $this->load->model('settings/users_model');
        $permissions=  $this->users_model->getpermissions($this->session->userdata('user'));
        if(stripos($permissions, $this->router->class. ';')) return true;
        else return false;
    }

    public function getmainmenu() {
        $this->load->model('settings/resources_model');
        return $this->resources_model->getmenu();
    }
    
    public function set_timezone() {
        $this->db->select('TIMEZONE');
        $this->db->from('CONFIGURATION');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            date_default_timezone_set($query->row()->TIMEZONE);
        } else {
            return false;
        }
    }
    
}