<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Warehouses extends MY_Controller {

    function __construct() {
        parent::__construct();
    }
    public function index() {
       
        $data['template'] = 'settings/warehouse_overview';
        $this->load->view('template',$data);
    }
    //WAREHOUSE AUTO COMPLETE
    function getwarehouseautocomplete() {
        $term = $this->input->post('term', TRUE);
        $this->load->model('settings/warehouse_model');
        $rows = $this->warehouse_model->getwarehouseautocomplete($term);
        
        $keywords = array();
        foreach ($rows as $row)
            array_push($keywords, $row->NAME);
        echo json_encode($keywords);
    }

    public function getwarehouses() {
        $data['data'] = $this->common->getAll('LOCATIONS');
        echo json_encode($data);
    }
    

    public function addwarehouses() {
        $id = $this->input->post('id');
        if($id == ''){
            $data = array(   
                'ID' => uniqid(),        
                'NAME' => $this->input->post('name'),
                'ADDRESS' => $this->input->post('address')
            );
            $existdata = $this->common->existdata('LOCATIONS',$data);
            // print_r( $existdata);die();
            if(!empty($existdata)) {
              $this->session->set_flashdata('success_msg', 'The record is already exist');
            } else {
               $this->common->insert('LOCATIONS',$data);
               $this->session->set_flashdata('success_msg', 'The record is added successfuly.');
            }
        } else {
            $data = array(
                'NAME' => $this->input->post('name'),
                'ADDRESS' => $this->input->post('address')
            );
            $where = array('ID' => $id);
            $this->session->set_flashdata('success_msg', 'The record has been updated successfuly.');
            $this->common->update('LOCATIONS',$where,$data);
        }
        redirect('settings/warehouses');
 
    }
    
      public function editwarehouses($id) {
        $where = array('ID' => $id,);
        $data = $this->common->getWhere('LOCATIONS',$where);

        echo json_encode($data);
 
    }
       public function deletewarehouses($id) {

        $where = array('ID' => $id);  
        $this->common->delete('LOCATIONS',$where);
        $this->session->set_flashdata('success_msg', 'The record has been deleted successfuly.');
        redirect('settings/warehouses');
 
    }

}