<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');
class Resources extends MY_Controller {
    function __construct() {
        parent::__construct();
    }
    public function index() {
        $this->session->unset_userdata('editresourceID');
        $data['template'] = 'settings/resources_view';
        $this->load->view('template', $data);
    }
    //GET RESOURCES
    public function getresources() {
        $data['data'] = $this->common->customquery('SELECT ID, NAME,(CASE WHEN RESTYPE=0 THEN "Text" WHEN RESTYPE=1 THEN "Image" WHEN RESTYPE=2 THEN "Binary" ELSE "Text" END) RESTYPETEXT,RESTYPE FROM RESOURCES');
        echo json_encode($data);
    }
    public function editrec($id){
        $this->session->set_userdata(array('editresourceID'  => $id));
        redirect("settings/resources/add");
    }
    public function add() {       
        if(!empty($_POST)){
            $data =  array(
                'NAME' => $this->input->post('name'),
                'RESTYPE' => $this->input->post('restype')
            );
            if($this->input->post('restype')==1){
                $image  =   explode(',',$this->input->post('content'));
                $data['CONTENT']    =   base64_decode($image[1]);
            }else{
                $data['CONTENT']    =   $this->input->post('content');
            }
            if($this->input->post('id')==''){
                $data['ID']    = uniqid();
                $this->resources_model->add($data);
            }else{
                $id    = $this->input->post('id');
                $this->resources_model->update($id, $data);
            }
            redirect('settings/resources');
        } else {
            $id = $this->session->userdata('editresourceID');
            if($id){
                $data["editdata"] =   $this->resources_model->resourceInfo($id);
                $data['template'] = 'settings/resources_add';
                $this->load->view('template',$data);
            }else{
                $data["editdata"] =   '';
                $data['template'] = 'settings/resources_add';
                $this->load->view('template',$data);
            }
        }
    }
    public function deleteresources($id) {

        $where = array(
            'ID' => $id);
        $this->common->delete('RESOURCES',
                $where);
        $this->session->set_flashdata('success_msg',
                'The record has been deleted successfuly.');
        redirect('settings/resources');
    }
    //RESOURCES AUTOCOMPLETE
    function getresourcesautocomplete() {
        $term = $this->input->post('term',
                TRUE);
        $this->load->model('settings/resources_model');
        $rows = $this->resources_model->getresourcesautocomplete($term);
        $keywords = array();
        foreach ($rows as $row) array_push($keywords,
                    $row->NAME);
        echo json_encode($keywords);
    }
    public function showImage($id) {
        $this->load->model('settings/resources_model');
        $logo = $this->resources_model->getResourceImage($id);
        header('Content-Type: image/png');
        echo $logo[0]->CONTENT;
    }
    function record() {
        $this->load->model('settings/resources_model');
        $oper = $this->input->post('oper');
        $id = uniqid();
        /* if($oper=='del')
          {
          $id = $this->input->post('id');
          if($id)
          {
          $this->resources_model->delete($id);
          $fdata = array('msgt' => 'S', 'msg' => 'Resource deleted successfully.');
          $this->session->set_flashdata($fdata);
          redirect(site_url() . 'settings/resources');
          }
          else {
          $fdata = array('msgt' => 'E', 'msg' => 'Cannot delete Resource.');
          $this->session->set_flashdata($fdata);
          redirect(site_url() . 'settings/resources');
          }
          } */
        $this->load->library('form_validation');
        $this->form_validation->set_rules('NAME',
                'NAME',
                'trim|required');
        $this->form_validation->set_rules('CONTENT',
                'CONTENT',
                'trim|required');

        if ($this->form_validation->run() == true) {
            $form_data = array(
                'ID' => $id,
                'NAME' => $this->input->post('NAME'),
                'RESTYPE' => 0,
                'CONTENT' => htmlspecialchars_decode($this->input->post('CONTENT'))
            );

            if ($oper == 'add') {
                if ($this->resources_model->add($form_data) == TRUE) {
                    $fdata = array(
                        'msgt' => 'S',
                        'msg' => 'Role added successfully.');
                    $this->session->set_flashdata($fdata);
                    return true;
                }
            } elseif ($oper == 'edit') {
                $id = $this->input->post('ID');
                if ($id) {

                    $this->resources_model->update($id,
                            $form_data);
                }
            }
        }
    }
    function delresource() {
        $this->load->model('settings/resources_model');
        if ($this->uri->segment(4)) {

            $this->resources_model->delete($this->uri->segment(4));
            $fdata = array(
                'msgt' => 'S',
                'msg' => 'Resource deleted successfully.');
            $this->session->set_flashdata($fdata);
            redirect(site_url() . 'settings/resources');
        } else {
            $fdata = array(
                'msgt' => 'E',
                'msg' => 'Cannot delete Resource.');
            $this->session->set_flashdata($fdata);

            redirect(site_url() . 'settings/resources');
        }
    }
}