<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');
class Reports extends MY_Controller {
    function __construct() {
        parent::__construct();
        $this->load->model('settings/reports_model');
    }
    public function index() {
        $this->session->unset_userdata('editreportID');
        $data['template'] = 'settings/reportsettings_view';
        $this->load->view('template', $data);
    }
    //GET REPORTS
    public function getreportsettings() {
        $data['data'] = $this->common->customquery('SELECT ID, REPORTNAME FROM REPORTS');
        echo json_encode($data);
    }
    public function editreport($id){
        $this->session->set_userdata(array('editreportID'  => $id));
        redirect("settings/reports/add");
    }
    public function add() {
        if(!empty($_POST)){
            $data =  array(
                'REPORTNAME' => $this->input->post('name')
            );
            $data['CONTENT']    =   $this->input->post('content');
            if($this->input->post('id')==''){
                $this->reports_model->add($data);
            }else{
                $id    = $this->input->post('id');
                $this->reports_model->update($id, $data);
            }
            redirect('settings/reports');
        } else {
            $id = $this->session->userdata('editreportID');
            if($id){
                $data["editdata"] =   $this->reports_model->reportInfo($id);
                $data['template'] = 'settings/report_add';
                $this->load->view('template',$data);
            }else{
                $data["editdata"] =   '';
                $data['template'] = 'settings/report_add';
                $this->load->view('template',$data);
            }
        }
    }
    public function deletereports($id) {

        $where = array( 'ID' => $id);
        $this->common->delete('REPORTS', $where);
        $this->session->set_flashdata('success_msg', 'The record has been deleted successfuly.');
        redirect('settings/reports');
    }
       
    function delreport() {
        $this->load->model('settings/reports_model');
        if ($this->uri->segment(4)) {

            $this->reports_model->delete($this->uri->segment(4));
            $fdata = array(
                'msgt' => 'S',
                'msg' => 'Report deleted successfully.');
            $this->session->set_flashdata($fdata);
            redirect(site_url() . 'settings/reports');
        } else {
            $fdata = array(
                'msgt' => 'E',
                'msg' => 'Cannot delete Report.');
            $this->session->set_flashdata($fdata);

            redirect(site_url() . 'settings/reports');
        }
    }
    public function querybulder() {
        $data['tablenames'] = $this->common->customquery("SELECT table_name FROM information_schema.tables where table_schema='SALECULATOR'");
        $data['executedquery'] = "SELECT * FROM [TABLENAME] WHERE 1";
        $data['template'] = 'settings/querybuilder';
        $this->load->view('template',$data);
    }
    
    public function queryexecute() {
        if(isset($_POST["query"]) && $_POST["query"]) {
            $data['executedqueryrec']   =   $this->common->customquery($_POST["query"]);
            $data['executedqueryrec']   =   json_decode(json_encode($data['executedqueryrec']), True);
            $data['executedquery']      =   $_POST["query"];
        } else {
            $data['executedquery'] = "SELECT * FROM [TABLENAME] WHERE 1";
        }
        $data['tablenames'] = $this->common->customquery("SELECT table_name FROM information_schema.tables where table_schema='SALECULATOR'");
        $data['template'] = 'settings/querybuilder';
        $this->load->view('template',$data);
    }
    
}