<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Tables extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('pos/menu_model');
    }

    public function index() {

        $this->load->model('pos/tables_model');
        $data['status'] = $this->tables_model->getticketStatus();

        $data['floors'] = $this->tables_model->getfloors();
        if ($data['floors']) {
            $data['places'] = $this->tables_model->getplaces();
        }

        $this->load->view('pos/tables_view', $data);
    }

    function select() {

        $doc = $this->readTicketXML($this->uri->segment(4));


        if ($doc) {
            $data['tableID'] = $this->uri->segment(4);
            $data['items'] = $this->menu_model->getticketItems($data);
            $data['tableToken'] = $this->menu_model->getsharedticketName($this->uri->segment(4));
            $data['tableName'] = $this->menu_model->gettableNameBid($this->uri->segment(4));
            $data['categories'] = $this->menu_model->getcategories();
            if ($data['categories']) {
                $data['products'] = $this->menu_model->getproducts();
            }
            $this->load->view('pos/menu_view', $data);
        } else {

            $this->createTicketXML($this->uri->segment(4));
            $data['tableID'] = $this->uri->segment(4);
            $data['items'] = $this->menu_model->getticketItems($data);
            $data['tableToken'] = $this->menu_model->getsharedticketName($this->uri->segment(4));
            $data['tableName'] = $this->menu_model->gettableNameBid($this->uri->segment(4));
            $data['categories'] = $this->menu_model->getcategories();
            if ($data['categories']) {
                $data['products'] = $this->menu_model->getproducts();
            }
            $this->load->view('pos/menu_view', $data);
        }
    }

    function createTicketXML($tableid) {

        $doc = new DOMDocument('1.0', 'ISO-8859-1');
        $xml->preserveWhiteSpace = false;
        $doc->formatOutput = true;

//TICKET START

        $root = $doc->appendChild($doc->createElement('com.posics.pos.ticket.TicketInfo'));

//STRING  TICKETS.ID
        $id = uniqid();
        $string = $root->appendChild($doc->createElement('string'));
        $string->appendChild($doc->createTextNode($id));

//INT  TICKETS.TICKETTYPE
        $int = $root->appendChild($doc->createElement('int'));
        $int->appendChild($doc->createTextNode(0));
       
//INT  TICKETS.TICKETID
        $int = $root->appendChild($doc->createElement('int'));
        $int->appendChild($doc->createTextNode(0));
       
//NULL  CUSTOMER
        $null = $root->appendChild($doc->createElement('null'));
        $null->appendChild($doc->createTextNode());
       
//NULL  SUPPLIER
        $null = $root->appendChild($doc->createElement('null'));
        $null->appendChild($doc->createTextNode());

//DATE  
        $token = mt_rand(100, 999);
        $date = $root->appendChild($doc->createElement('date'));
        $date->appendChild($doc->createTextNode(date("Y-m-d H:i:s.$token")));


//PROPERTIES
        $properties = $root->appendChild($doc->createElement('properties'));
        $properties->appendChild($doc->createTextNode());

//LIST
        $list = $root->appendChild($doc->createElement('list'));
        $list->appendChild($doc->createTextNode());


//TICKET END
        $xmldata = $doc->saveXML();
//        var_dump($user);
        $sharedticket = array(
            'ID' => $tableid,
            'NAME' => "(" . date('H:i') . ' ' . $token . " )",
            'CONTENT' => $xmldata
        );
        $this->load->model('pos/tables_model');
        $this->tables_model->addsharedticket($sharedticket);
    }

    function readTicketXML($tableid) {

        $this->load->model('pos/tables_model');
        $result = $this->tables_model->getsharedticket($tableid);

        if ($result) {
            return simplexml_load_string($result[0]['CONTENT']);
        }
        else
            return null;
    }

    public function logout() {
        $this->session->sess_destroy();
        redirect(site_url() . 'settings/login');
    }

}
