<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Menu extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('pos/menu_model');
    }

    public function index() {
        $data = array(
            'tableID' => $this->uri->segment(4)
        );
        $data['items'] = $this->menu_model->getticketItems($data);
        $data['tableToken'] = $this->menu_model->getsharedticketName($this->uri->segment(4));
        $data['tableName'] = $this->menu_model->gettableNameBid($this->uri->segment(4));
        $data['categories'] = $this->menu_model->getcategories();
        if ($data['categories']) {
            $data['products'] = $this->menu_model->getproducts();
        }
        $this->load->view('pos/menu_view', $data);
    }

    public function additem() {
        $pid = $this->uri->segment(5);
        $productDetails = $this->menu_model->getprodDetailsBid($this->uri->segment(5));
        $taxDetails = $this->menu_model->gettaxDetailsBid($productDetails[0]['TAXCAT']);

//ADD ITEM TO XML        
        $xml = new DOMDocument('1.0', 'ISO-8859-1');
        $xml->preserveWhiteSpace = false;
        $xml->formatOutput = true;
        $xml->loadXml($this->readTicketXML($this->uri->segment(4)));
        $xml->saveXML();
//SELECT ROOT TAG TO APPEND ITEM
        $Xpath = new DOMXPath($xml);
        $TicketInfoDetails = $Xpath->query('/com.posics.pos.ticket.TicketInfo');
        $TicketLineInfoDetails = $Xpath->query('/com.posics.pos.ticket.TicketInfo/list/com.posics.pos.ticket.TicketLineInfo');
        $results = $Xpath->query('/com.posics.pos.ticket.TicketInfo/list');
        $baz_node_of_xml = $results->item(0);


//CREATE NEW TAGS 
        $TicketLineInfo = $xml->createElement('com.posics.pos.ticket.TicketLineInfo');
        $m__sTicket = $xml->createElement('m__sTicket');
        $m__iLine = $xml->createElement('m__iLine');
        $multiply = $xml->createElement('multiply');
        $price = $xml->createElement('price');
        $saleprice = $xml->createElement('saleprice');

        $tax = $xml->createElement('tax');
        $id = $xml->createElement('id');
        $name = $xml->createElement('name');
        $taxcategoryid = $xml->createElement('taxcategoryid');
        $rate = $xml->createElement('rate');
        $cascade = $xml->createElement('cascade');
        $order = $xml->createElement('order');



        $attributes = $xml->createElement('attributes');
        $property = $xml->createElement('property');
        $node = $attributes->appendChild($property);
        $node->setAttribute('name', 'product.com');
        $iscom = $productDetails[0]['ISCOM'];
        if ($iscom == 0)
            $iscom = 'false';
        else
            $iscom = 'true';
        $node->setAttribute('value', $iscom);
        $property2 = $xml->createElement('property');
        $node2 = $attributes->appendChild($property2);
        $node2->setAttribute('name', 'product.taxcategoryid');
        $node2->setAttribute('value', $productDetails[0]['TAXCAT']);
        $property3 = $xml->createElement('property');
        $node3 = $attributes->appendChild($property3);
        $node3->setAttribute('name', 'product.price');
        $node3->setAttribute('value', $productDetails[0]['PRICESELL']);
        $property4 = $xml->createElement('property');
        $node4 = $attributes->appendChild($property4);
        $node4->setAttribute('name', 'product.categoryid');
        $node4->setAttribute('value', $productDetails[0]['CATEGORY']);
        $property5 = $xml->createElement('property');
        $node5 = $attributes->appendChild($property5);
        $node5->setAttribute('name', 'product.name');
        $node5->setAttribute('value', $productDetails[0]['NAME']);
        $property6 = $xml->createElement('property');
        $node6 = $attributes->appendChild($property6);
        $node6->setAttribute('name', 'sendstatus');
        $node6->setAttribute('value', 'No');
        $property7 = $xml->createElement('property');
        $node7 = $attributes->appendChild($property7);
        $node7->setAttribute('name', 'kotnum');
        $node7->setAttribute('value', 'KOT1');



        $productid = $xml->createElement('productid');



        //CREATE TEXT CONTENT FOR EACH TAGS &#xA;

        foreach ($TicketInfoDetails as $TID) {
            $string = $TID->getElementsByTagName('string')->item(0)->textContent;
        }
        foreach ($TicketLineInfoDetails as $TLID) {
            $lineNumber = $TLID->getElementsByTagName('m__iLine')->item(0)->textContent;
        }
        if ($lineNumber == '') {
            $lineNumber = 0;
        } else {
            $lineNumber = $lineNumber + 1;
        }

        $m__sTicketID = $xml->createTextNode($string);
        $m__iLineNO = $xml->createTextNode($lineNumber);
        $multiplyNO = $xml->createTextNode(1.0);
        $priceValue = $xml->createTextNode($productDetails[0]['PRICEBUY']);
        $salepriceValue = $xml->createTextNode($productDetails[0]['PRICESELL']);

        $taxID = $xml->createTextNode($taxDetails[0]['ID']);
        $taxName = $xml->createTextNode($taxDetails[0]['NAME']);
        $taxCategoryId = $xml->createTextNode($taxDetails[0]['CATEGORY']);
        $taxRate = $xml->createTextNode($taxDetails[0]['RATE']);
        $cscd = $taxDetails[0]['RATECASCADE'];
        if ($cscd == 0)
            $cscd = 'false';
        else
            $cscd = 'true';
        $taxCascade = $xml->createTextNode($cscd);

        $orderValue = $xml->createTextNode($taxDetails[0]['RATEORDER']);
        $productIDValue = $xml->createTextNode($productDetails[0]['ID']);





//APPEND EACH TAGS TO TICKETINFO       

        $m__sTicket->appendChild($m__sTicketID);
        $TicketLineInfo->appendChild($m__sTicket);

        $m__iLine->appendChild($m__iLineNO);
        $TicketLineInfo->appendChild($m__iLine);

        $multiply->appendChild($multiplyNO);
        $TicketLineInfo->appendChild($multiply);

        $price->appendChild($priceValue);
        $TicketLineInfo->appendChild($price);

        $saleprice->appendChild($salepriceValue);
        $TicketLineInfo->appendChild($saleprice);

        //APPEND EACH TAGS TO TAX       

        $id->appendChild($taxID);
        $tax->appendChild($id);

        $name->appendChild($taxName);
        $tax->appendChild($name);

        $taxcategoryid->appendChild($taxCategoryId);
        $tax->appendChild($taxcategoryid);

        $rate->appendChild($taxRate);
        $tax->appendChild($rate);

        $cascade->appendChild($taxCascade);
        $tax->appendChild($cascade);


        $productid->appendChild($productIDValue);
        $TicketLineInfo->appendChild($productid);


//APPEND ITEM TAG TO ROOT TAGS
        $baz_node_of_xml->appendChild($TicketLineInfo);
        $TicketLineInfo->appendChild($tax);
        $TicketLineInfo->appendChild($attributes);


        $xmldataitems = $xml->saveXML();

        $updateticket = array(
            'CONTENT' => $xmldataitems
        );



        $this->menu_model->updateitem($this->uri->segment(4), $updateticket);
        $data['tableID'] = $this->uri->segment(4);
        $data['items'] = $this->menu_model->getticketItems($data);
        $data['tableToken'] = $this->menu_model->getsharedticketName($this->uri->segment(4));
        $data['tableName'] = $this->menu_model->gettableNameBid($this->uri->segment(4));
        $data['categories'] = $this->menu_model->getcategories();
        if ($data['categories']) {
            $data['products'] = $this->menu_model->getproducts();
        }
        $this->load->view('pos/menu_view', $data);
    }

    function readTicketXML($tableid) {

        $this->load->model('pos/tables_model');
        $result = $this->tables_model->getsharedticket($tableid);

        if ($result) {
            return $content = $result[0]['CONTENT'];
        }
        else
            return null;
    }

}