<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Supplierpricelist extends MY_Controller {

    function __construct() {
        parent::__construct();
    }

    //TARIFF
    public function index() {
        $this->load->view('settings/header');
        $this->load->view('partner/supplierpricelist_view', null);
        $this->load->view('settings/footer');
    }
    function gettariffautocomplete() {
        $term = $this->input->post('term', TRUE);
        $this->load->model('inventory/tariff_model');
        $rows = $this->tariff_model->gettariffautocomplete($term);
        $keywords = array();
        foreach ($rows as $row)
            array_push($keywords, $row->NAME);
        echo json_encode($keywords);
    }
    //GET TARIFF
    function getsupplierpricelist() {
        $this->load->model('partner/supplierpricelist_model');
        echo $this->supplierpricelist_model->getsupplierpricelist();
    }
    //ADD  TARIFF
    public function addsupplierprice() {
        $this->load->library('form_validation');
        $this->load->model('partner/supplierpricelist_model');
        $this->form_validation->set_rules('listname', 'listname', 'trim|required');
        $this->form_validation->set_rules('suppliers', 'suppliers', 'trim|required');
        $this->form_validation->set_rules('validfrom', 'validfrom', 'trim|required');
        if ($this->input->post('addsupplierprice')) {
            if ($this->form_validation->run() == true) {
                $lineid = md5(time());
                $supplier = $this->input->post('suppliers');
                $this->load->model('partner/supplierpricelist_model');
                $this->supplierpricelist_model->addsupplierprice(array(
                    'ID' => $lineid,
                    'PRICELISTNAME' => $this->input->post('listname'),
                    'SUPPLIER' => $this->_getSUPPLIERIDbN($supplier),
                    'VALIDFROM' => $this->input->post('validfrom'),
                    'ACTIVE' => ($this->input->post('active')) ? 1 : 0
                ));
                $plist = unserialize($this->input->post('lineitems'));
                    foreach ($plist as $line) {
                        $this->supplierpricelist_model->addsupplierprice_prod(array(
                            'PRICELIST' => $lineid,
                            'PRODUCT' => $this->_getMIDbN($line['material']),
                            'LISTPRICE' => $line['price']
                        ));
                    }
                $fdata = array('msgt' => 'S', 'msg' => 'Record inserted successfully.');
                $this->session->set_flashdata($fdata);
                redirect(site_url() . 'partner/supplierpricelist');
            } else {
                $this->load->view('settings/header');
                $this->load->view('partner/supplierpricelist_add_view');
                $this->load->view('settings/footer');
            }
        } else {
            $this->load->view('settings/header');
            $this->load->view('partner/supplierpricelist_add_view');
            $this->load->view('settings/footer');
        }
    }
    private function _getMIDbN($name) {
        $this->load->model('inventory/products_model');
        return $this->products_model->getmidbn($name);
    }
    // GET SUPPLIER ID BY NAME
    private function _getSUPPLIERIDbN($name) {
       $this->load->model('partner/suppliers_model');
       return $this->suppliers_model->getsupplieridbn($name);
    }
    //EDIT TARIFF
    public function editsupplierprice() {
        $this->load->model('partner/supplierpricelist_model');
        $this->load->library('form_validation');
        $this->form_validation->set_rules('listname', 'listname', 'trim|required');
        $this->form_validation->set_rules('suppliers', 'suppliers', 'trim|required');
        $this->form_validation->set_rules('validfrom', 'validfrom', 'trim|required');
        if ($this->input->post('update')) {
            $id = $this->uri->segment(4);
            $supplier = $this->input->post('suppliers');
            $this->supplierpricelist_model->updatesupplierprice(
                    $id,
                    $this->input->post('listname'),
                    $this->_getSUPPLIERIDbN($supplier),
                    $this->input->post('validfrom'),
                    ($this->input->post('active')) ? 1 : 0
            );
            $this->supplierpricelist_model->deleteLines($id);
            $plist = unserialize($this->input->post('lineitems'));
                 foreach ($plist as $line) {
                    $this->supplierpricelist_model->addsupplierprice_prod(array(
                        'PRICELIST' => $id,
                        'PRODUCT' => $this->_getMIDbN($line['MATERIAL']),
                        'LISTPRICE' => $line['PRICE']
                ));
            }
            $fdata = array('msgt' => 'S', 'msg' => 'Record updated successfully.');
            $this->session->set_flashdata($fdata);
            redirect(site_url() . 'partner/supplierpricelist');
        } else {
           $this->load->model('partner/suppliers_model');
            $data['pricelist'] = $this->supplierpricelist_model->getGroupById($this->uri->segment(4));
            $data['supplier'] = $this->suppliers_model->getSupplierById($data['pricelist'][0]->SUPPLIER);
            $lines = $this->supplierpricelist_model->getlines($id = $this->uri->segment(4));
            $data['lines'] = json_encode($lines);
            $this->load->view('settings/header');
            $this->load->view('partner/supplierpricelist_edit_view', $data);
            $this->load->view('settings/footer');
        }
    }

    //DELETE TARIFF
    public function deletepricelist() {
        if ($this->uri->segment(4)) {
            $this->load->model('partner/supplierpricelist_model');
            $this->supplierpricelist_model->deleteLines($this->uri->segment(4));
            $this->supplierpricelist_model->deletepricelist($this->uri->segment(4));
            $fdata = array('msgt' => 'S', 'msg' => 'Record deleted successfully.');
            $this->session->set_flashdata($fdata);
            redirect(site_url() . 'partner/supplierpricelist');
        } else
            redirect(site_url() . 'partner/supplierpricelist');
    }
}