<?php
//working
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Supplier extends MY_Controller {

    function __construct() {
        parent::__construct();
       $this->load->model('partner/suppliers_model');
    }
//GET SUPPLIERS
    public function index() {
          $data['taxcustcat'] = $this->common->getAll('TAXCUSTCATEGORIES');
       $data['template'] = 'partner/suppliers_ovw';
       $this->load->view('template',$data);
    }
    //GET SUPPLIERS
    function getsuppliers() {
    
        $data['data'] = $this->suppliers_model->getsuppliers();
        echo json_encode($data);
    }

    public function addsupplier() {
        $id = $this->input->post('id');
        $data = array( 
            'TAXID' => $this->input->post('TAXID'),
            'NAME' => $this->input->post('name'),
            'SEARCHKEY' => $this->input->post('searchkey'),
             'CARD' => $this->input->post('card'),
            'MAXDEBT' => ($this->input->post('maxdebt')) ? $this->input->post('maxdebt') : 0,
            'TAXCATEGORY' => ($this->input->post('taxcategory')) ? $this->input->post('taxcategory') : NULL,
             'ADDRESS' => ($this->input->post('address')) ? $this->input->post('address') : NULL,
             'PHONE' => ($this->input->post('phone')) ? $this->input->post('phone') : NULL,
            'EMAIL' => ($this->input->post('email')) ? $this->input->post('email') : NULL,
              'FAX' => ($this->input->post('fax')) ? $this->input->post('fax') : NULL,
            'NOTES' => ($this->input->post('notes')) ? $this->input->post('notes') : NULL,
            'VISIBLE' => 1
        );
       if($id == '')
       { 
           $existdata = $this->common->existdata('SUPPLIERS',$data);
          // print_r( $existdata);die();
           if(!empty($existdata))
           {
           
             $this->session->set_flashdata('success_msg', 'The record is already exist');
           }
           else
           {
            $data['ID'] =uniqid();
           $this->common->insert('SUPPLIERS',$data);
           $this->session->set_flashdata('success_msg', 'The record is added successfuly.');
           }
        
       }
        else
       {
          $where = array('ID' => $id);
          $this->session->set_flashdata('success_msg', 'The record has been updated successfuly.');
          $this->common->update('SUPPLIERS',$where,$data);
       }
        redirect('partner/supplier');
 
    }
    
      public function editsupplier($id) {
        $where = array('ID' => $id,);
        $data = $this->common->getWhere('SUPPLIERS',$where);
        echo json_encode($data);
 
    }
       public function deletesupplier($id) {

        $where = array('ID' => $id);  
        $this->common->delete('SUPPLIERS',$where);
        $this->session->set_flashdata('success_msg', 'The record has been deleted successfuly.');
        redirect('partner/supplier');
 
    }

    
    //SUPPLIER  AUTOCOMPLETE
    function getsupplierautocomplete() {
        $term = $this->input->post('term', TRUE);
        $rows = $this->suppliers_model->getsupplierautocomplete($term);
        $keywords = array();
        foreach ($rows as $row)
            array_push($keywords, $row->NAME);
        echo json_encode($keywords);
    }
    //SEARCHKEY AUTOCOMPLETE
    function getsearchkeyautocomplete() {
        $term = $this->input->post('term', TRUE);
        $this->load->model('partner/suppliers_model');
        $rows = $this->suppliers_model->getsearchkeyautocomplete($term);
        $keywords = array();
        foreach ($rows as $row)
            array_push($keywords, $row->SEARCHKEY);
        echo json_encode($keywords);
    }
    //CARD AUTOCOMPLETE
     function getsuppliercardautocomplete() {
        $term = $this->input->post('term', TRUE);
        $this->load->model('partner/suppliers_model');
        $rows = $this->suppliers_model->getsuppliercardautocomplete($term);
        $keywords = array();
        foreach ($rows as $row)
            array_push($keywords, $row->CARD);
        echo json_encode($keywords);
    }
    //category auto complete
    function getsuppliercategoriesautocomplete() {
        $term = $this->input->post('term', TRUE);
        $this->load->model('partner/suppliers_model');
        $rows = $this->suppliers_model->getsuppliercategoriesautocomplete($term);
        $keywords = array();
        foreach ($rows as $row)
            array_push($keywords, $row->TAXCATEGORY);
        echo json_encode($keywords);
    }
    //SUPPLIER CATEGORY COMBO
    private function _getSupplierCategories($id = NULL) {
        $this->load->model('partner/suppliers_model');
        $catarr = $this->suppliers_model->getSupplierCategories();
        $data = '<option value="">Select</option>';
        for ($i = 0; $i < count($catarr); $i++) {
            if ($id != NULL && $id == $catarr[$i]->ID)
                $data .= "<option selected=\"yes\" value=\"" . $catarr[$i]->ID . "\">" . $catarr[$i]->NAME . "</option>\n";
            else
                $data .= "<option value=\"" . $catarr[$i]->ID . "\">" . $catarr[$i]->NAME . "</option>\n";
        }
        return $data;
    }

    private function getUserID($user) {
        $this->load->model('settings/users_model');
        return $this->users_model->getUserID($user);
    }
     private function getcustcat($name) {
        $this->load->model('partner/suppliers_model');
        return $this->suppliers_model->getcustcat($name);
    }
    function exportcsv()
    {
            $file="suppliers.csv";
            header("Content-Disposition: attachment; filename=" . urlencode($file));
            header("Content-Type: application/force-download");
            header("Content-Type: application/octet-stream");
            header("Content-Type: application/download");
            header("Content-Description: File Transfer");
            header("Content-type: application/csv");
            header("Pragma: no-cache");
            header("Expires: 0");

            $export= $this->input->post('exportdata');
           
            $this->load->helper('download');
            force_download($file, $export);
    }
    //ADD/EDIT/DELETE SUPPLIER  
    function record()
    {   
        $oper = $this->input->post('oper');
        $id = uniqid();
        
        $this->load->model('partner/suppliers_model');
        /*if($oper=='del')
        {
            $id = $this->input->post('id');
            if($id)
            {
                $this->suppliers_model->delete($id);
                $fdata = array('msgt' => 'S', 'msg' => 'Supplier deleted successfully.');
                $this->session->set_flashdata($fdata);
                redirect(site_url() . 'partner/supplier');
            }
            else {
                $fdata = array('msgt' => 'E', 'msg' => 'Cannot delete Supplier.');
                $this->session->set_flashdata($fdata);
                redirect(site_url() . 'partner/supplier');
            }
        }
      else {*/
                $form_data = array(
                        'SEARCHKEY' => $this->input->post('SEARCHKEY'),
                        'NAME' => $this->input->post('NAME'),
                        'CARD' => $this->input->post('CARD'),
                        'MAXDEBT' => ($this->input->post('MAXDEBT')) ? $this->input->post('MAXDEBT') : 0,
                        'VISIBLE' => 1,
                        'TAXCATEGORY' => ($this->input->post('TAXCATID')) ? $this->input->post('TAXCATID') : NULL,
                        'EMAIL' => ($this->input->post('EMAIL')) ? $this->input->post('EMAIL') : NULL,
                        'PHONE' => ($this->input->post('PHONE')) ? $this->input->post('PHONE') : NULL,
                        'FAX' => ($this->input->post('FAX')) ? $this->input->post('FAX') : NULL,
                        'ADDRESS' => ($this->input->post('ADDRESS')) ? $this->input->post('ADDRESS') : NULL,      
                        'NOTES' => ($this->input->post('NOTES')) ? $this->input->post('NOTES') : NULL
                    
            );
            if($oper=='add')
            {
                $form_data['ID']=$id;
                    if ($this->suppliers_model->add($form_data) == TRUE) {
                            $fdata = array('msgt' => 'S', 'msg' => 'Supplier added successfully.');
                            $this->session->set_flashdata($fdata);
                            return true;
                    }
            }
            elseif($oper=='edit')
            {
                    $id = $this->input->post('id');
                    if($id)
                    {
                            $this->suppliers_model->update($id, $form_data);   
                    }       
            }
        
     }
   
}

