<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Stocksummaryitemwise extends MY_Controller {

    function __construct() {
        parent::__construct();
    }

    public function index() {
        $data['location'] = $this->_getLocations();
        $this->load->view('settings/header');
        $this->load->view('inventory/stocksummaryitemwise_view', $data);
        $this->load->view('settings/footer');
    }
    //GET STOCK DIARY
    public function getstocksummaryitemwise() {
        $location = $this->input->post('location');
        $mcategory = $this->input->post('mcategory');
        $products = $this->input->post('products');
        $date = $this->input->post('date');
        $this->load->model('inventory/stocksummaryitemwise_model');
        echo $this->stocksummaryitemwise_model->getstocksummaryitemwise($location, $mcategory, $products, $date);
    }
    //CODE FOR PRINT MATERIAL PLANNING
    public function printcurrentstock() {
        $this->load->helper('dompdf');
        $this->load->helper('file');
        $this->load->model('inventory/openingstock_model');
        $this->load->library('session');
        $location = $this->session->userdata('location');
        $mcategory = $this->session->userdata('mcategory');
        $products = $this->session->userdata('products');
        if ($products) {
            $this->load->model('inventory/products_model');
            $products = $this->products_model->getpidbn($products);
        } else {
            $products = null;
        }
        $data['inventorylines'] = $this->currentinventory_model->getcurrentstockdetailsprint($location,$mcategory,$products);
        $this->load->model('settings/companyinfo_model');
        $data['location'] = $location;
        $data['companyinfo'] = $this->companyinfo_model->getcompanyinfo('0');
          $html = $this->load->view('reports/inventory/currentinventory_print', $data, true);
         //echo $html;
         pdf_create($html, 'STOCKCURRENT', false);
    }

    function setparamsinsessionforprintcurrentstock()
    {
        $location = $this->input->post('location');
        $mcategory = $this->input->post('mcategory');
        $products = $this->input->post('products');
        $this->load->library('session');
        $this->session->set_userdata('location',  $this->input->post('location'));
        $this->session->set_userdata('mcategory',  $this->input->post('mcategory'));
        $this->session->set_userdata('products',  $this->input->post('products'));
       return 1;
    }

    //GET LOCATION LIST
    private function _getLocations($id = NULL) {
        $this->load->model('inventory/products_model');
        $catarr = $this->products_model->getLocations();
        $data = '<option value="">Select</option>';
        for ($i = 0; $i < count($catarr); $i++) {
            if ($id != NULL && $id == $catarr[$i]->ID)
                $data .= "<option id=\"option_custom\" selected=\"yes\" value=\"" . $catarr[$i]->ID . "\">" . $catarr[$i]->NAME . "</option>\n";
            else
                $data .= "<option id=\"option_custom\" value=\"" . $catarr[$i]->ID . "\">" . $catarr[$i]->NAME . "</option>\n";
            }
        return $data;
    }

    function exportcsv()
    {
        $file="stockcummary.csv";
            header("Content-Disposition: attachment; filename=" . urlencode($file));
            header("Content-Type: application/force-download");
            header("Content-Type: application/octet-stream");
            header("Content-Type: application/download");
            header("Content-Description: File Transfer");
            header("Content-type: application/csv");
            header("Pragma: no-cache");
            header("Expires: 0");
        $export= $this->input->post('exportdata');
        $this->load->helper('download');
        force_download($file, $export);
    }
}