<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Reorderlevel extends MY_Controller {

    function __construct() {
        parent::__construct();
    }
    function index() {
        $this->load->model('settings/warehouse_model');
//        $data['locations'] = $this->warehouse_model->getlocationscombo('0');
        $data['categories'] = $this->common->getAll('CATEGORIES');
        $data['locations'] = $this->common->getAll('LOCATIONS');
          $data['template'] = 'inventory/reorderlevel_view';
          $this->load->view('template',$data);
    }

     public function getrecordlevel() {
        $spcategory = $this->input->post('spcategory');
        $this->load->model('inventory/reorderlevel_model');
        //echo $this->reorderlevel_model->getproductsbw($spcategory,$this->input->post('location'));
        $locationsel = $_GET["locationsel"];
        $searchbycategory = $_GET["searchbycategory"];
        $data['data'] = $this->reorderlevel_model->getrecordlevel($locationsel,$searchbycategory);
        // print_r($data['data']);
        echo json_encode($data);
    }
      function inventorybroken() {
        $this->load->model('settings/warehouse_model');
        $data['locations'] = $this->warehouse_model->getlocationscombo('0');
        $this->load->view('settings/header');
        $this->load->view('inventory/inventorybroken_view', $data);
        $this->load->view('settings/footer');
    }
    public function add() {
      
        $data = unserialize($this->input->post('lines'));
        $this->load->model('inventory/products_model');
        $this->load->model('inventory/reorderlevel_model');
        foreach ($data as $line) {
            $pid = $this->products_model->getpidbn($line['PRODUCT']);
            $this->reorderlevel_model->deletereorder(array(
                'LOCATION' => $line['LOCATION'],
                'PRODUCT' => $pid
                    )
            );
            $this->reorderlevel_model->addreorder(array(
                        'LOCATION' => $line['LOCATION'],
                        'PRODUCT' => $pid,
                        'STOCKSECURITY' => $line['MINIMUM'],
                        'STOCKMAXIMUM' => $line['MAXIMUM'])
            );
        }
       
        $this->session->set_flashdata('success_msg', 'Reorder set successfully.');
        redirect('inventory/reorderlevel');
    }
    //GET PRODUCTS BY WAREHOUSE
    public function getproductsbw() {
        $spcategory = $this->input->post('spcategory');
        $this->load->model('inventory/reorderlevel_model');
        //echo $this->reorderlevel_model->getproductsbw($spcategory,$this->input->post('location'));

         $data['data'] = $this->reorderlevel_model->getproductsbw($spcategory,$this->input->post('location'));
          print_r($data['data']);
      //echo json_encode($data);
    }

    
       //GET PRODUCTS BY WAREHOUSE
    public function getproductsbwtoib() {
        $this->load->model('inventory/reorderlevel_model');
        echo $this->reorderlevel_model->getproductsbwtoib($this->input->post('location'));
    }

    public function getqoh() {
        $pname = $this->input->post('product');
        $locid = $this->input->post('location');
        $this->load->model('inventory/stock_model');
        $result = $this->stock_model->getproductcostandqoh($pname, $locid);
        if ($result) {
            $data = '{"uom": "' . $result[0]->UOM . '", "cost": "' . $result[0]->COST . '", "qoh": "' . $result[0]->QOH . '"}';
        } else {
            $data = '{"uom": "", "cost": "0", "qoh": "0"}';
        }
        echo $data;
    }
    
    public function updateminstock() {
        $id                     =   $this->input->post("stid");
        $locationid             =   $this->input->post("locationid");
        $productid              =   $this->input->post("prid");
        $prstockmin             =   $this->input->post("prstockmin");
        $this->db->where('ID', $id);
        $query = $this->db->get('STOCKLEVEL');
        $stockdet               =   $query->row();
        if($stockdet) {
            $data["STOCKSECURITY"]  =   $this->input->post("prstockmin");
            $this->db->where(array('ID'=>$id));
            $this->db->update('STOCKLEVEL', $data);
        } else {
            $data["ID"] = uniqid();
            $data["LOCATION"]       =   $locationid;
            $data["PRODUCT"]        =   $productid;
            $data["STOCKSECURITY"]  =   $prstockmin;
            $data["STOCKMAXIMUM"]   =   0;
            $this->db->insert('STOCKLEVEL', $data);
        }
        echo 'true';
    }
    
    public function updatemaxstock() {
        $id                     =   $this->input->post("stid");
        $locationid             =   $this->input->post("locationid");
        $productid              =   $this->input->post("prid");
        $prstockmax             =   $this->input->post("prstockmax");
        $this->db->where('ID', $id);
        $query = $this->db->get('STOCKLEVEL');
        $stockdet               =   $query->row();
        if($stockdet) {
            $data["STOCKMAXIMUM"]  =   $this->input->post("prstockmax");
            $this->db->where(array('ID'=>$id));
            $this->db->update('STOCKLEVEL', $data);
        } else {
            $data["ID"] = uniqid();
            $data["LOCATION"]       =   $locationid;
            $data["PRODUCT"]        =   $productid;
            $data["STOCKSECURITY"]  =   0;
            $data["STOCKMAXIMUM"]   =   $prstockmax;
            $this->db->insert('STOCKLEVEL', $data);
        }
        echo 'true';
    }
}