<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Productgroups extends MY_Controller {

    function __construct() {
        parent::__construct();
    }

//GET PRODUCT GROUPS
    public function index() {
        $this->load->view('settings/header');
        $this->load->view('inventory/productgroups_view', null);
        $this->load->view('settings/footer');
    }

    //FOR AUTOCOMPLETE TO GET PRODUCTS FROM TABLE
   function getproductgroupsautocomplete() {
        $term = $this->input->post('term', TRUE);
        $this->load->model('inventory/productgroups_model');
        $rows = $this->productgroups_model->getproductgroupsautocomplete($term);
        $keywords = array();
        foreach ($rows as $row)
            array_push($keywords, $row->NAME);
        echo json_encode($keywords);
    }

//GET PRODUCT GROUPS
    function getproductgroups() {
        $this->load->model('inventory/productgroups_model');
        echo $this->productgroups_model->getproductgroups();
    }

    public function viewproductgroups() {
        if (!$this->uri->segment(4) || $this->uri->segment(4) == "")
            redirect(site_url() . 'inventory/productgroups');
        $this->load->model('inventory/productgroups_model');
        $data['productgroups'] = $this->productgroups_model->viewproductgroups($this->uri->segment(4));
        $this->load->view('settings/header');
        $this->load->view('inventory/productgroups_receipt_view', $data);
        $this->load->view('addproduct_view', $data);
        $this->load->view('settings/footer');
    }

    private function _getNames($id = NULL) {
        $this->load->model('inventory/productgroups_model');
        $catarr = $this->productgroups_model->getNames();
        $data = '';
        for ($i = 0; $i < count($catarr); $i++) {
            if ($id != NULL && $id == $catarr[$i]->ID)
                $data .= "<option id=\"option_custom\" selected=\"yes\" value=\"" . $catarr[$i]->ID . "\">" . $catarr[$i]->NAME . "</option>\n";
            else
                $data .= "<option id=\"option_custom\" value=\"" . $catarr[$i]->ID . "\">" . $catarr[$i]->NAME . "</option>\n";
        }
        return $data;
    }

    public function _getNamName($id) {
        $this->load->model('inventory/products_model');
        return $this->products_model->_getNamName($id);
    }

    private function _getPIDbN($name) {
        $this->load->model('inventory/products_model');
        return $this->products_model->getpidbn($name);
    }

    private function _getPNbID($id) {
        $this->load->model('inventory/productgroups_model');
        return $this->productgroups_model->getpnbid($id);
    }

    //ADD PRODUCT GROUP
    public function addproductgroup() {
        $this->load->model('inventory/productgroups_model');
        $this->load->library('form_validation');
        $this->form_validation->set_rules('groupname', 'Group Name', 'trim|required');
        $this->form_validation->set_rules('lineitems', 'Products', 'trim|required');           
        if ($this->input->post('addline')) {
            $this->db->trans_start();
            if ($this->form_validation->run() == true) {
                $id = md5(time());
                $this->productgroups_model->addGroup(array(
                    'ID' => $id,
                    'NAME' => $this->input->post('groupname')
                ));
                $plist = unserialize($this->input->post('lineitems'));
                foreach ($plist as $line) {
                        $this->productgroups_model->addLine(array(
                            'PRODUCTGROUP' => $id,
                            'PRODUCT' => $this->_getPIDbN($line['product'])
                        ));
                        $this->db->trans_complete();
                }
                $fdata = array('msgt' => 'S', 'msg' => 'Record inserted successfully.');
                $this->session->set_flashdata($fdata);
                redirect(site_url() . 'inventory/productgroups');
            } else {
                $this->load->view('settings/header');
                $this->load->view('inventory/productgroup_add_view', $data);
                $this->load->view('settings/footer');
              }
            } else {
                $data['location'] = $this->_getNames();
                $this->load->view('settings/header');
                $this->load->view('inventory/productgroup_add_view', $data);
                $this->load->view('settings/footer');
            }   
    }

//EDIT PRODUCT GROUP
    public function editproductgroup() {
            $this->load->model('inventory/productgroups_model');
            $this->load->library('form_validation');
            $this->form_validation->set_rules('groupname', 'Group Name', 'trim|required');
            $this->form_validation->set_rules('lineitems', 'Products', 'trim|required');
            
             if ($this->input->post('update')) {
                $id = $this->uri->segment(4);
                $this->productgroups_model->updateGroup(
                     $id,
                     $this->input->post('groupname')
                );

                $this->productgroups_model->deleteLines($id);
                $plist = unserialize($this->input->post('lineitems'));
                     foreach ($plist as $line) {
                              $this->productgroups_model->addLine(array(
                                'PRODUCTGROUP' => $id,
                                'PRODUCT' => $this->_getPIDbN($line['PRODUCT'])
                              ));
                     }
                 $fdata = array('msgt' => 'S', 'msg' => 'Record updated successfully.');
                 $this->session->set_flashdata($fdata);
                 redirect(site_url() . 'inventory/productgroups');
              } else {
                 $data['group'] = $this->productgroups_model->getGroupById($this->uri->segment(4));
                 $lines = $this->productgroups_model->getlines($this->uri->segment(4));
                 $data['lines'] = json_encode($lines);
                 $this->load->view('settings/header');
                 $this->load->view('inventory/productgroups_edit_view', $data);
                 $this->load->view('settings/footer');
                 }       
    }

//DELETE PRODUCT GROUP
    public function deleteproductgroup() {
             if ($this->uri->segment(4)) {
                 $this->load->model('inventory/productgroups_model');
                 $p_status = $this->productgroups_model->empty_product($this->uri->segment(4));
                    if ($p_status != TRUE) {
                         $this->productgroups_model->deleteProductgroup($this->uri->segment(4));
                         $fdata = array('msgt' => 'S', 'msg' => 'Record deleted successfully.');
                         $this->session->set_flashdata($fdata);
                         redirect(site_url() . 'inventory/productgroups/');
                     } else {
                         $fdata = array('msgt' => 'E', 'msg' => 'Please remove products from ProductGroup');
                         $this->session->set_flashdata($fdata);
                         redirect(site_url() . 'inventory/productgroups/');
                        }
             } else {
                redirect(site_url() . 'inventory/productgroups');
               }
             }

}
