<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Prodlabel extends MY_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('inventory/prodlabel_model');
    }
   
   /* public function index() {
       
       // $data['fields']=$this->getproductdetails($id);
         $data['template'] = 'inventory/prodlabel_view';
        $this->load->view('template',$data);
    }
*/
    public function label() {
        $id = $this->uri->segment(4);
        $data['productid']=$id;
        $data['fields']=$this->getproductdetails($id);
        $this->load->view('common/header');
        $this->load->view('common/sidebar');
        $this->load->view('inventory/prodlabel_view', $data);
        $this->load->view('common/footer');
    }

    function getproductdetails($id) {

        $result = $this->prodlabel_model->getproductdetails($id);
        $result->PRICESELL = number_format($result->PRICESELL, 2);
        $result->PRICEBUY = number_format($result->PRICEBUY, 2);

        $productxml = simplexml_load_string(htmlspecialchars_decode($result->ATTRIBUTES));
        $formatid = null;
        if ($productxml && $productxml->label && $productxml->label['format']) {
            $formatid = $productxml->label['format'];
        }
        $labelformat = $this->getproductlabelformat($formatid);

        $labelfields = "";

        foreach ($labelformat->children() as $child) {
            $fieldname = '';
            preg_match('~{(.*?)}~', $child, $fieldname);

            if (count($fieldname) > 1) {
                list($pre, $post) = explode($fieldname[0], $child);
                $labelfields .= '"' . $child->getName() . '": "' . $pre . $result->{$fieldname[1]} . $post . '", ';
            } else {
                $labelfields .= '"' . $child->getName() . '": "' . $child . '", ';
            }
        }
        $labelfields = rtrim($labelfields, ", ");
        $labelfields = "{" . $labelfields . "}";
        return $labelfields;
    }

    function getproductlabelformat($formatid) {
        $labelformats = $this->prodlabel_model->getlabelformats();
        if ($formatid != null) {
            foreach ($labelformats->label as $child) {

                if (intval($child['id']) == intval($formatid)) {
                    $labelformat = $child;
                }
            }
        } else {
            $labelformat = $labelformats->label[0];
        }
        return $labelformat;
    }

    function getproductlabelsize($sizeid) {
        $labelsizes = $this->prodlabel_model->getlabelsizes();
        if ($sizeid != null) {
            foreach ($labelsizes->label as $child) {

                if (intval($child['id']) == intval($sizeid)) {
                    $labelsize = $child;
                }
            }
        } else {
            $labelsize = $labelsizes->label[0];
        }
        return $labelsize;
    }

    function printlabel() {
       
        $_POST["product"] = $this->input->post('product');
        
        $pname = $this->input->post('productid');
        $result = $this->prodlabel_model->getproductdetails($pname);

        $this->load->library('label_helper');
        $labelsizes = $this->prodlabel_model->getlabelsizes();
        $productxml = simplexml_load_string(htmlspecialchars_decode($result->ATTRIBUTES));
        $sizeid = null;
        if ($productxml && $productxml->label && $productxml->label['size']) {
            $sizeid = $productxml->label['size'];
        } else {
            $sizeid = 1;
        }
        $labelsize = $this->getproductlabelsize($sizeid);

        $formatid = null;
        if ($productxml && $productxml->label && $productxml->label['format']) {
            $formatid = $productxml->label['format'];
        }
        $labelformat = $this->getproductlabelformat($formatid);

        $data = array();
        $info = array();
        $n=0;
//         echo "<pre>";print_r($_POST);exit;
        foreach ($_POST as $key => $value) {
            if ($key != 'submit' && $key != 'productid') {
                if ($key == 'barcode') {
                    $info[$n]['barcode'] = $value;
                } else {
                    $info[$n]['value'] = $value;
                }
                
                foreach ($labelformat->children() as $child) {
                    foreach ($child->attributes() as $a => $b) {
                        if($child->getName()==$key)
                        {$info[$n][$a] = $b;}
                        
                    }
                }
                $n=$n+1;
            }
        }
        
        
        for ($i = 0; $i < intval($labelsize->rows) * intval($labelsize->cols); $i++) {
            array_push($data, $info);
        }

        
        
        $pdf = new labelTemplate($sizeid, $data, $labelsize, false); //without border
        $pdf->SetCreator(PDF_CREATOR);
        $pdf->SetAuthor("Saleculator");
        $pdf->SetTitle("Product Labels");
        $pdf->SetSubject("Saleculator Product Labels");
        $pdf->SetKeywords("saleculator, label, product, saleculator");
        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);
        // remove default margin
        $pdf->SetHeaderMargin(0);
        $pdf->SetFooterMargin(0);
        $pdf->SetAutoPageBreak(true, 0);
        //set image scale factor
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->Addlabel();
        // Affichage du document dans le navigateur
        ob_clean();
        $pdf->Output("labels.pdf", "I");
    }

    function productautocomplete() {

        $term = $this->input->post('term', TRUE);
        $rows = $this->prodlabel_model->getproductautocomplete($term);
        $keywords = array();
        foreach ($rows as $row)
            array_push($keywords, array(
                'label' => $row->NAME,
                'value' => $row->ID
            ));
        echo json_encode($keywords);
    }

}