<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Materialplanning extends MY_Controller {

    function __construct() {
        parent::__construct();
    }

    function test() {
        $this->load->view('test');
    }

    function index() {
        $this->load->view('settings/header');
        $this->load->view('materialplanning_view', null);
        $this->load->view('settings/footer');
    }

    //COLUNM NAMES
    function getcolumns() {
        $params = $this->uri->segment(4);
        if ($params == 1 || $params == 0) {
            $data = '{"cnames": ["MATERIALREQUEST","REQUIRED ON","LOCATION","PRODUCT","QUANTITY","QOH","UOM","TOTAL","STOCKSECURITY"], "url": "inventory/materialplanning/getlines",
                "colModel": [
            {"name":"MATERIALREQUEST","index":"MATERIALREQUEST","hidden":true, "width":"100", "sorttype":"date", "datefmt":"Y-mm-d"},
            {"name":"REQUIREDON","index":"REQUIREDON", "width":"100", "sorttype":"date", "formatter":"date", "formatoptions": {"newformat":"d-M-Y"}},
            {"name":"LOCATION","index":"LOCATION", "width":"100"},
            {"name":"PRODUCT","index":"PRODUCT", "width":"100"},
            {"name":"QUANTITY","index":"QUANTITY", "width":"100", "align":"center"},
            {"name":"QOH","index":"QOH", "width":"100", "align":"center"},
            {"name":"UOM","index":"UOM", "width":"100"},
            {"name":"TOTAL","index":"TOTAL", "width":"100", "align":"right", "formatter":"currency", "formatoptions": {"thousandsSeparator":","}},
            {"name":"STOCKSECURITY","index":"STOCKSECURITY", "hidden":true,"width":"100", "align":"right"}
            ]}';
         } 
         else if ($params == 2) {
            $data = '{"cnames": ["REQUIRED ON", "CATEGORY","ID","PRODUCT","RQTY","QOH","UOM","POQTY","QTYSTS","TOTAL"], "url": "inventory/materialplanning/getlinesbycategory",
                "colModel": [
            {"name":"REQUIREDON","index":"REQUIREDON", "width":"50", "sorttype":"date", "formatter":"date", "formatoptions": {"newformat":"d-M-Y"}},
            {"name":"CATEGORY","index":"CATEGORY", "width":"70"},
            {"name":"ID","index":"ID", "width":"0"},
            {"name":"PRODUCT","index":"PRODUCT", "width":"100"},
            {"name":"RQTY","index":"APPROVEDQUANTITY", "width":"25"},
            {"name":"QOH","index":"QOH", "width":"25"},
            {"name":"UOM","index":"UOM", "width":"35"},
            {"name":"POQTY","index":"POQTY", "width":"25"},
            {"name":"QTYSTS","index":"QTYSTS", "width":"35"},
            {"name":"TOTAL","index":"TOTAL", "width":"70", "align":"right", "summaryType":"sum", "formatter":"currency", "formatoptions": {"thousandsSeparator":","}}
            ]}';    
          }
          else if ($params == 3) {
            $data = '{"cnames": ["REQUIRED ON","LOCATION","TOTAL"], "url": "inventory/materialplanning/getlinesbylocation",
                "colModel": [
            {"name":"REQUIREDON","index":"REQUIREDON", "width":"100", "sorttype":"date", "formatter":"date", "formatoptions": {"newformat":"d-M-Y"}},
            {"name":"CATEGORY","index":"LOCATIONNAME", "width":"100"},
            {"name":"TOTAL","index":"TOTAL", "width":"100", "align":"right", "formatter":"currency", "formatoptions": {"thousandsSeparator":","}}
            ]}';    
          }
          else {
            $data = '{"cnames": ["MATERIALREQUEST","REQUIREDON","LOCATION","PRODUCT","QUANTITY","QOH","UOM","TOTAL"], "url": "inventory/materialplanning/getlines"}';
          }
        echo $data;
    }

// GET MATERIALREQUESTS BY STANDARD
    function getlines() {
        $this->load->model('inventory/materialplanning_model'); //
        $datefrom = $this->input->post('datefrom');
        $dateto = $this->input->post('dateto');
        $product = $this->input->post('product');
        if ($product) {
            $this->load->model('inventory/products_model');
            $pid = $this->products_model->getpidbn($product);
        } else {
            $pid = null;
        }
        echo $this->materialplanning_model->getlines($datefrom, $dateto, $pid);
    }



//GET MATERIALREQUESTS BY LOCATION
    function getlinesbylocation() {
        $this->load->model('inventory/materialplanning_model'); //
        $datefrom = $this->input->post('datefrom');
        $dateto = $this->input->post('dateto');
        $product = $this->input->post('product');
        if ($product) {
            $this->load->model('inventory/products_model');
            $pid = $this->products_model->getpidbn($product);
        } else {
            $pid = null;
        }
        echo $this->materialplanning_model->getlinesbylocation($datefrom, $dateto, $pid);
    }
    //CODE FOR PRINT MATERIAL PLANNING
    public function printmp() {
        $this->load->helper('dompdf');
        $this->load->helper('file');
        $this->load->model('inventory/materialplanning_model');
        $this->load->library('session');
        $datefrom = $this->session->userdata('datefrom');
        $dateto = $this->session->userdata('dateto');
        $product = $this->session->userdata('product');
        if ($product) {
            $this->load->model('inventory/products_model');
            $product = $this->products_model->getpidbn($product);
        } else {
            $product = null;
        }
        $data['mpclines'] = $this->materialplanning_model->getmplinesbyid($this->uri->segment(4));
        $data['mpclines'] = $this->materialplanning_model->getmplinesbycategory($datefrom,$dateto,$product);
        $this->load->model('settings/companyinfo_model');
        $data['companyinfo'] = $this->companyinfo_model->getcompanyinfo('0');
        $html = $this->load->view('materialplanningcategory_print', $data, true);
         pdf_create($html, 'MATERIALPLANNING', false);
     }
     
     function setparamsinsessionforprintmp()
     {
        $this->load->library('session');
        $this->session->set_userdata('datefrom',  $this->input->post('datefrom'));
        $this->session->set_userdata('dateto',  $this->input->post('dateto'));
        $this->session->set_userdata('product',  $this->input->post('product'));
        return 1;
    }

}
