<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Currentinventory extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('inventory/currentinventory_model');
        $this->load->library('Formatslist');
    }

    public function index() {
        $data['location'] = $this->_getLocations();
        $data['template'] = 'inventory/currentinventory_view';
        $this->load->view('template',$data);
    }
    //GET STOCK DIARY
    public function getcurrentstock() {
        $location = $this->input->post('location');
        $mcategory = $this->input->post('mcategory');
        $products = $this->input->post('products');
        echo $this->currentinventory_model->getcurrentstockdetails($location, $mcategory, $products );
}


    public function getcurrentinventory() {
        $datarec    =   $this->currentinventory_model->getcurrentinventory();
    // coulmn declaration
        $currinventdetails    =   array();
        if($datarec){
            foreach ($datarec as $datarecord){
                array_push($currinventdetails, array(
                    'REFERENCE' => $datarecord["REFERENCE"],
                    'CODE' => $datarecord["CODE"],
                    'CATEGORYNAME' => $datarecord["CATEGORYNAME"],
                    'LOCATION' => $datarecord["LOCATION"],
                    'PRODUCT' => $datarecord["PRODUCT"],
                    'TOTALUNITS' => number_format($datarecord["TOTALUNITS"],3),
                    'UOM' => $datarecord["UOM"],
                    'UNITPRICE' => $this->formatslist->formatCurrencywithHash($datarecord["UNITPRICE"]),
                    'LINETOTAL' => $this->formatslist->formatCurrencywithHash($datarecord["LINETOTAL"]),
                    'STOCKSECURITY' => $datarecord["STOCKSECURITY"],
                    'STOCKMAXIMUM' => $datarecord["STOCKMAXIMUM"],
                ));
            }
            $data['data'] =    $currinventdetails;
        }else{
            $data['data'] =    $currinventdetails;
        }
        echo json_encode($data);
    }



    //PRINT CURRENT INVENTORY
    public function printcurrentstock() {
         $this->load->library('session');
        $product = $this->session->userdata('PRODUCT');
        $productgroups = $this->session->userdata('PRODUCTGROUPS');
        $warehouse = $this->session->userdata('WAREHOUSE');
        $category = $this->session->userdata('CATEGORY');
        $array_items = array('PRODUCT' => '','PRODUCTGROUPS' => '', 'WAREHOUSE' => '', 'CATEGORY' => '');
        $this->session->unset_userdata($array_items);
        //$product='milk';
        $this->load->helper('dompdf');
        $this->load->helper('file');
        $this->load->model('settings/companyinfo_model');      
        $this->load->model('reports/inventory_model');
         $data['companyinfo'] = $this->companyinfo_model->getcompanyinfo('0');
         $data['reportdata']= $this->inventory_model->getinventorylinesbyid($warehouse, $category, $product,$productgroups);
        $this->load->model('reports/report_model');
        $data['columns'] = $this->report_model->getcolumns('INVENTORY');
        $data['reporttitle'] = 'Current Inventory';
        $html = $this->load->view('reports/report_template1_print', $data, true);
        pdf_create($html, 'STOCKCURRENT', false);
        
        
   }

   function setparamsinsessionforprintcurrentstock()
   {
        $location = $this->input->post('location');           
        $mcategory = $this->input->post('mcategory');
        $products = $this->input->post('products');
        $this->load->library('session');
        $this->session->set_userdata('location',  $this->input->post('location'));
        $this->session->set_userdata('mcategory',  $this->input->post('mcategory'));
        $this->session->set_userdata('products',  $this->input->post('products'));
        return 1;
    }
    
    //GET LOCATION LIST
    private function _getLocations($id = NULL) {
        $this->load->model('inventory/products_model');
        $catarr = $this->products_model->getLocations();
        $data = '<option value="">Select</option>';
        for ($i = 0; $i < count($catarr); $i++) {
        if ($id != NULL && $id == $catarr[$i]->ID)
            $data .= "<option id=\"option_custom\" selected=\"yes\" value=\"" . $catarr[$i]->ID . "\">" . $catarr[$i]->NAME . "</option>\n";
        else
            $data .= "<option id=\"option_custom\" value=\"" . $catarr[$i]->ID . "\">" . $catarr[$i]->NAME . "</option>\n";
        }
        return $data;
    }
}
