<?php
    if (!defined('BASEPATH')) exit('No direct script access allowed');
    class Info extends CI_Controller {
        function __construct() {
            parent::__construct();
            if($this->session->user == ""){
                redirect('login');
            }
            date_default_timezone_set('Europe/Dublin');
//            $this->set_timezone();
        }
        function index() {
            //
        }
        function accessdenied() {
            $data['title'] = 'Access Denied!';
            $data['infotype'] = 'I';
            $data['message'] = 'You do not have permission to access this feature.';
            $data['mainmenu'] = $this->getmainmenu();
            $this->load->view('common/head');
            $this->load->view('common/header', $data);
            $this->load->view('settings/info_view', $data);
            $this->load->view('common/footer');
        }
        
        function wrongsql() {
            $data['title'] = 'Invalid Query !!!';
            $data['infotype'] = 'I';
            $data['message'] = 'Query that entered is wrong.Please double check the query';
            $data['mainmenu'] = $this->getmainmenu();
            $this->load->view('common/head');
            $this->load->view('common/header', $data);
            $this->load->view('settings/info_view', $data);
            $this->load->view('common/footer');
        }
        
        function errormsg() {
        // var_dump($this->db->_error_number());
            $data['title']='Database Error!';
            $data['infotype']='E';
            $data['message']=$this->db->_error_message();
            $this->load->view('settings/header');
            $this->load->view('info_view', $data);
            $this->load->view('settings/footer');
        }
        
        public function getmainmenu() {
            $this->load->model('settings/resources_model');
            return $this->resources_model->getmenu();
        }
        
        public function set_timezone() {
            $this->db->select('TIMEZONE');
            $this->db->from('CONFIGURATION');
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                date_default_timezone_set($query->row()->TIMEZONE);
            } else {
                return false;
            }
        }
        
    }