<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Trial extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	function __construct(){
            parent::__construct();
            if($this->session->user == ""){
                redirect('login');
            }
            $this->load->model('AccountModel','AccountModel');
            $this->load->model('TrialModel','TrialModel');
	}
	public function index(){
        $data['accounts'] = $this->AccountModel->dropdown_acounts();	
        $data['years'] = $this->TrialModel->get_years();
        $data['months'] = array(
			'January', 
			'February', 
			'March', 
			'April', 
			'May', 
			'June',
			'July', 
			'August', 
			'September', 
			'October', 
			'November',
			'December'
		);

		$this->load->view('templates/header');
		$this->load->view('templates/sidebar-menu');
		$this->load->view('banking/view_trial', $data);
		$this->load->view('templates/footer');
	}

	public function view_trial(){
        $ownerid=$this->session->userid;
		$columns = array( 
                            0 =>'transaction', 
							1 =>'debit',
                            2 =>'credit',
                        );

		$limit = $this->input->post('length');
        $start = $this->input->post('start');
        $order = $columns[$this->input->post('order')[0]['column']];
        $dir = $this->input->post('order')[0]['dir'];
  

        $account = $this->input->post('account'); 
        $month = $this->input->post('month');
        $year = $this->input->post('year');

        $trials =  $this->TrialModel->trials_search($limit,$start,$year,$month,$account);

        $totalFiltered = $this->TrialModel->trials_search_count($year, $month, $account);
        $totalData = $totalFiltered;

        $data = array();
        $extra_data = array();
        $extra_data['open_bal'] = $this->TrialModel->get_opening_balance($account, $year, $month);
        $extra_data['closing_bal'] = $this->TrialModel->get_closing_balance($account, $year, $month);

        if(!empty($trials))
        {
            $initial_balance = $this->AccountModel->initial_balance($ownerid, $this->input->post('account'));
            
            $all_credit = array();
            $all_debit = array();
            
            foreach ($trials as $row)
            {
                //transaction
                $transaction = $row->title;

                //debit
                if($row->types=="income")
                {
                    $debit = "0";
                    $credit = $row->final_amount;
                    $all_credit[] = $credit;
                } else if($row->types=="expense") {
                    $debit = $row->final_amount;
                    $credit = "0";
                    $all_debit[] = $debit;
                }

                //account_id
                // $account_id = $row->account_id;

                //balance


				$nestedData['transaction'] = $transaction;
                $nestedData['debit'] = $debit;
				$nestedData['credit'] = $credit;

                $data[] = $nestedData;

            }
        }
          
        $json_data = array(
                    "draw"            => intval($this->input->post('draw')),  
                    "recordsTotal"    => intval($totalData),  
                    "recordsFiltered" => intval($totalFiltered), 
                    "data"            => $data,
                    "extra_data"      => $extra_data
                    );
            
        echo json_encode($json_data);

	}


}
