<?php
    defined('BASEPATH') OR exit('No direct script access allowed');
    class Trans extends MY_Controller {
	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
	function __construct(){
            parent::__construct();
            if($this->session->user == ""){
                redirect('login');
            }
            $this->load->model('finance/TModeModel');
	}
	public function index(){
            $this->session->unset_userdata('editTransID');
            $this->load->view('common/head');
            $this->load->view('common/header');
            $this->load->view('finance/view_trans');
            $this->load->view('common/footer');
	}

	public function view_trans(){
            $ownerid=$this->session->userid;
            $columns = array( 
                0 =>'id', 
                1 =>'checkbox',
                2 =>'title',
                3 =>'budget',
                4 =>'cost'
            );
            $limit = $this->input->post('length');
            $start = $this->input->post('start');
            $order = $columns[$this->input->post('order')[0]['column']];
            $dir = $this->input->post('order')[0]['dir'];
            $totalData = $this->TranModel->all_trans_count();
            $totalFiltered = $totalData; 
            $search_array = array();  
            if(!empty($this->input->post('search')['value'])&&!empty($this->input->post('search_btn'))){
                $search_array['search'] = $this->input->post('search')['value'];
            }
            if(count($search_array)==0){            
                $trans = $this->TranModel->all_trans($limit,$start,$order,$dir);
            }else {
                $trans =  $this->TranModel->trans_search($limit,$start,$search_array,$order,$dir, $ownerid);
                $totalFiltered = $this->TranModel->trans_search_count($search_array, $ownerid);
            }
            $data = array();
            if(!empty($trans)){
                foreach ($trans as $tran){
                    //cost
                    $balance 	= ($tran->income) - $tran->expense;
                    $cost = $balance;

                    $nestedData['id'] = $tran->id;
                    $nestedData['checkbox'] = '';
                    $nestedData['title'] = $tran->title;
                    $nestedData['budget'] = $tran->budget;
                    $nestedData['cost'] = $cost;
                    $data[] = $nestedData;
                }
            }
            $json_data = array(
                "draw"            => intval($this->input->post('draw')),  
                "recordsTotal"    => intval($totalData),  
                "recordsFiltered" => intval($totalFiltered), 
                "data"            => $data   
            );
            echo json_encode($json_data); 
	}

	public function add_tran($id=0){
		$ownerid = $this->session->userid;
		if(!empty($_POST))
		{
			if($this->input->post('id')==''){
			
				$data = array('title' => $this->input->post('title'),
							'parent_id' => $this->input->post('parent_id'),
							'color' => $this->input->post('color'),
							'budget' => $this->input->post('budget')
						);

				$data['ownerid'] = $ownerid;
				$data['created_by'] = $this->session->userid;
				//test

				$this->TranModel->add_tran($data);
			}else{
				$id = $this->input->post('id');
				$data = array('title' => $this->input->post('title'),
							'parent_id' => $this->input->post('parent_id'),
							'color' => $this->input->post('color'),
							'budget' => $this->input->post('budget')
						);

				$this->TranModel->update_tran($id, $ownerid, $data);
			}
			redirect('trans');
		}
		else
		{
			$data = [];
			if ($id!=0){
				$tran = $this->TranModel->get_tran($id, $ownerid);
				$data['tran'] = $tran[0];
			}
			$data['parent_ids'] = $this->TranModel->dropdown_ttypes($id);
			$this->load->view('templates/header');
			$this->load->view('templates/sidebar-menu');
			$this->load->view('setting/add_tran', $data);
			$this->load->view('templates/footer');
		}

		
	}

	public function delete_trans(){
            if(!empty($_POST)){
                $ids = $this->input->post('id');
                $this->TranModel->delete_trans($ids);
                redirect('trans');
            }
	}
    }