<?php
    defined('BASEPATH') OR exit('No direct script access allowed');
    class Tmodes extends MY_Controller {
	/**
	 * Index Page for this controller.
	 * Maps to the following URL
	 * http://example.com/index.php/welcome
	 * - or -
	 * http://example.com/index.php/welcome/index
	 * - or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	*/
        
	function __construct() {
            parent::__construct();
            if($this->session->user == ""){
                redirect('login');
            }
            $this->load->model('finance/TModeModel');
	}
        
	public function index() {
            $this->session->unset_userdata('editTmodeID');
            $this->load->view('common/head');
            $this->load->view('common/header');
            $this->load->view('finance/view_tmodes');
            $this->load->view('common/footer');
        //    $this->load->view('templates/header');
        //    $this->load->view('templates/sidebar-menu');
        //    $this->load->view('setting/view_tmodes');
        //    $this->load->view('templates/footer');
	}
        
	public function view_tmodes(){
            $ownerid=$this->session->userid;
            $columns = array( 
                0 =>'id',
                1 =>'title',
            );
            
            $limit = $this->input->post('length');
            $start = $this->input->post('start');
//            $order = $columns[$this->input->post('order')[0]['column']];
            if($this->input->post('order')[0]['column'])
                $order = $columns[$this->input->post('order')[0]['column']];
            else
                $order = '';
            $dir = $this->input->post('order')[0]['dir'];
            $totalData = $this->TModeModel->all_tmodes_count();
            $totalFiltered = $totalData; 
            $search_array = array();  
            if(!empty($this->input->post('search')['value'])&&!empty($this->input->post('search_btn'))){
                $search_array['search'] = $this->input->post('search')['value'];
            }
            if(count($search_array)==0){            
                $tmodes = $this->TModeModel->all_tmodes($limit,$start,$order,$dir);
            }else {
                $tmodes =  $this->TModeModel->tmodes_search($limit,$start,$search_array,$order,$dir, $ownerid);
                $totalFiltered = $this->TModeModel->tmodes_search_count($search_array, $ownerid);
            }
            $data = array();
            if(!empty($tmodes)){
                foreach ($tmodes as $tmode){
                    $nestedData['id'] = $tmode->ID;
                    $nestedData['checkbox'] = '';
                    $nestedData['title'] = $tmode->TITLE;
                    $data[] = $nestedData;
                }
            }
            $json_data = array(
                "draw"            => intval($this->input->post('draw')),  
                "recordsTotal"    => intval($totalData),  
                "recordsFiltered" => intval($totalFiltered), 
                "data"            => $data   
            );
            echo json_encode($json_data); 
	}
        public function edit_tmode($id=0){
            $this->session->set_userdata(array('editTmodeID'  => $id));
            redirect("finance/Tmodes/add_tmode");
        }
	public function add_tmode($id=0) {
//            $ownerid = $this->session->userid;
            if(!empty($_POST)) {
                if($this->input->post('id')==''){
                    $data =  array('title' => $this->input->post('title'),'id' => uniqid(),
                );
                //test
                $this->TModeModel->add_tmode($data);
                }else{
                    $id = $this->input->post('id');
                    $data =  array( 'title' => $this->input->post('title'), );
                    $this->TModeModel->update_tmode($id, $data);
                }
                redirect('finance/tmodes');
            } else {
                $id =   $this->session->editTmodeID;
                $data = [];
                if ($id){
                    $tmode = $this->TModeModel->get_tmode($id);
                    $data['tmode'] = $tmode[0];
                }
                $data['template'] = 'finance/add_tmode';
                $this->load->view('template',$data);
            }
	}

//	public function delete_tmodes(){
//            if(!empty($_POST)){
//                $ids = $this->input->post('id');
//                $this->TModeModel->delete_tmodes($ids);
//                redirect('tmodes');
//            }
//	}
        public function delete_tmodes($id=0){
            $where = array('ID' => $id);
            if($this->common->delete('transactionmodes',$where)){
                $this->session->set_flashdata('success_msg', 'The record has been deleted successfuly.');
                redirect('finance/tmodes');
            }else{
                $this->session->set_flashdata('success_msg', 'Cannot Delete');
                redirect('finance/tmodes');
            }
            
	}
}
