<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Banking extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
        *   http://example.com/index.php/welcome
        *   - or -
        *   http://example.com/index.php/welcome/index
        *   - or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */

	function __construct(){
		parent::__construct();
		$this->load->library('session');
		if($this->session->username == "")
        {
            redirect('login');
        }
        $this->load->model('AccountModel','AccountModel');
		$this->load->model('BankingModel','BankingModel');

	}
	public function index()
	{
		$this->load->view('templates/header');
		$this->load->view('templates/sidebar-menu');
		$this->load->view('banking/view_banking');
		$this->load->view('templates/footer');
	}
	public function view_banking(){
		// $banking = $this->BankingModel->getBanking();
		
		$columns = array( 
                            0 =>'id', 
							1 =>'checkbox',
                            2 =>'from_account',
                            3=> 'to_account',
							4=> 'amount',
                            5=> 'created_by',
                            6=> 'created',
                        );

		$limit = $this->input->post('length');
        $start = $this->input->post('start');
        $order = $columns[$this->input->post('order')[0]['column']];
        $dir = $this->input->post('order')[0]['dir'];
  

        $totalData = $this->BankingModel->all_bankings_count();
            
        $totalFiltered = $totalData; 
            
        if(empty($this->input->post('search')['value']))
        {            
            $bankings = $this->BankingModel->all_bankings($limit,$start,$order,$dir);
        }
        elseif(!empty($this->input->post('search')['value'])&&!empty($this->input->post('search_btn'))) {
            $search = $this->input->post('search')['value']; 

            $bankings =  $this->BankingModel->bankings_search($limit,$start,$search,$order,$dir);

            $totalFiltered = $this->BankingModel->bankings_search_count($search);
        }else{
            $bankings = $this->BankingModel->all_bankings($limit,$start,$order,$dir);
        }

        $data = array();
        if(!empty($bankings))
        {
            foreach ($bankings as $banking)
            {

                $nestedData['id'] = $banking->id;
				$nestedData['checkbox'] = '<label>
                                                    <input type="checkbox">
                                                    <span class="text"></span>
                                                </label>';
                $nestedData['from_account'] = $banking->from_account;
                $nestedData['to_account'] = $banking->to_account;
				$nestedData['amount'] = $banking->amount;
                $nestedData['created_by'] = $banking->created_by;
                // $nestedData['created'] = date('j M Y h:i a',strtotime($banking->created));
				$nestedData['created'] = $banking->created;

                $data[] = $nestedData;

            }
        }
          
        $json_data = array(
                    "draw"            => intval($this->input->post('draw')),  
                    "recordsTotal"    => intval($totalData),  
                    "recordsFiltered" => intval($totalFiltered), 
                    "data"            => $data   
                    );
            
        echo json_encode($json_data); 
	}

	public function add_banking()
	{
		if(!empty($_POST))
		{
            $data =  array('from_account' => $this->input->post('from_account'),
                    'to_account' => $this->input->post('to_account'),
                    'amount' => $this->input->post('amount'),
					'created_by' => $this->input->post('created_by'),
                    );
            $data['ownerid'] = $this->session->userid;
            $date = date('Y-m-d H:i:s');
            $data['created'] = $date;
            $this->BankingModel->add_banking($data);

            $this->AccountModel->update_balance($data['from_account'], $data['amount']*(-1));
            $this->AccountModel->update_balance($data['to_account'], $data['amount']);


			redirect('banking');
		}
		else
		{
            $data['accounts'] = $this->AccountModel->dropdown_acounts();	

			$this->load->view('templates/header');
			$this->load->view('templates/sidebar-menu');
			$this->load->view('banking/add_banking',$data);
			$this->load->view('templates/footer');
		}

		
	}

    public function get_account(){
        if(!empty($_POST)){

            $id = $this->input->post('from_account');
            $account = $this->AccountModel->get_account($id);
            $data['available_balance'] = $account[0]->available_balance;
            header('Content-Type: application/json');
            echo json_encode( $data );
        }
    }


}
